/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class TerminateDriverFlyweight
extends CorrelatedMessageFlyweight {
    private static final int TOKEN_LENGTH_OFFSET = 16;
    static final int TOKEN_BUFFER_OFFSET = 20;
    private static final int MINIMUM_LENGTH = 20;

    @Override
    public TerminateDriverFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        super.wrap(buffer, offset);
        return this;
    }

    public int tokenBufferOffset() {
        return 20;
    }

    public int tokenBufferLength() {
        return this.buffer.getInt(this.offset + 16);
    }

    public TerminateDriverFlyweight tokenBuffer(DirectBuffer tokenBuffer, int tokenOffset, int tokenLength) {
        this.buffer.putInt(this.offset + 16, tokenLength);
        if (null != tokenBuffer && tokenLength > 0) {
            this.buffer.putBytes(this.offset + this.tokenBufferOffset(), tokenBuffer, tokenOffset, tokenLength);
        }
        return this;
    }

    public int length() {
        return 20 + this.tokenBufferLength();
    }

    @Override
    public void validateLength(int msgTypeId, int length) {
        if (length < 20) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short: length=" + length);
        }
        if (length - 20 < this.buffer.getInt(this.offset + 16)) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short for token buffer: length=" + length);
        }
    }

    public static int computeLength(int tokenLength) {
        if (tokenLength < 0) {
            throw new ConfigurationException("token length must be >= 0: " + tokenLength);
        }
        return 20 + tokenLength;
    }
}

