/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.archive.Catalog;
import io.aeron.archive.ControlSession;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.ChallengeEncoder;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseEncoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.RecordingDescriptorEncoder;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.archive.codecs.RecordingSignalEventEncoder;
import io.aeron.archive.codecs.RecordingSubscriptionDescriptorEncoder;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class ControlResponseProxy {
    private static final int SEND_ATTEMPTS = 3;
    private static final int MESSAGE_HEADER_LENGTH = 8;
    private static final int DESCRIPTOR_PREFIX_LENGTH = 24;
    private static final int DESCRIPTOR_CONTENT_OFFSET = 32 + RecordingDescriptorEncoder.recordingIdEncodingOffset();
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(1024);
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ControlResponseEncoder responseEncoder = new ControlResponseEncoder();
    private final RecordingDescriptorEncoder recordingDescriptorEncoder = new RecordingDescriptorEncoder();
    private final RecordingSubscriptionDescriptorEncoder recordingSubscriptionDescriptorEncoder = new RecordingSubscriptionDescriptorEncoder();
    private final RecordingSignalEventEncoder recordingSignalEventEncoder = new RecordingSignalEventEncoder();
    private final ChallengeEncoder challengeEncoder = new ChallengeEncoder();

    ControlResponseProxy() {
    }

    int sendDescriptor(long controlSessionId, long correlationId, UnsafeBuffer descriptorBuffer, ControlSession session) {
        int messageLength = Catalog.descriptorLength(descriptorBuffer) + 8;
        int contentLength = messageLength - RecordingDescriptorEncoder.recordingIdEncodingOffset() - 8;
        this.recordingDescriptorEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId);
        int attempts = 3;
        ExclusivePublication publication = session.controlPublication();
        do {
            long result;
            if ((result = publication.offer(this.buffer, 0, 24, descriptorBuffer, DESCRIPTOR_CONTENT_OFFSET, contentLength)) > 0L) {
                return messageLength;
            }
            ControlResponseProxy.checkResult(session, result);
        } while (--attempts > 0);
        return 0;
    }

    boolean sendSubscriptionDescriptor(long controlSessionId, long correlationId, Subscription subscription, ControlSession session) {
        this.recordingSubscriptionDescriptorEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).subscriptionId(subscription.registrationId()).streamId(subscription.streamId()).strippedChannel(subscription.channel());
        int length = 8 + this.recordingSubscriptionDescriptorEncoder.encodedLength();
        return this.send(session, this.buffer, length);
    }

    boolean sendResponse(long controlSessionId, long correlationId, long relevantId, ControlResponseCode code, String errorMessage, ControlSession session) {
        this.responseEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).relevantId(relevantId).code(code).version(AeronArchive.Configuration.PROTOCOL_SEMANTIC_VERSION).errorMessage(errorMessage);
        return this.sendResponseHook(session, this.buffer, 8 + this.responseEncoder.encodedLength());
    }

    boolean sendChallenge(long controlSessionId, long correlationId, byte[] encodedChallenge, ControlSession session) {
        this.challengeEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).putEncodedChallenge(encodedChallenge, 0, encodedChallenge.length);
        return this.send(session, this.buffer, 8 + this.challengeEncoder.encodedLength());
    }

    boolean sendSignal(long controlSessionId, long correlationId, long recordingId, long subscriptionId, long position, RecordingSignal recordingSignal, Publication controlPublication) {
        int messageLength = 52;
        int attempts = 3;
        do {
            long result;
            if ((result = controlPublication.tryClaim(52, this.bufferClaim)) <= 0L) continue;
            MutableDirectBuffer buffer = this.bufferClaim.buffer();
            int bufferOffset = this.bufferClaim.offset();
            this.recordingSignalEventEncoder.wrapAndApplyHeader(buffer, bufferOffset, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).subscriptionId(subscriptionId).position(position).signal(recordingSignal);
            this.bufferClaim.commit();
            return true;
        } while (--attempts > 0);
        return false;
    }

    private boolean sendResponseHook(ControlSession session, DirectBuffer buffer, int length) {
        return this.send(session, buffer, length);
    }

    private boolean send(ControlSession session, DirectBuffer buffer, int length) {
        int attempts = 3;
        do {
            long result;
            if ((result = session.controlPublication().offer(buffer, 0, length)) > 0L) {
                return true;
            }
            ControlResponseProxy.checkResult(session, result);
        } while (--attempts > 0);
        return false;
    }

    private static void checkResult(ControlSession session, long result) {
        if (result == -1L) {
            session.abort();
            throw new ArchiveException("response publication is not connected: " + session, AeronException.Category.WARN);
        }
        if (result == -4L) {
            session.abort();
            throw new ArchiveException("response publication is closed: " + session);
        }
        if (result == -5L) {
            session.abort();
            throw new ArchiveException("response publication at max position: " + session);
        }
    }
}

