/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.archive.ArchiveMarkFile;
import io.aeron.archive.ArchiveMigrationPlanner;
import io.aeron.archive.ArchiveMigrationStep;
import io.aeron.archive.Catalog;
import io.aeron.archive.MigrationUtils;
import io.aeron.archive.RecordingReader;
import io.aeron.archive.RecordingSummary;
import io.aeron.archive.ReplaySession;
import io.aeron.archive.checksum.Checksum;
import io.aeron.archive.checksum.Checksums;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.CatalogHeaderEncoder;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.archive.codecs.RecordingDescriptorEncoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderDecoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderEncoder;
import io.aeron.archive.codecs.RecordingState;
import io.aeron.archive.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.HeaderFlyweight;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.IoUtil;
import org.agrona.PrintBufferUtil;
import org.agrona.Strings;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.UnsafeBuffer;

public class ArchiveTool {
    public static void main(String[] args) {
        File archiveDir;
        if (args.length == 0 || args.length > 6) {
            ArchiveTool.printHelp();
            System.exit(-1);
        }
        if (!(archiveDir = new File(args[0])).exists()) {
            System.err.println("ERR: Archive folder not found: " + archiveDir.getAbsolutePath());
            ArchiveTool.printHelp();
            System.exit(-1);
        }
        PrintStream out = System.out;
        if (args.length == 2 && "describe".equals(args[1])) {
            ArchiveTool.describe(out, archiveDir);
        } else if (args.length == 3 && "describe".equals(args[1])) {
            ArchiveTool.describeRecording(out, archiveDir, Long.parseLong(args[2]));
        } else if (args.length >= 2 && "dump".equals(args[1])) {
            ArchiveTool.dump(out, archiveDir, args.length >= 3 ? Long.parseLong(args[2]) : Long.MAX_VALUE, ArchiveTool::continueOnFrameLimit);
        } else if (args.length == 2 && "errors".equals(args[1])) {
            ArchiveTool.printErrors(out, archiveDir);
        } else if (args.length == 2 && "pid".equals(args[1])) {
            out.println(ArchiveTool.pid(archiveDir));
        } else if (args.length >= 2 && "verify".equals(args[1])) {
            boolean hasErrors;
            if (args.length == 2) {
                hasErrors = !ArchiveTool.verify(out, archiveDir, Collections.emptySet(), null, ArchiveTool::truncateOnPageStraddle);
            } else if (args.length == 3) {
                hasErrors = VerifyOption.VERIFY_ALL_SEGMENT_FILES == VerifyOption.byFlag(args[2]) ? !ArchiveTool.verify(out, archiveDir, EnumSet.of(VerifyOption.VERIFY_ALL_SEGMENT_FILES), null, ArchiveTool::truncateOnPageStraddle) : !ArchiveTool.verifyRecording(out, archiveDir, Long.parseLong(args[2]), Collections.emptySet(), null, ArchiveTool::truncateOnPageStraddle);
            } else if (args.length == 4) {
                hasErrors = VerifyOption.APPLY_CHECKSUM == VerifyOption.byFlag(args[2]) ? !ArchiveTool.verify(out, archiveDir, EnumSet.of(VerifyOption.APPLY_CHECKSUM), ArchiveTool.validateChecksumClass(args[3]), ArchiveTool::truncateOnPageStraddle) : !ArchiveTool.verifyRecording(out, archiveDir, Long.parseLong(args[2]), EnumSet.of(VerifyOption.VERIFY_ALL_SEGMENT_FILES), null, ArchiveTool::truncateOnPageStraddle);
            } else if (args.length == 5) {
                hasErrors = VerifyOption.VERIFY_ALL_SEGMENT_FILES == VerifyOption.byFlag(args[2]) ? !ArchiveTool.verify(out, archiveDir, EnumSet.allOf(VerifyOption.class), ArchiveTool.validateChecksumClass(args[4]), ArchiveTool::truncateOnPageStraddle) : !ArchiveTool.verifyRecording(out, archiveDir, Long.parseLong(args[2]), EnumSet.of(VerifyOption.APPLY_CHECKSUM), ArchiveTool.validateChecksumClass(args[4]), ArchiveTool::truncateOnPageStraddle);
            } else {
                boolean bl = hasErrors = !ArchiveTool.verifyRecording(out, archiveDir, Long.parseLong(args[2]), EnumSet.allOf(VerifyOption.class), ArchiveTool.validateChecksumClass(args[5]), ArchiveTool::truncateOnPageStraddle);
            }
            if (hasErrors) {
                System.exit(-1);
            }
        } else if (args.length >= 3 && "checksum".equals(args[1])) {
            if (args.length == 3) {
                ArchiveTool.checksum(out, archiveDir, false, args[2]);
            } else if ("-a".equals(args[3])) {
                ArchiveTool.checksum(out, archiveDir, true, args[2]);
            } else {
                ArchiveTool.checksumRecording(out, archiveDir, Long.parseLong(args[3]), args.length > 4 && "-a".equals(args[4]), args[2]);
            }
        } else if (args.length == 2 && "count-entries".equals(args[1])) {
            out.println(ArchiveTool.entryCount(archiveDir));
        } else if (args.length == 2 && "max-entries".equals(args[1])) {
            out.println(ArchiveTool.maxEntries(archiveDir));
        } else if (args.length == 3 && "max-entries".equals(args[1])) {
            out.println(ArchiveTool.maxEntries(archiveDir, Long.parseLong(args[2])));
        } else if (args.length == 2 && "migrate".equals(args[1])) {
            out.print("WARNING: please ensure archive is not running and that a backup has been taken of the archive directory before attempting migration(s).");
            if (ArchiveTool.readContinueAnswer("Continue? (y/n)")) {
                ArchiveTool.migrate(out, archiveDir);
            }
        } else if (args.length == 2 && "compact".equals(args[1])) {
            out.print("WARNING: Compacting the Catalog is non-recoverable operation! All recordings in state `INVALID` will be deleted along with the corresponding segment files.");
            if (ArchiveTool.readContinueAnswer("Continue? (y/n)")) {
                ArchiveTool.compact(out, archiveDir);
            }
        } else if (args.length == 2 && "delete-orphaned-segments".equals(args[1])) {
            out.print("WARNING: All orphaned segment files will be deleted.");
            if (ArchiveTool.readContinueAnswer("Continue? (y/n)")) {
                ArchiveTool.deleteOrphanedSegments(out, archiveDir);
            }
        } else {
            System.err.println("ERR: Invalid command");
            ArchiveTool.printHelp();
            System.exit(-1);
        }
    }

    @Deprecated
    public static int maxEntries(File archiveDir) {
        try (Catalog catalog = ArchiveTool.openCatalogReadOnly(archiveDir, SystemEpochClock.INSTANCE);){
            int n = (int)(catalog.capacity() / 1024L);
            return n;
        }
    }

    @Deprecated
    public static int maxEntries(File archiveDir, long newMaxEntries) {
        long capacity = newMaxEntries * 1024L;
        try (Catalog catalog = new Catalog(archiveDir, null, 0, capacity, SystemEpochClock.INSTANCE, null, null);){
            int n = (int)(catalog.capacity() / 1024L);
            return n;
        }
    }

    public static long capacity(File archiveDir) {
        try (Catalog catalog = ArchiveTool.openCatalogReadOnly(archiveDir, SystemEpochClock.INSTANCE);){
            long l = catalog.capacity();
            return l;
        }
    }

    public static long capacity(File archiveDir, long newCapacity) {
        try (Catalog catalog = ArchiveTool.openCatalogReadWrite(archiveDir, SystemEpochClock.INSTANCE, newCapacity, null, null);){
            long l = catalog.capacity();
            return l;
        }
    }

    public static void describe(PrintStream out, File archiveDir) {
        try (Catalog catalog = ArchiveTool.openCatalogReadOnly(archiveDir, SystemEpochClock.INSTANCE);
             ArchiveMarkFile markFile = ArchiveTool.openMarkFile(archiveDir, out::println);){
            ArchiveTool.printMarkInformation(markFile, out);
            out.println("Catalog capacity in bytes: " + catalog.capacity());
            catalog.forEach((recordingDescriptorOffset, he, hd, e, d) -> out.println(d));
        }
    }

    public static void describeRecording(PrintStream out, File archiveDir, long recordingId) {
        try (Catalog catalog = ArchiveTool.openCatalogReadOnly(archiveDir, SystemEpochClock.INSTANCE);){
            catalog.forEntry(recordingId, (recordingDescriptorOffset, he, hd, e, d) -> out.println(d));
        }
    }

    public static int entryCount(File archiveDir) {
        try (Catalog catalog = ArchiveTool.openCatalogReadOnly(archiveDir, SystemEpochClock.INSTANCE);){
            int n = catalog.entryCount();
            return n;
        }
    }

    public static long pid(File archiveDir) {
        try (ArchiveMarkFile markFile = ArchiveTool.openMarkFile(archiveDir, null);){
            long l = markFile.decoder().pid();
            return l;
        }
    }

    public static void printErrors(PrintStream out, File archiveDir) {
        try (ArchiveMarkFile markFile = ArchiveTool.openMarkFile(archiveDir, null);){
            ArchiveTool.printErrors(out, markFile);
        }
    }

    public static void dump(PrintStream out, File archiveDir, long fragmentCountLimit, ActionConfirmation<Long> confirmActionOnFragmentCountLimit) {
        try (Catalog catalog = ArchiveTool.openCatalogReadOnly(archiveDir, SystemEpochClock.INSTANCE);
             ArchiveMarkFile markFile = ArchiveTool.openMarkFile(archiveDir, out::println);){
            ArchiveTool.printMarkInformation(markFile, out);
            out.println("Catalog capacity in bytes: " + catalog.capacity());
            out.println();
            out.println("Dumping up to " + fragmentCountLimit + " fragments per recording");
            catalog.forEach((recordingDescriptorOffset, headerEncoder, headerDecoder, descriptorEncoder, descriptorDecoder) -> ArchiveTool.dump(out, archiveDir, catalog, fragmentCountLimit, confirmActionOnFragmentCountLimit, headerDecoder, descriptorDecoder));
        }
    }

    public static boolean verify(PrintStream out, File archiveDir, Set<VerifyOption> options, String checksumClassName, ActionConfirmation<File> truncateOnPageStraddle) {
        Checksum checksum = ArchiveTool.createChecksum(options, checksumClassName);
        return ArchiveTool.verify(out, archiveDir, options, checksum, SystemEpochClock.INSTANCE, truncateOnPageStraddle);
    }

    public static boolean verifyRecording(PrintStream out, File archiveDir, long recordingId, Set<VerifyOption> options, String checksumClassName, ActionConfirmation<File> truncateOnPageStraddle) {
        return ArchiveTool.verifyRecording(out, archiveDir, recordingId, options, ArchiveTool.createChecksum(options, checksumClassName), SystemEpochClock.INSTANCE, truncateOnPageStraddle);
    }

    public static void checksum(PrintStream out, File archiveDir, boolean allFiles, String checksumClassName) {
        ArchiveTool.checksum(out, archiveDir, allFiles, Checksums.newInstance(ArchiveTool.validateChecksumClass(checksumClassName)), SystemEpochClock.INSTANCE);
    }

    public static void checksumRecording(PrintStream out, File archiveDir, long recordingId, boolean allFiles, String checksumClassName) {
        ArchiveTool.checksumRecording(out, archiveDir, recordingId, allFiles, Checksums.newInstance(ArchiveTool.validateChecksumClass(checksumClassName)), SystemEpochClock.INSTANCE);
    }

    public static void migrate(PrintStream out, File archiveDir) {
        SystemEpochClock epochClock = SystemEpochClock.INSTANCE;
        try {
            int markFileVersion;
            IntConsumer noVersionCheck = version -> {};
            ArchiveMarkFile markFile = ArchiveTool.openMarkFileReadWrite(archiveDir, epochClock);
            Object object = null;
            try (Catalog catalog2 = ArchiveTool.openCatalogReadWrite(archiveDir, epochClock, 32L, null, noVersionCheck);){
                markFileVersion = markFile.decoder().version();
                out.println("MarkFile version=" + MigrationUtils.fullVersionString(markFileVersion));
                out.println("Catalog version=" + MigrationUtils.fullVersionString(catalog2.version()));
                out.println("Latest version=" + MigrationUtils.fullVersionString(ArchiveMarkFile.SEMANTIC_VERSION));
            }
            catch (Throwable catalog2) {
                object = catalog2;
                throw catalog2;
            }
            finally {
                if (markFile != null) {
                    if (object != null) {
                        try {
                            markFile.close();
                        }
                        catch (Throwable catalog2) {
                            ((Throwable)object).addSuppressed(catalog2);
                        }
                    } else {
                        markFile.close();
                    }
                }
            }
            List<ArchiveMigrationStep> steps = ArchiveMigrationPlanner.createPlan(markFileVersion);
            for (ArchiveMigrationStep step : steps) {
                ArchiveMarkFile markFile2 = ArchiveTool.openMarkFileReadWrite(archiveDir, epochClock);
                Throwable throwable = null;
                try {
                    Catalog catalog = ArchiveTool.openCatalogReadWrite(archiveDir, epochClock, 32L, null, noVersionCheck);
                    Throwable throwable2 = null;
                    try {
                        out.println("Migration step " + step.toString());
                        step.migrate(out, markFile2, catalog, archiveDir);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (catalog == null) continue;
                        if (throwable2 != null) {
                            try {
                                catalog.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        catalog.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (markFile2 == null) continue;
                    if (throwable != null) {
                        try {
                            markFile2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    markFile2.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(out);
        }
    }

    public static void compact(PrintStream out, File archiveDir) {
        ArchiveTool.compact(out, archiveDir, SystemEpochClock.INSTANCE);
    }

    public static void deleteOrphanedSegments(PrintStream out, File archiveDir) {
        ArchiveTool.deleteOrphanedSegments(out, archiveDir, SystemEpochClock.INSTANCE);
    }

    static void deleteOrphanedSegments(PrintStream out, File archiveDir, EpochClock epochClock) {
        try (Catalog catalog = ArchiveTool.openCatalogReadOnly(archiveDir, epochClock);){
            catalog.forEach((recordingDescriptorOffset, headerEncoder, headerDecoder, descriptorEncoder, descriptorDecoder) -> {
                ArrayList<String> files = Catalog.listSegmentFiles(archiveDir, descriptorDecoder.recordingId());
                ArchiveTool.deleteOrphanedSegmentFiles(out, archiveDir, descriptorDecoder, files);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compact(PrintStream out, File archiveDir, EpochClock epochClock) {
        File compactFile = new File(archiveDir, "archive.catalog.compact");
        try {
            Path compactFilePath = compactFile.toPath();
            try (FileChannel channel = FileChannel.open(compactFilePath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                 Catalog catalog = ArchiveTool.openCatalogReadOnly(archiveDir, epochClock);){
                MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
                mappedByteBuffer.order(CatalogHeaderEncoder.BYTE_ORDER);
                try {
                    UnsafeBuffer unsafeBuffer = new UnsafeBuffer(mappedByteBuffer);
                    new CatalogHeaderEncoder().wrap(unsafeBuffer, 0).version(catalog.version()).length(32).nextRecordingId(catalog.nextRecordingId()).alignment(catalog.alignment());
                    MutableInteger offset = new MutableInteger(32);
                    MutableInteger deletedRecords = new MutableInteger();
                    MutableInteger reclaimedBytes = new MutableInteger();
                    catalog.forEach((recordingDescriptorOffset, headerEncoder, headerDecoder, descriptorEncoder, descriptorDecoder) -> {
                        int frameLength = headerDecoder.encodedLength() + headerDecoder.length();
                        if (RecordingState.INVALID == headerDecoder.state()) {
                            deletedRecords.increment();
                            reclaimedBytes.addAndGet(frameLength);
                            ArrayList<String> segmentFiles = Catalog.listSegmentFiles(archiveDir, descriptorDecoder.recordingId());
                            for (String segmentFile : segmentFiles) {
                                IoUtil.deleteIfExists(new File(archiveDir, segmentFile));
                            }
                        } else {
                            int index = offset.getAndAdd(frameLength);
                            unsafeBuffer.putBytes(index, headerDecoder.buffer(), 0, frameLength);
                        }
                    });
                    out.println("Compaction result: deleted " + deletedRecords.get() + " records and reclaimed " + reclaimedBytes.get() + " bytes");
                }
                finally {
                    BufferUtil.free(mappedByteBuffer);
                }
            }
            Path catalogFilePath = compactFilePath.resolveSibling("archive.catalog");
            Files.delete(catalogFilePath);
            Files.move(compactFilePath, catalogFilePath, new CopyOption[0]);
        }
        catch (IOException ex) {
            ex.printStackTrace(out);
        }
        finally {
            IoUtil.deleteIfExists(compactFile);
        }
    }

    static boolean verify(PrintStream out, File archiveDir, Set<VerifyOption> options, Checksum checksum, EpochClock epochClock, ActionConfirmation<File> truncateOnPageStraddle) {
        try (Catalog catalog = ArchiveTool.openCatalogReadWrite(archiveDir, epochClock, 32L, checksum, null);){
            MutableInteger errorCount = new MutableInteger();
            catalog.forEach(ArchiveTool.createVerifyEntryProcessor(out, archiveDir, options, catalog, checksum, epochClock, errorCount, truncateOnPageStraddle));
            boolean bl = errorCount.get() == 0;
            return bl;
        }
    }

    static boolean verifyRecording(PrintStream out, File archiveDir, long recordingId, Set<VerifyOption> options, Checksum checksum, EpochClock epochClock, ActionConfirmation<File> truncateOnPageStraddle) {
        try (Catalog catalog = ArchiveTool.openCatalogReadWrite(archiveDir, epochClock, 32L, checksum, null);){
            MutableInteger errorCount = new MutableInteger();
            if (!catalog.forEntry(recordingId, ArchiveTool.createVerifyEntryProcessor(out, archiveDir, options, catalog, checksum, epochClock, errorCount, truncateOnPageStraddle))) {
                throw new AeronException("no recording found with recordingId: " + recordingId);
            }
            boolean bl = errorCount.get() == 0;
            return bl;
        }
    }

    static Catalog openCatalogReadOnly(File archiveDir, EpochClock epochClock) {
        return new Catalog(archiveDir, epochClock);
    }

    static Catalog openCatalogReadWrite(File archiveDir, EpochClock epochClock, long capacity, Checksum checksum, IntConsumer versionCheck) {
        return new Catalog(archiveDir, epochClock, capacity, true, checksum, versionCheck);
    }

    private static String validateChecksumClass(String checksumClassName) {
        String className;
        String string = className = null == checksumClassName ? null : checksumClassName.trim();
        if (Strings.isEmpty(className)) {
            throw new IllegalArgumentException("Checksum class name must be specified!");
        }
        return className;
    }

    private static Checksum createChecksum(Set<VerifyOption> options, String checksumClassName) {
        if (null == checksumClassName) {
            if (options.contains((Object)VerifyOption.APPLY_CHECKSUM)) {
                throw new IllegalArgumentException("Checksum class name is required when " + (Object)((Object)VerifyOption.APPLY_CHECKSUM) + " option is specified!");
            }
            return null;
        }
        return Checksums.newInstance(checksumClassName);
    }

    private static Catalog.CatalogEntryProcessor createVerifyEntryProcessor(PrintStream out, File archiveDir, Set<VerifyOption> options, Catalog catalog, Checksum checksum, EpochClock epochClock, MutableInteger errorCount, ActionConfirmation<File> truncateOnPageStraddle) {
        ByteBuffer buffer = BufferUtil.allocateDirectAligned(0x100000, 64);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        DataHeaderFlyweight headerFlyweight = new DataHeaderFlyweight(buffer);
        return (recordingDescriptorOffset, headerEncoder, headerDecoder, descriptorEncoder, descriptorDecoder) -> ArchiveTool.verifyRecording(out, archiveDir, options, catalog, checksum, epochClock, errorCount, truncateOnPageStraddle, headerFlyweight, recordingDescriptorOffset, headerEncoder, headerDecoder, descriptorEncoder, descriptorDecoder);
    }

    private static boolean truncateOnPageStraddle(File maxSegmentFile) {
        return ArchiveTool.readContinueAnswer(String.format("Last fragment in segment file: %s straddles a page boundary,%ni.e. it is not possible to verify if it was written correctly.%n%nPlease choose the corrective action: (y) to truncate the file or (n) to do nothing", maxSegmentFile.getAbsolutePath()));
    }

    private static boolean continueOnFrameLimit(Long frameLimit) {
        return ArchiveTool.readContinueAnswer("Specified frame limit " + frameLimit + " reached. Continue? (y/n)");
    }

    private static boolean readContinueAnswer(String msg) {
        System.out.printf("%n" + msg + ": ", new Object[0]);
        String answer = new Scanner(System.in).nextLine();
        return answer.isEmpty() || answer.equalsIgnoreCase("y") || answer.equalsIgnoreCase("yes");
    }

    private static ArchiveMarkFile openMarkFile(File archiveDir, Consumer<String> logger) {
        return new ArchiveMarkFile(archiveDir, "archive-mark.dat", SystemEpochClock.INSTANCE, TimeUnit.SECONDS.toMillis(5L), logger);
    }

    private static ArchiveMarkFile openMarkFileReadWrite(File archiveDir, EpochClock epochClock) {
        return new ArchiveMarkFile(archiveDir, "archive-mark.dat", epochClock, TimeUnit.SECONDS.toMillis(5L), version -> {}, null);
    }

    private static void dump(PrintStream out, File archiveDir, Catalog catalog, long fragmentCountLimit, ActionConfirmation<Long> continueActionOnFragmentLimit, RecordingDescriptorHeaderDecoder header, RecordingDescriptorDecoder descriptor) {
        long stopPosition = descriptor.stopPosition();
        long streamLength = stopPosition - descriptor.startPosition();
        out.printf("%n%nRecording %d %n  channel: %s%n  streamId: %d%n  stream length: %d%n", descriptor.recordingId(), descriptor.strippedChannel(), descriptor.streamId(), -1L == stopPosition ? -1L : streamLength);
        out.println(header);
        out.println(descriptor);
        if (0L == streamLength) {
            out.println("Recording is empty");
            return;
        }
        RecordingReader reader = new RecordingReader(catalog.recordingSummary(descriptor.recordingId(), new RecordingSummary()), archiveDir, descriptor.startPosition(), -1L);
        boolean isActive = true;
        long fragmentCount = fragmentCountLimit;
        do {
            out.println();
            out.print("Frame at position [" + reader.replayPosition() + "] ");
            reader.poll((buffer, offset, length, frameType, flags, reservedValue) -> {
                out.println("data at offset [" + offset + "] with length = " + length);
                if (0 == frameType) {
                    out.println("PADDING FRAME");
                } else if (1 == frameType) {
                    if ((flags & 0xFFFFFFC0) != -64) {
                        String suffix = (flags & 0xFFFFFF80) == -128 ? "BEGIN_FRAGMENT" : "";
                        suffix = suffix + ((flags & 0x40) == 64 ? "END_FRAGMENT" : "");
                        out.println("Fragmented frame. " + suffix);
                    }
                    out.println(PrintBufferUtil.prettyHexDump(buffer, offset, length));
                } else {
                    out.println("Unexpected frame type " + frameType);
                }
            }, 1);
            if (--fragmentCount != 0L) continue;
            fragmentCount = fragmentCountLimit;
            if (-1L != stopPosition) {
                out.printf("%d bytes (from %d) remaining in recording %d%n", streamLength - reader.replayPosition(), streamLength, descriptor.recordingId());
            }
            isActive = continueActionOnFragmentLimit.confirm(fragmentCountLimit);
        } while (!reader.isDone() && isActive);
    }

    private static void printMarkInformation(ArchiveMarkFile markFile, PrintStream out) {
        out.format("%1$tH:%1$tM:%1$tS (start: %2$tF %2$tH:%2$tM:%2$tS, activity: %3$tF %3$tH:%3$tM:%3$tS)%n", new Date(), new Date(markFile.decoder().startTimestamp()), new Date(markFile.activityTimestampVolatile()));
        out.println(markFile.decoder());
    }

    private static void verifyRecording(PrintStream out, File archiveDir, Set<VerifyOption> options, Catalog catalog, Checksum checksum, EpochClock epochClock, MutableInteger errorCount, ActionConfirmation<File> truncateOnPageStraddle, DataHeaderFlyweight headerFlyweight, int recordingDescriptorOffset, RecordingDescriptorHeaderEncoder headerEncoder, RecordingDescriptorHeaderDecoder headerDecoder, RecordingDescriptorEncoder encoder, RecordingDescriptorDecoder decoder) {
        int recordingDescriptorChecksum;
        long computedStopPosition;
        String maxSegmentFile;
        long stopPosition;
        long startPosition;
        long recordingId = decoder.recordingId();
        if (ArchiveTool.isPositionInvariantViolated(out, recordingId, startPosition = decoder.startPosition(), stopPosition = decoder.stopPosition())) {
            errorCount.increment();
            headerEncoder.state(RecordingState.INVALID);
            return;
        }
        int segmentLength = decoder.segmentFileLength();
        int termLength = decoder.termBufferLength();
        ArrayList<String> segmentFiles = Catalog.listSegmentFiles(archiveDir, recordingId);
        try {
            long maxSegmentPosition;
            maxSegmentFile = Catalog.findSegmentFileWithHighestPosition(segmentFiles);
            if (maxSegmentFile != null && (startPosition > (maxSegmentPosition = Catalog.parseSegmentFilePosition(maxSegmentFile) + (long)(segmentLength - 1)) || stopPosition > maxSegmentPosition)) {
                out.println("(recordingId=" + recordingId + ") ERR: Invariant violation: startPosition=" + startPosition + " and/or stopPosition=" + stopPosition + " exceed max segment file position=" + maxSegmentPosition);
                errorCount.increment();
                headerEncoder.state(RecordingState.INVALID);
                return;
            }
            computedStopPosition = Catalog.computeStopPosition(archiveDir, maxSegmentFile, startPosition, termLength, segmentLength, checksum, headerFlyweight, truncateOnPageStraddle::confirm);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            out.println("(recordingId=" + recordingId + ") ERR: " + (null != message ? message : ex.toString()));
            errorCount.increment();
            headerEncoder.state(RecordingState.INVALID);
            return;
        }
        boolean applyChecksum = options.contains((Object)VerifyOption.APPLY_CHECKSUM);
        if (applyChecksum && (recordingDescriptorChecksum = catalog.computeRecordingDescriptorChecksum(recordingDescriptorOffset, headerDecoder.length())) != headerDecoder.checksum()) {
            out.println("(recordingId=" + recordingId + ") ERR: invalid Catalog checksum: expected=" + recordingDescriptorChecksum + ", actual=" + headerDecoder.checksum());
            errorCount.increment();
            headerEncoder.state(RecordingState.INVALID);
            return;
        }
        if (null != maxSegmentFile) {
            int streamId = decoder.streamId();
            if (options.contains((Object)VerifyOption.VERIFY_ALL_SEGMENT_FILES)) {
                for (String filename : segmentFiles) {
                    if (!ArchiveTool.isInvalidSegmentFile(out, archiveDir, recordingId, filename, startPosition, termLength, segmentLength, streamId, decoder.initialTermId(), applyChecksum, checksum, headerFlyweight)) continue;
                    errorCount.increment();
                    headerEncoder.state(RecordingState.INVALID);
                    return;
                }
            } else if (ArchiveTool.isInvalidSegmentFile(out, archiveDir, recordingId, maxSegmentFile, startPosition, termLength, segmentLength, streamId, decoder.initialTermId(), applyChecksum, checksum, headerFlyweight)) {
                errorCount.increment();
                headerEncoder.state(RecordingState.INVALID);
                return;
            }
        }
        if (computedStopPosition != stopPosition) {
            encoder.stopPosition(computedStopPosition);
            encoder.stopTimestamp(epochClock.time());
        }
        headerEncoder.state(RecordingState.VALID);
        out.println("(recordingId=" + recordingId + ") OK");
    }

    private static boolean isPositionInvariantViolated(PrintStream out, long recordingId, long startPosition, long stopPosition) {
        if (startPosition < 0L) {
            out.println("(recordingId=" + recordingId + ") ERR: Negative startPosition=" + startPosition);
            return true;
        }
        if (ArchiveTool.isNotFrameAligned(startPosition)) {
            out.println("(recordingId=" + recordingId + ") ERR: Non-aligned startPosition=" + startPosition);
            return true;
        }
        if (stopPosition != -1L) {
            if (stopPosition < startPosition) {
                out.println("(recordingId=" + recordingId + ") ERR: Invariant violation stopPosition=" + stopPosition + " is before startPosition=" + startPosition);
                return true;
            }
            if (ArchiveTool.isNotFrameAligned(stopPosition)) {
                out.println("(recordingId=" + recordingId + ") ERR: Non-aligned stopPosition=" + stopPosition);
                return true;
            }
        }
        return false;
    }

    private static boolean isNotFrameAligned(long position) {
        return 0L != (position & 0x1FL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isInvalidSegmentFile(PrintStream out, File archiveDir, long recordingId, String fileName, long startPosition, int termLength, int segmentLength, int streamId, int initialTermId, boolean applyChecksum, Checksum checksum, DataHeaderFlyweight headerFlyweight) {
        File file = new File(archiveDir, fileName);
        try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            int alignedFrameLength;
            long offsetLimit = Math.min((long)segmentLength, channel.size());
            int positionBitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
            long startTermOffset = startPosition & (long)(termLength - 1);
            long startTermBasePosition = startPosition - startTermOffset;
            long segmentFileBasePosition = Catalog.parseSegmentFilePosition(fileName);
            ByteBuffer byteBuffer = headerFlyweight.byteBuffer();
            long bufferAddress = headerFlyweight.addressOffset();
            long fileOffset = segmentFileBasePosition == startTermBasePosition ? startTermOffset : 0L;
            long position = segmentFileBasePosition + fileOffset;
            do {
                int computedChecksum;
                int termOffset;
                byteBuffer.clear().limit(32);
                if (32 != channel.read(byteBuffer, fileOffset)) {
                    out.println("(recordingId=" + recordingId + ", file=" + file + ") ERR: failed to read fragment header");
                    boolean bl = true;
                    return bl;
                }
                int frameLength = headerFlyweight.frameLength();
                if (0 == frameLength) {
                    return false;
                }
                int termId = LogBufferDescriptor.computeTermIdFromPosition(position, positionBitsToShift, initialTermId);
                if (ReplaySession.isInvalidHeader(headerFlyweight, streamId, termId, termOffset = (int)(position & (long)(termLength - 1)))) {
                    out.println("(recordingId=" + recordingId + ", file=" + file + ") ERR: fragment termOffset=" + headerFlyweight.termOffset() + " (expected=" + termOffset + "), termId=" + headerFlyweight.termId() + " (expected=" + termId + "), streamId=" + headerFlyweight.streamId() + " (expected=" + streamId + ")");
                    boolean bl = true;
                    return bl;
                }
                int frameType = FrameDescriptor.frameType(headerFlyweight, 0);
                int sessionId = FrameDescriptor.frameSessionId(headerFlyweight, 0);
                alignedFrameLength = BitUtil.align(frameLength, 32);
                int dataLength = alignedFrameLength - 32;
                byteBuffer.clear().limit(dataLength);
                if (dataLength != channel.read(byteBuffer, fileOffset + 32L)) {
                    out.println("(recordingId=" + recordingId + ", file=" + file + ") ERR: failed to read " + dataLength + " byte(s) of data at offset " + (fileOffset + 32L));
                    boolean bl = true;
                    return bl;
                }
                if (applyChecksum && 1 == frameType && (computedChecksum = checksum.compute(bufferAddress, 0, dataLength)) != sessionId) {
                    out.println("(recordingId=" + recordingId + ", file=" + file + ") ERR: checksum failed recorded=" + sessionId + " (expected=" + computedChecksum + ")");
                    boolean bl = true;
                    return bl;
                }
                position += (long)alignedFrameLength;
            } while ((fileOffset += (long)alignedFrameLength) < offsetLimit);
            return false;
        }
        catch (IOException ex) {
            out.println("(recordingId=" + recordingId + ", file=" + file + ") ERR: failed to verify file");
            ex.printStackTrace(out);
            return true;
        }
    }

    private static void printErrors(PrintStream out, ArchiveMarkFile markFile) {
        out.println("Archive error log:");
        CommonContext.printErrorLog(markFile.errorBuffer(), out);
        MarkFileHeaderDecoder decoder = markFile.decoder();
        decoder.skipControlChannel();
        decoder.skipLocalControlChannel();
        decoder.skipEventsChannel();
        String aeronDirectory = decoder.aeronDirectory();
        out.println();
        out.println("Aeron driver error log (directory: " + aeronDirectory + "):");
        File cncFile = new File(aeronDirectory, "cnc.dat");
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, FileChannel.MapMode.READ_ONLY, "cnc");
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        CncFileDescriptor.checkVersion(cncVersion);
        CommonContext.printErrorLog(CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, cncMetaDataBuffer), out);
    }

    static void checksumRecording(PrintStream out, File archiveDir, long recordingId, boolean allFiles, Checksum checksum, EpochClock epochClock) {
        try (Catalog catalog = ArchiveTool.openCatalogReadWrite(archiveDir, epochClock, 32L, checksum, null);){
            Catalog.CatalogEntryProcessor catalogEntryProcessor = (recordingDescriptorOffset, headerEncoder, headerDecoder, descriptorEncoder, descriptorDecoder) -> {
                ByteBuffer buffer = ByteBuffer.allocateDirect(BitUtil.align(descriptorDecoder.mtuLength(), 64));
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                catalog.updateChecksum(recordingDescriptorOffset);
                ArchiveTool.checksum(buffer, out, archiveDir, allFiles, checksum, descriptorDecoder);
            };
            if (!catalog.forEntry(recordingId, catalogEntryProcessor)) {
                throw new AeronException("no recording found with recordingId: " + recordingId);
            }
        }
    }

    private static void checksum(ByteBuffer buffer, PrintStream out, File archiveDir, boolean allFiles, Checksum checksum, RecordingDescriptorDecoder descriptorDecoder) {
        long recordingId = descriptorDecoder.recordingId();
        long startPosition = descriptorDecoder.startPosition();
        int termLength = descriptorDecoder.termBufferLength();
        ArrayList<String> segmentFiles = Catalog.listSegmentFiles(archiveDir, recordingId);
        if (allFiles) {
            for (String fileName : segmentFiles) {
                ArchiveTool.checksumSegmentFile(buffer, out, archiveDir, checksum, recordingId, fileName, startPosition, termLength);
            }
        } else {
            String lastFile = Catalog.findSegmentFileWithHighestPosition(segmentFiles);
            ArchiveTool.checksumSegmentFile(buffer, out, archiveDir, checksum, recordingId, lastFile, startPosition, termLength);
        }
    }

    private static void checksumSegmentFile(ByteBuffer buffer, PrintStream out, File archiveDir, Checksum checksum, long recordingId, String fileName, long startPosition, int termLength) {
        File file = new File(archiveDir, fileName);
        long startTermOffset = startPosition & (long)(termLength - 1);
        long startTermBasePosition = startPosition - startTermOffset;
        long segmentFileBasePosition = Catalog.parseSegmentFilePosition(fileName);
        try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);){
            long fileOffset;
            HeaderFlyweight headerFlyweight = new HeaderFlyweight(buffer);
            long bufferAddress = headerFlyweight.addressOffset();
            long size = channel.size();
            long l = fileOffset = segmentFileBasePosition == startTermBasePosition ? startTermOffset : 0L;
            while (fileOffset < size) {
                buffer.clear().limit(32);
                if (32 != channel.read(buffer, fileOffset)) {
                    out.println("(recordingId=" + recordingId + ", file=" + file + ") ERR: failed to read fragment header");
                    return;
                }
                int frameLength = headerFlyweight.frameLength();
                if (0 == frameLength) {
                    break;
                }
                int alignedLength = BitUtil.align(frameLength, 32);
                if (1 == FrameDescriptor.frameType(headerFlyweight, 0)) {
                    int dataLength = alignedLength - 32;
                    buffer.clear().limit(dataLength);
                    if (dataLength != channel.read(buffer, fileOffset + 32L)) {
                        out.println("(recordingId=" + recordingId + ", file=" + file + ") ERR: failed to read " + dataLength + " byte(s) of data at offset " + (fileOffset + 32L));
                        return;
                    }
                    int checksumResult = checksum.compute(bufferAddress, 0, dataLength);
                    if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                        checksumResult = Integer.reverseBytes(checksumResult);
                    }
                    buffer.clear();
                    buffer.putInt(checksumResult).flip();
                    channel.write(buffer, fileOffset + 12L);
                }
                fileOffset += (long)alignedLength;
            }
        }
        catch (Exception ex) {
            out.println("(recordingId=" + recordingId + ", file=" + file + ") ERR: failed to checksum");
            ex.printStackTrace(out);
        }
    }

    static void checksum(PrintStream out, File archiveDir, boolean allFiles, Checksum checksum, EpochClock epochClock) {
        try (Catalog catalog = ArchiveTool.openCatalogReadWrite(archiveDir, epochClock, 32L, checksum, null);){
            ByteBuffer buffer = ByteBuffer.allocateDirect(BitUtil.align(65504, 64));
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            catalog.forEach((recordingDescriptorOffset, headerEncoder, headerDecoder, descriptorEncoder, descriptorDecoder) -> {
                try {
                    catalog.updateChecksum(recordingDescriptorOffset);
                    ArchiveTool.checksum(buffer, out, archiveDir, allFiles, checksum, descriptorDecoder);
                }
                catch (Exception ex) {
                    out.println("(recordingId=" + descriptorDecoder.recordingId() + ") ERR: failed to compute checksums");
                    out.println(ex);
                }
            });
        }
    }

    private static void deleteOrphanedSegmentFiles(PrintStream out, File archiveDir, RecordingDescriptorDecoder descriptorDecoder, ArrayList<String> segmentFiles) {
        long minBaseOffset = AeronArchive.segmentFileBasePosition(descriptorDecoder.startPosition(), descriptorDecoder.startPosition(), descriptorDecoder.termBufferLength(), descriptorDecoder.segmentFileLength());
        long maxBaseOffset = -1L == descriptorDecoder.stopPosition() ? -1L : AeronArchive.segmentFileBasePosition(descriptorDecoder.startPosition(), descriptorDecoder.stopPosition(), descriptorDecoder.termBufferLength(), descriptorDecoder.segmentFileLength());
        for (String segmentFile : segmentFiles) {
            boolean delete;
            try {
                long offset = Catalog.parseSegmentFilePosition(segmentFile);
                delete = offset < minBaseOffset || -1L != maxBaseOffset && offset > maxBaseOffset;
            }
            catch (RuntimeException ex) {
                delete = true;
            }
            if (!delete) continue;
            try {
                Files.deleteIfExists(archiveDir.toPath().resolve(segmentFile));
            }
            catch (IOException ex) {
                ex.printStackTrace(out);
            }
        }
    }

    private static void printHelp() {
        System.out.format("Usage: <archive-dir> <command> (items in square brackets are optional)%n%n  capacity [capacity in bytes]: gets or increases catalog capacity.%n%n  checksum className [recordingId] [-a]: computes and persists checksums.%n     checksums are computed using the specified Checksum implementation%n     (e.g. io.aeron.archive.checksum.Crc32).%n     Only the last segment file of each recording is processed by default,%n     unless flag '-a' is specified in which case all of the segment files are processed.%n%n  compact: compacts Catalog file by removing entries in state `INVALID` and deleting the%n     corresponding segment files.%n%n  count-entries: queries the number of `VALID` recording entries in the catalog.%n%n  delete-orphaned-segments: deletes orphaned recording segments that have been detached,%n     i.e. outside the start and stop recording range, but are not deleted.%n%n  describe [recordingId]: prints out descriptor(s) in the catalog.%n%n  dump [data fragment limit per recording]: prints descriptor(s)%n     in the catalog and associated recorded data.%n%n  errors: prints errors for the archive and media driver.%n%n  max-entries [number of entries]: *** DEPRECATED: use `capacity` instead. ***%n%n  migrate: migrates archive MarkFile, Catalog, and recordings to the latest version.%n%n  pid: prints just PID of archive.%n%n  verify [recordingId] [-a] [-checksum className]: verifies descriptor(s) in the catalog%n     checking recording files availability and contents. Only the last segment file is%n     verified unless flag '-a' is specified, i.e. meaning verify all segment files.%n     To perform checksum for each data frame specify the '-checksum' flag together with%n     the Checksum implementation class name (e.g. io.aeron.archive.checksum.Crc32).%n     Faulty entries are marked as `INVALID`.%n%n", new Object[0]);
        System.out.flush();
    }

    public static enum VerifyOption {
        VERIFY_ALL_SEGMENT_FILES("-a"),
        APPLY_CHECKSUM("-checksum");

        private final String flag;
        private static final Map<String, VerifyOption> BY_FLAG;

        private VerifyOption(String flag) {
            this.flag = flag;
        }

        public static VerifyOption byFlag(String flag) {
            return BY_FLAG.get(flag);
        }

        static {
            BY_FLAG = Stream.of(VerifyOption.values()).collect(Collectors.toMap(opt -> opt.flag, opt -> opt));
        }
    }

    @FunctionalInterface
    public static interface ActionConfirmation<T> {
        public boolean confirm(T var1);
    }
}

