/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.ExecuteUnderlyingTrade;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.QuoteRequestDecoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class QuoteRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 6;
    public static final int TEMPLATE_ID = 401;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final QuoteRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final NoSidesEncoder noSides = new NoSidesEncoder(this);

    @Override
    public int sbeBlockLength() {
        return 6;
    }

    @Override
    public int sbeTemplateId() {
        return 401;
    }

    @Override
    public int sbeSchemaId() {
        return 1;
    }

    @Override
    public int sbeSchemaVersion() {
        return 0;
    }

    @Override
    public String sbeSemanticType() {
        return "";
    }

    @Override
    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public QuoteRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 6);
        return this;
    }

    public QuoteRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(6).templateId(401).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    @Override
    public int encodedLength() {
        return this.limit - this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void limit(int limit) {
        this.limit = limit;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 0;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public QuoteRequestEncoder enteringTrader(int index, byte value) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 0 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public QuoteRequestEncoder putEnteringTrader(byte[] src, int srcOffset) {
        int length = 5;
        if (srcOffset < 0 || srcOffset > src.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 0, src, srcOffset, 5);
        return this;
    }

    public QuoteRequestEncoder enteringTrader(String src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 0, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 0 + start, (byte)0);
        }
        return this;
    }

    public QuoteRequestEncoder enteringTrader(CharSequence src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 0, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 0 + start, (byte)0);
        }
        return this;
    }

    public static int executeUnderlyingTradeId() {
        return 35004;
    }

    public static int executeUnderlyingTradeSinceVersion() {
        return 0;
    }

    public static int executeUnderlyingTradeEncodingOffset() {
        return 5;
    }

    public static int executeUnderlyingTradeEncodingLength() {
        return 1;
    }

    public static String executeUnderlyingTradeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public QuoteRequestEncoder executeUnderlyingTrade(ExecuteUnderlyingTrade value) {
        this.buffer.putByte(this.offset + 5, value.value());
        return this;
    }

    public static long noSidesId() {
        return 17L;
    }

    public NoSidesEncoder noSidesCount(int count) {
        this.noSides.wrap(this.buffer, count);
        return this.noSides;
    }

    public static int deskIDId() {
        return 35510;
    }

    public static String deskIDCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String deskIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int deskIDHeaderLength() {
        return 1;
    }

    public QuoteRequestEncoder putDeskID(DirectBuffer src, int srcOffset, int length) {
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public QuoteRequestEncoder putDeskID(byte[] src, int srcOffset, int length) {
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public QuoteRequestEncoder deskID(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public QuoteRequestEncoder deskID(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public static int memoId() {
        return 5149;
    }

    public static String memoCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String memoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memoHeaderLength() {
        return 1;
    }

    public QuoteRequestEncoder putMemo(DirectBuffer src, int srcOffset, int length) {
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public QuoteRequestEncoder putMemo(byte[] src, int srcOffset, int length) {
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public QuoteRequestEncoder memo(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        QuoteRequestDecoder decoder = new QuoteRequestDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 6, 0);
        return decoder.appendTo(builder);
    }

    public static final class NoSidesEncoder {
        public static final int HEADER_SIZE = 3;
        private final QuoteRequestEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NoSidesEncoder(QuoteRequestEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)0, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NoSidesEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NoSidesEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 0;
        }
    }
}

