/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class PositionMaintenanceRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 502;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final PositionMaintenanceRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final NoPositionsDecoder noPositions = new NoPositionsDecoder(this);

    @Override
    public int sbeBlockLength() {
        return 0;
    }

    @Override
    public int sbeTemplateId() {
        return 502;
    }

    @Override
    public int sbeSchemaId() {
        return 1;
    }

    @Override
    public int sbeSchemaVersion() {
        return 0;
    }

    @Override
    public String sbeSemanticType() {
        return "";
    }

    @Override
    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public PositionMaintenanceRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public PositionMaintenanceRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (502 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public PositionMaintenanceRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    @Override
    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    @Override
    public int encodedLength() {
        return this.limit - this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void limit(int limit) {
        this.limit = limit;
    }

    public static long noPositionsDecoderId() {
        return 15L;
    }

    public static int noPositionsDecoderSinceVersion() {
        return 0;
    }

    public NoPositionsDecoder noPositions() {
        this.noPositions.wrap(this.buffer);
        return this.noPositions;
    }

    public static int deskIDId() {
        return 35510;
    }

    public static int deskIDSinceVersion() {
        return 0;
    }

    public static String deskIDCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String deskIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int deskIDHeaderLength() {
        return 1;
    }

    public int deskIDLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipDeskID() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getDeskID(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getDeskID(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapDeskID(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String deskID() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getDeskID(Appendable appendable) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int memoId() {
        return 5149;
    }

    public static int memoSinceVersion() {
        return 0;
    }

    public static String memoCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String memoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memoHeaderLength() {
        return 1;
    }

    public int memoLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipMemo() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getMemo(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMemo(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMemo(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String memo() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        PositionMaintenanceRequestDecoder decoder = new PositionMaintenanceRequestDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[PositionMaintenanceRequest](sbeTemplateId=");
        builder.append(502);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 0) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(0);
        builder.append("):");
        builder.append("noPositions=[");
        int noPositionsOriginalOffset = this.noPositions.offset;
        int noPositionsOriginalIndex = this.noPositions.index;
        NoPositionsDecoder noPositions = this.noPositions();
        if (noPositions.count() > 0) {
            while (noPositions.hasNext()) {
                noPositions.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        noPositions.offset = noPositionsOriginalOffset;
        noPositions.index = noPositionsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("deskID=");
        builder.append('\'');
        this.getDeskID(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("memo=");
        builder.append('\'').append(this.memo()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public PositionMaintenanceRequestDecoder sbeSkip() {
        this.sbeRewind();
        NoPositionsDecoder noPositions = this.noPositions();
        if (noPositions.count() > 0) {
            while (noPositions.hasNext()) {
                noPositions.next();
                noPositions.sbeSkip();
            }
        }
        this.skipDeskID();
        this.skipMemo();
        return this;
    }

    public static final class NoPositionsDecoder
    implements Iterable<NoPositionsDecoder>,
    Iterator<NoPositionsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final PositionMaintenanceRequestDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        NoPositionsDecoder(PositionMaintenanceRequestDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public NoPositionsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<NoPositionsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append(')');
            return builder;
        }

        public NoPositionsDecoder sbeSkip() {
            return this;
        }
    }
}

