/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.CompositeDecoderFlyweight;

public final class DeltaInNanosDecoder
implements CompositeDecoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final int ENCODED_LENGTH = 4;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    @Override
    public DeltaInNanosDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    @Override
    public DirectBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int encodedLength() {
        return 4;
    }

    @Override
    public int sbeSchemaId() {
        return 1;
    }

    @Override
    public int sbeSchemaVersion() {
        return 0;
    }

    public static int timeEncodingOffset() {
        return 0;
    }

    public static int timeEncodingLength() {
        return 4;
    }

    public static int timeSinceVersion() {
        return 0;
    }

    public static long timeNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long timeMinValue() {
        return 0L;
    }

    public static long timeMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long time() {
        return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int unitEncodingOffset() {
        return 4;
    }

    public static int unitEncodingLength() {
        return 0;
    }

    public static int unitSinceVersion() {
        return 0;
    }

    public static short unitNullValue() {
        return 255;
    }

    public static short unitMinValue() {
        return 0;
    }

    public static short unitMaxValue() {
        return 254;
    }

    public short unit() {
        return 9;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("time=");
        builder.append(this.time());
        builder.append('|');
        builder.append(')');
        return builder;
    }
}

