/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.CustodianInfoDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class CustodianInfoEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final int ENCODED_LENGTH = 12;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    @Override
    public CustodianInfoEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    @Override
    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public int sbeSchemaId() {
        return 1;
    }

    @Override
    public int sbeSchemaVersion() {
        return 0;
    }

    public static int custodianEncodingOffset() {
        return 0;
    }

    public static int custodianEncodingLength() {
        return 4;
    }

    public static long custodianNullValue() {
        return 0L;
    }

    public static long custodianMinValue() {
        return 0L;
    }

    public static long custodianMaxValue() {
        return 0xFFFFFFFEL;
    }

    public CustodianInfoEncoder custodian(long value) {
        this.buffer.putInt(this.offset + 0, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int custodyAccountEncodingOffset() {
        return 4;
    }

    public static int custodyAccountEncodingLength() {
        return 4;
    }

    public static long custodyAccountNullValue() {
        return 0L;
    }

    public static long custodyAccountMinValue() {
        return 0L;
    }

    public static long custodyAccountMaxValue() {
        return 0xFFFFFFFEL;
    }

    public CustodianInfoEncoder custodyAccount(long value) {
        this.buffer.putInt(this.offset + 4, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int custodyAllocationTypeEncodingOffset() {
        return 8;
    }

    public static int custodyAllocationTypeEncodingLength() {
        return 4;
    }

    public static long custodyAllocationTypeNullValue() {
        return 0L;
    }

    public static long custodyAllocationTypeMinValue() {
        return 0L;
    }

    public static long custodyAllocationTypeMaxValue() {
        return 0xFFFFFFFEL;
    }

    public CustodianInfoEncoder custodyAllocationType(long value) {
        this.buffer.putInt(this.offset + 8, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        CustodianInfoDecoder decoder = new CustodianInfoDecoder();
        decoder.wrap(this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

