/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.validation;

import java.util.Collection;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

class SenderCompIdValidationStrategy
implements MessageValidationStrategy {
    private final CharArraySet validSenderIds;

    SenderCompIdValidationStrategy(Collection<String> validSenderIds) {
        this.validSenderIds = new CharArraySet(validSenderIds);
    }

    @Override
    public boolean validate(SessionHeaderDecoder header) {
        char[] senderCompID = header.senderCompID();
        int senderCompIDLength = header.senderCompIDLength();
        return this.validSenderIds.contains(senderCompID, senderCompIDLength);
    }

    @Override
    public int invalidTagId() {
        return 49;
    }

    @Override
    public int rejectReason() {
        return RejectReason.COMPID_PROBLEM.representation();
    }
}

