/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.agrona.AsciiEncoding;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class CharFormatter {
    private static final int DEFAULT_LENGTH = AsciiBuffer.LONGEST_LONG_LENGTH;
    private static final Pattern PATTERN = Pattern.compile("%s");
    private static final Pattern NEWLINE = Pattern.compile("%n");
    private static final char[] MIN_INTEGER_VALUE = String.valueOf(Integer.MIN_VALUE).toCharArray();
    private static final char[] MIN_LONG_VALUE = String.valueOf(Long.MIN_VALUE).toCharArray();
    private final String formatString;
    private final char[][] segments;
    private final char[][] values;
    private final int[] lengths;
    private int encodedSoFar = 0;

    public CharFormatter(String formatString) {
        int i;
        this.formatString = formatString;
        String[] splitFormatString = PATTERN.split(formatString);
        int numberOfSegments = splitFormatString.length;
        int numberOfValues = formatString.endsWith("%s") ? numberOfSegments : numberOfSegments - 1;
        this.segments = new char[numberOfSegments][];
        this.lengths = new int[numberOfValues];
        this.values = new char[numberOfValues][];
        for (i = 0; i < numberOfSegments; ++i) {
            String strSegment = NEWLINE.matcher(splitFormatString[i]).replaceAll(System.lineSeparator());
            char[] segment = strSegment.toCharArray();
            this.segments[i] = segment;
        }
        for (i = 0; i < numberOfValues; ++i) {
            this.values[i] = new char[DEFAULT_LENGTH];
        }
    }

    public CharFormatter with(String string) {
        int length = string.length();
        char[] value = this.ensureLength(length);
        this.lengths[this.encodedSoFar] = length;
        string.getChars(0, length, value, 0);
        ++this.encodedSoFar;
        return this;
    }

    public CharFormatter with(byte[] asciiBytes, int length) {
        char[] value = this.ensureLength(length);
        this.lengths[this.encodedSoFar] = length;
        for (int i = 0; i < length; ++i) {
            value[i] = (char)asciiBytes[i];
        }
        ++this.encodedSoFar;
        return this;
    }

    public CharFormatter with(int number) {
        char[] buffer = this.ensureLength(AsciiBuffer.LONGEST_INT_LENGTH);
        this.lengths[this.encodedSoFar] = this.putIntAscii(buffer, 0, number);
        ++this.encodedSoFar;
        return this;
    }

    public CharFormatter with(boolean value) {
        char[] buffer = this.ensureLength(1);
        buffer[0] = value ? 89 : 78;
        this.lengths[this.encodedSoFar] = 1;
        ++this.encodedSoFar;
        return this;
    }

    public CharFormatter with(long number) {
        char[] buffer = this.ensureLength(AsciiBuffer.LONGEST_LONG_LENGTH);
        this.lengths[this.encodedSoFar] = this.putLongAscii(buffer, 0, number);
        ++this.encodedSoFar;
        return this;
    }

    public CharFormatter clear() {
        this.encodedSoFar = 0;
        Arrays.fill(this.lengths, 0);
        return this;
    }

    public void appendTo(StringBuilder builder) {
        char[][] values = this.values;
        int length = values.length;
        if (length != this.encodedSoFar) {
            throw new IllegalStateException("Unable to append formatter hasn't been completely initialized");
        }
        char[][] segments = this.segments;
        int[] lengths = this.lengths;
        for (int i = 0; i < length; ++i) {
            builder.append(segments[i]);
            builder.append(values[i], 0, lengths[i]);
        }
        if (segments.length > length) {
            builder.append(segments[length]);
        }
    }

    public int putIntAscii(char[] buffer, int index, int value) {
        int i;
        if (value == 0) {
            buffer[index] = 48;
            return 1;
        }
        if (value == Integer.MIN_VALUE) {
            int length = MIN_INTEGER_VALUE.length;
            System.arraycopy(MIN_INTEGER_VALUE, 0, buffer, index, length);
            return length;
        }
        int start = index;
        int quotient = value;
        int length = 1;
        if (value < 0) {
            buffer[index] = 45;
            ++start;
            ++length;
            quotient = -quotient;
        }
        length += i;
        for (i = AsciiEncoding.digitCount(quotient) - 1; i >= 0; --i) {
            int remainder = quotient % 10;
            quotient /= 10;
            buffer[i + start] = (char)(48 + remainder);
        }
        return length;
    }

    public int putLongAscii(char[] buffer, int index, long value) {
        int i;
        if (value == 0L) {
            buffer[index] = 48;
            return 1;
        }
        if (value == Long.MIN_VALUE) {
            int length = MIN_LONG_VALUE.length;
            System.arraycopy(MIN_LONG_VALUE, 0, buffer, index, length);
            return length;
        }
        int start = index;
        long quotient = value;
        int length = 1;
        if (value < 0L) {
            buffer[index] = 45;
            ++start;
            ++length;
            quotient = -quotient;
        }
        length += i;
        for (i = AsciiEncoding.digitCount(quotient) - 1; i >= 0; --i) {
            long remainder = quotient % 10L;
            quotient /= 10L;
            buffer[i + start] = (char)(48L + remainder);
        }
        return length;
    }

    private char[] ensureLength(int length) {
        int encodedSoFar = this.encodedSoFar;
        char[][] values = this.values;
        if (encodedSoFar >= values.length) {
            throw new IllegalStateException("Attempting to add argument number " + (encodedSoFar + 1) + " to a " + values.length + " argument CharFormatter: " + this.formatString);
        }
        char[] value = values[encodedSoFar];
        if (value.length < length) {
            value = new char[length];
            values[encodedSoFar] = value;
        }
        return value;
    }
}

