/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.AsciiNumberFormatException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.AbstractHeartbeatDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogoutDecoder;
import uk.co.real_logic.artio.decoder.AbstractRejectDecoder;
import uk.co.real_logic.artio.decoder.AbstractResendRequestDecoder;
import uk.co.real_logic.artio.decoder.AbstractSequenceResetDecoder;
import uk.co.real_logic.artio.decoder.AbstractTestRequestDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.fields.UtcTimestampDecoder;
import uk.co.real_logic.artio.library.OnMessageInfo;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.MalformedTagFormatException;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

public class SessionParser {
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final UtcTimestampDecoder timestampDecoder;
    private AbstractLogonDecoder logon;
    private AbstractLogoutDecoder logout;
    private AbstractRejectDecoder reject;
    private AbstractTestRequestDecoder testRequest;
    private SessionHeaderDecoder header;
    private AbstractSequenceResetDecoder sequenceReset;
    private AbstractResendRequestDecoder resendRequest;
    private AbstractHeartbeatDecoder heartbeat;
    private final boolean validateCompIdsOnEveryMessage;
    private final OnMessageInfo messageInfo;
    private final SessionIdStrategy sessionIdStrategy;
    private final Session session;
    private final MessageValidationStrategy validationStrategy;
    private final ErrorHandler errorHandler;
    private CompositeKey compositeKey;

    public SessionParser(Session session, MessageValidationStrategy validationStrategy, ErrorHandler errorHandler, boolean validateCompIdsOnEveryMessage, boolean validateTimeStrictly, OnMessageInfo messageInfo, SessionIdStrategy sessionIdStrategy) {
        this.session = session;
        this.validationStrategy = validationStrategy;
        this.errorHandler = errorHandler;
        this.validateCompIdsOnEveryMessage = validateCompIdsOnEveryMessage;
        this.messageInfo = messageInfo;
        this.sessionIdStrategy = sessionIdStrategy;
        this.timestampDecoder = new UtcTimestampDecoder(validateTimeStrictly);
    }

    public void fixDictionary(FixDictionary fixDictionary) {
        this.logon = fixDictionary.makeLogonDecoder();
        this.logout = fixDictionary.makeLogoutDecoder();
        this.reject = fixDictionary.makeRejectDecoder();
        this.testRequest = fixDictionary.makeTestRequestDecoder();
        this.header = fixDictionary.makeHeaderDecoder();
        this.sequenceReset = fixDictionary.makeSequenceResetDecoder();
        this.heartbeat = fixDictionary.makeHeartbeatDecoder();
        this.resendRequest = fixDictionary.makeResendRequestDecoder();
    }

    public static String username(AbstractLogonDecoder logon) {
        return logon.supportsUsername() ? logon.usernameAsString() : null;
    }

    public static String password(AbstractLogonDecoder logon) {
        return logon.supportsPassword() ? logon.passwordAsString() : null;
    }

    public static CancelOnDisconnectOption cancelOnDisconnectType(AbstractLogonDecoder logon) {
        return logon.supportsCancelOnDisconnectType() && logon.hasCancelOnDisconnectType() ? CancelOnDisconnectOption.get(logon.cancelOnDisconnectType()) : CancelOnDisconnectOption.DO_NOT_CANCEL_ON_DISCONNECT_OR_LOGOUT;
    }

    public static int cancelOnDisconnectTimeoutWindow(AbstractLogonDecoder logon) {
        return logon.supportsCODTimeoutWindow() && logon.hasCODTimeoutWindow() ? logon.cODTimeoutWindow() : 0;
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, long messageType, long position) {
        this.asciiBuffer.wrap(buffer);
        try {
            ControlledFragmentHandler.Action action = messageType == 65L ? this.onLogon(offset, length, position) : (messageType == 53L ? this.onLogout(offset, length, position) : (messageType == 48L ? this.onHeartbeat(offset, length, position) : (messageType == 51L ? this.onReject(offset, length, position) : (messageType == 49L ? this.onTestRequest(offset, length, position) : (messageType == 52L ? this.onSequenceReset(offset, length, position) : (messageType == 50L ? this.onResendRequest(offset, length, position) : this.onAnyOtherMessage(offset, length, position)))))));
            this.session.updateLastMessageProcessed();
            return action;
        }
        catch (MalformedTagFormatException e) {
            return this.rejectAndHandleExceptionalMessage(e, messageType, e.refTagId(), position);
        }
        catch (AsciiNumberFormatException e) {
            if (e.getMessage().contains("'^' is not a valid digit")) {
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            return this.rejectAndHandleExceptionalMessage(e, messageType, Integer.MIN_VALUE, position);
        }
        catch (Exception e) {
            return this.rejectAndHandleExceptionalMessage(e, messageType, Integer.MIN_VALUE, position);
        }
    }

    private ControlledFragmentHandler.Action rejectAndHandleExceptionalMessage(Exception e, long messageType, int refTagId, long position) {
        ControlledFragmentHandler.Action action = this.rejectExceptionalMessage(messageType, refTagId, position);
        if (action == ControlledFragmentHandler.Action.CONTINUE) {
            this.onError(e);
        }
        return action;
    }

    private ControlledFragmentHandler.Action rejectExceptionalMessage(long messageType, int refTagId, long position) {
        if (messageType == 65L) {
            ControlledFragmentHandler.Action action = this.onExceptionalMessage(this.logon.header(), refTagId, position);
            if (action != ControlledFragmentHandler.Action.ABORT) {
                this.session.logoutAndDisconnect();
            }
            return action;
        }
        if (messageType == 53L) {
            return this.onExceptionalMessage(this.logout.header(), refTagId, position);
        }
        if (messageType == 48L) {
            return this.onExceptionalMessage(this.heartbeat.header(), refTagId, position);
        }
        if (messageType == 51L) {
            return this.onExceptionalMessage(this.reject.header(), refTagId, position);
        }
        if (messageType == 49L) {
            return this.onExceptionalMessage(this.testRequest.header(), refTagId, position);
        }
        if (messageType == 52L) {
            return this.onExceptionalMessage(this.sequenceReset.header(), refTagId, position);
        }
        return this.onExceptionalMessage(this.header, refTagId, position);
    }

    private ControlledFragmentHandler.Action onExceptionalMessage(SessionHeaderDecoder header, int regTagId, long position) {
        int msgSeqNum = header.msgSeqNum();
        return this.session.onInvalidMessage(msgSeqNum, regTagId, header.msgType(), header.msgTypeLength(), 6, position);
    }

    private ControlledFragmentHandler.Action onHeartbeat(int offset, int length, long position) {
        AbstractHeartbeatDecoder heartbeat = this.heartbeat;
        heartbeat.reset();
        heartbeat.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = heartbeat.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || heartbeat.validate() && this.validateHeader(header, position))) {
            return this.onCodecInvalidMessage(heartbeat, header, false, position);
        }
        if (heartbeat.hasTestReqID()) {
            long origSendingTime = this.origSendingTimeInMs(header);
            long sendingTime = this.sendingTimeInMs(header);
            int testReqIDLength = heartbeat.testReqIDLength();
            char[] testReqID = heartbeat.testReqID();
            int msgSeqNum = header.msgSeqNum();
            boolean possDup = this.isPossDup(header);
            return this.session.onHeartbeat(msgSeqNum, testReqID, testReqIDLength, sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup, position);
        }
        return this.onMessage(header, position);
    }

    private long sendingTimeInMs(SessionHeaderDecoder header) {
        byte[] sendingTime = header.sendingTime();
        return this.decodeTimestampInMs(sendingTime, header.sendingTimeLength(), 52);
    }

    private long decodeTimestampInMs(byte[] sendingTime, int length, int refTagId) {
        try {
            return Validation.CODEC_VALIDATION_ENABLED ? this.timestampDecoder.decode(sendingTime, length) : Long.MIN_VALUE;
        }
        catch (Exception e) {
            throw new MalformedTagFormatException(refTagId, (Throwable)e);
        }
    }

    private ControlledFragmentHandler.Action onAnyOtherMessage(int offset, int length, long position) {
        SessionHeaderDecoder header = this.header;
        header.reset();
        header.decode(this.asciiBuffer, offset, length);
        char[] msgType = header.msgType();
        int msgTypeLength = header.msgTypeLength();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || Validation.isValidMsgType(msgType, msgTypeLength) && this.validateHeader(header, position))) {
            int msgSeqNum = header.msgSeqNum();
            if (!this.isDisconnectedOrAwaitingLogout()) {
                return this.session.onInvalidMessageType(msgSeqNum, msgType, msgTypeLength, position);
            }
        } else {
            return this.onMessage(header, position);
        }
        this.messageInfo.isValid(false);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onMessage(SessionHeaderDecoder header, long position) {
        long origSendingTime = this.origSendingTimeInMs(header);
        long sendingTime = this.sendingTimeInMs(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onMessage(header.msgSeqNum(), header.msgType(), header.msgTypeLength(), sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup, position);
    }

    private long origSendingTimeInMs(SessionHeaderDecoder header) {
        if (header.hasOrigSendingTime()) {
            return this.decodeTimestampInMs(header.origSendingTime(), header.origSendingTimeLength(), 122);
        }
        return -1L;
    }

    private ControlledFragmentHandler.Action onResendRequest(int offset, int length, long position) {
        AbstractResendRequestDecoder resendRequest = this.resendRequest;
        resendRequest.reset();
        resendRequest.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = resendRequest.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || resendRequest.validate() && this.validateHeader(header, position))) {
            return this.onCodecInvalidMessage(resendRequest, header, false, position);
        }
        long origSendingTime = this.origSendingTimeInMs(header);
        long sendingTime = this.sendingTimeInMs(header);
        int beginSeqNo = resendRequest.beginSeqNo();
        int endSeqNo = resendRequest.endSeqNo();
        boolean possDup = this.isPossDup(header);
        return this.session.onResendRequest(header.msgSeqNum(), beginSeqNo, endSeqNo, this.isPossDupOrResend(possDup, header), possDup, sendingTime, origSendingTime, position, this.asciiBuffer, offset, length);
    }

    private ControlledFragmentHandler.Action onSequenceReset(int offset, int length, long position) {
        AbstractSequenceResetDecoder sequenceReset = this.sequenceReset;
        sequenceReset.reset();
        sequenceReset.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = sequenceReset.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || sequenceReset.validate() && this.validateHeader(header, position))) {
            return this.onCodecInvalidMessage(sequenceReset, header, false, position);
        }
        boolean gapFillFlag = sequenceReset.hasGapFillFlag() && sequenceReset.gapFillFlag();
        boolean possDup = this.isPossDup(header);
        return this.session.onSequenceReset(header.msgSeqNum(), sequenceReset.newSeqNo(), gapFillFlag, this.isPossDupOrResend(possDup, header), position);
    }

    private ControlledFragmentHandler.Action onTestRequest(int offset, int length, long position) {
        AbstractTestRequestDecoder testRequest = this.testRequest;
        testRequest.reset();
        testRequest.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = testRequest.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || testRequest.validate() && this.validateHeader(header, position))) {
            return this.onCodecInvalidMessage(testRequest, header, false, position);
        }
        int msgSeqNo = header.msgSeqNum();
        long origSendingTime = this.origSendingTimeInMs(header);
        long sendingTimeInMs = this.sendingTimeInMs(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onTestRequest(msgSeqNo, testRequest.testReqID(), testRequest.testReqIDLength(), sendingTimeInMs, origSendingTime, this.isPossDupOrResend(possDup, header), possDup, position);
    }

    private ControlledFragmentHandler.Action onReject(int offset, int length, long position) {
        AbstractRejectDecoder reject = this.reject;
        reject.reset();
        reject.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = reject.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || reject.validate() && this.validateHeader(header, position))) {
            return this.onCodecInvalidMessage(reject, header, false, position);
        }
        long origSendingTime = this.origSendingTimeInMs(header);
        long sendingTime = this.sendingTimeInMs(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onReject(header.msgSeqNum(), sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup, position);
    }

    private ControlledFragmentHandler.Action onLogout(int offset, int length, long position) {
        AbstractLogoutDecoder logout = this.logout;
        logout.reset();
        logout.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = logout.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || logout.validate() && this.validateHeader(header, position))) {
            return this.onCodecInvalidMessage(logout, header, false, position);
        }
        long origSendingTimeInMs = this.origSendingTimeInMs(header);
        long sendingTimeInMs = this.sendingTimeInMs(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onLogout(header.msgSeqNum(), sendingTimeInMs, origSendingTimeInMs, possDup, position);
    }

    private ControlledFragmentHandler.Action onLogon(int offset, int length, long position) {
        AbstractLogonDecoder logon = this.logon;
        Session session = this.session;
        logon.reset();
        logon.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = logon.header();
        char[] beginString = header.beginString();
        int beginStringLength = header.beginStringLength();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || logon.validate() && session.onBeginString(beginString, beginStringLength, true))) {
            return this.onCodecInvalidMessage(logon, header, true, position);
        }
        long origSendingTime = this.origSendingTimeInMs(header);
        String username = SessionParser.username(logon);
        String password = SessionParser.password(logon);
        CancelOnDisconnectOption cancelOnDisconnectOption = SessionParser.cancelOnDisconnectType(logon);
        int cancelOnDisconnectTimeoutWindow = SessionParser.cancelOnDisconnectTimeoutWindow(logon);
        boolean possDup = this.isPossDup(header);
        return session.onLogon(logon.heartBtInt(), header.msgSeqNum(), this.sendingTimeInMs(header), origSendingTime, username, password, this.isPossDupOrResend(possDup, header), this.resetSeqNumFlag(logon), possDup, position, cancelOnDisconnectOption, cancelOnDisconnectTimeoutWindow);
    }

    private void onStrategyError(String strategyName, Throwable throwable, String fixMessage) {
        String message = String.format("Exception thrown by %s strategy for connectionId=%d, [%s], defaulted to false", strategyName, this.session.connectionId(), fixMessage);
        this.onError(new FixGatewayException(message, throwable));
    }

    private void onError(Throwable throwable) {
        this.errorHandler.onError(throwable);
    }

    private boolean resetSeqNumFlag(AbstractLogonDecoder logon) {
        return logon.hasResetSeqNumFlag() && logon.resetSeqNumFlag();
    }

    private boolean validateHeader(SessionHeaderDecoder header, long position) {
        if (!this.session.onBeginString(header.beginString(), header.beginStringLength(), false)) {
            return false;
        }
        boolean validated = true;
        int rejectReason = RejectReason.OTHER.representation();
        int invalidTagId = this.validateCompIds(header);
        if (invalidTagId != 0) {
            validated = false;
            rejectReason = RejectReason.COMPID_PROBLEM.representation();
        }
        if (validated) {
            try {
                validated = this.validationStrategy.validate(header);
                if (!validated) {
                    rejectReason = this.validationStrategy.rejectReason();
                    invalidTagId = this.validationStrategy.invalidTagId();
                }
            }
            catch (Throwable throwable) {
                this.onStrategyError("validation", throwable, header.toString());
                validated = false;
            }
        }
        if (!validated) {
            this.session.onInvalidMessage(header.msgSeqNum(), invalidTagId, header.msgType(), header.msgTypeLength(), rejectReason, position);
            this.session.logoutRejectReason(rejectReason);
            this.session.startLogout();
            return false;
        }
        return true;
    }

    private int validateCompIds(SessionHeaderDecoder header) {
        if (!this.validateCompIdsOnEveryMessage) {
            return 0;
        }
        return this.sessionIdStrategy.validateCompIds(this.compositeKey, header);
    }

    private ControlledFragmentHandler.Action onCodecInvalidMessage(Decoder decoder, SessionHeaderDecoder header, boolean requestDisconnect, long position) {
        if (!this.isDisconnectedOrAwaitingLogout()) {
            int msgTypeLength = header.msgTypeLength();
            if (header.msgSeqNum() == Integer.MIN_VALUE) {
                long origSendingTime = this.origSendingTimeInMs(header);
                long sendingTime = this.sendingTimeInMs(header);
                char[] msgType = header.msgType();
                return this.session.onMessage(Integer.MIN_VALUE, msgType, msgTypeLength, sendingTime, origSendingTime, false, false, position);
            }
            ControlledFragmentHandler.Action action = this.session.onInvalidMessage(header.msgSeqNum(), decoder.invalidTagId(), header.msgType(), msgTypeLength, decoder.rejectReason(), position);
            if (action == ControlledFragmentHandler.Action.CONTINUE && requestDisconnect) {
                return this.session.onInvalidFixDisconnect();
            }
            return action;
        }
        this.messageInfo.isValid(false);
        if (requestDisconnect) {
            return this.session.onInvalidFixDisconnect();
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private boolean isDisconnectedOrAwaitingLogout() {
        SessionState state = this.session.state();
        return state == SessionState.DISCONNECTED || state == SessionState.AWAITING_LOGOUT;
    }

    private boolean isPossDupOrResend(boolean possDup, SessionHeaderDecoder header) {
        return possDup || header.hasPossResend() && header.possResend();
    }

    private boolean isPossDup(SessionHeaderDecoder header) {
        return header.hasPossDupFlag() && header.possDupFlag();
    }

    public Session session() {
        return this.session;
    }

    public void sequenceIndex(int sequenceIndex) {
        this.session.sequenceIndex(sequenceIndex);
    }

    public void sessionKey(CompositeKey sessionKey) {
        this.compositeKey = sessionKey;
    }
}

