/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import java.util.Arrays;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.storage.messages.SenderAndTargetCompositeKeyDecoder;
import uk.co.real_logic.artio.storage.messages.SenderAndTargetCompositeKeyEncoder;

class SenderAndTargetSessionIdStrategy
implements SessionIdStrategy {
    private static final int BLOCK_AND_LENGTH_FIELDS_LENGTH = 4;
    private final SenderAndTargetCompositeKeyEncoder keyEncoder = new SenderAndTargetCompositeKeyEncoder();
    private final SenderAndTargetCompositeKeyDecoder keyDecoder = new SenderAndTargetCompositeKeyDecoder();
    private final int actingBlockLength = this.keyDecoder.sbeBlockLength();
    private final int actingVersion = this.keyDecoder.sbeSchemaVersion();

    SenderAndTargetSessionIdStrategy() {
    }

    @Override
    public CompositeKey onAcceptLogon(SessionHeaderDecoder header) throws IllegalArgumentException {
        Objects.requireNonNull(header, "header");
        int localCompIDLength = header.targetCompIDLength();
        int remoteCompIDLength = header.senderCompIDLength();
        if (localCompIDLength == 0 || remoteCompIDLength == 0) {
            throw new IllegalArgumentException("Missing comp id");
        }
        return new CompositeKeyImpl(header.targetCompID(), localCompIDLength, header.senderCompID(), remoteCompIDLength);
    }

    @Override
    public CompositeKey onInitiateLogon(String localCompId, String localSubId, String localLocationId, String remoteCompId, String remoteSubId, String remoteLocationId) {
        Objects.requireNonNull(localCompId, "senderCompId");
        Objects.requireNonNull(remoteCompId, "targetCompId");
        char[] senderCompID = localCompId.toCharArray();
        char[] targetCompID = remoteCompId.toCharArray();
        return new CompositeKeyImpl(senderCompID, senderCompID.length, targetCompID, targetCompID.length);
    }

    @Override
    public void setupSession(CompositeKey compositeKey, SessionHeaderEncoder headerEncoder) {
        Objects.requireNonNull(compositeKey, "compositeKey");
        Objects.requireNonNull(headerEncoder, "headerEncoder");
        CompositeKeyImpl composite = (CompositeKeyImpl)compositeKey;
        headerEncoder.senderCompID(SessionIdStrategy.checkMissing(composite.localCompID));
        headerEncoder.targetCompID(SessionIdStrategy.checkMissing(composite.remoteCompID));
    }

    @Override
    public int save(CompositeKey compositeKey, MutableDirectBuffer buffer, int offset) {
        Objects.requireNonNull(compositeKey, "compositeKey");
        Objects.requireNonNull(buffer, "buffer");
        String localCompId = compositeKey.localCompId();
        String remoteCompId = compositeKey.remoteCompId();
        int length = localCompId.length() + remoteCompId.length() + 4;
        if (buffer.capacity() < offset + length) {
            return -1;
        }
        this.keyEncoder.wrap(buffer, offset);
        this.keyEncoder.localCompId(localCompId);
        this.keyEncoder.remoteCompId(remoteCompId);
        return length;
    }

    @Override
    public CompositeKey load(DirectBuffer buffer, int offset, int length) {
        Objects.requireNonNull(buffer, "buffer");
        this.keyDecoder.wrap(buffer, offset, this.actingBlockLength, this.actingVersion);
        int localCompIdLength = this.keyDecoder.localCompIdLength();
        byte[] localCompId = new byte[localCompIdLength];
        this.keyDecoder.getLocalCompId(localCompId, 0, localCompIdLength);
        int remoteCompIdLength = this.keyDecoder.remoteCompIdLength();
        byte[] remoteCompId = new byte[remoteCompIdLength];
        this.keyDecoder.getRemoteCompId(remoteCompId, 0, remoteCompIdLength);
        return new CompositeKeyImpl(localCompId, remoteCompId);
    }

    @Override
    public int validateCompIds(CompositeKey compositeKey, SessionHeaderDecoder header) {
        CompositeKeyImpl key = (CompositeKeyImpl)compositeKey;
        if (!CodecUtil.equals(key.remoteCompID, header.senderCompID(), header.senderCompIDLength())) {
            return 49;
        }
        if (!CodecUtil.equals(key.localCompID, header.targetCompID(), header.targetCompIDLength())) {
            return 56;
        }
        return 0;
    }

    private static final class CompositeKeyImpl
    implements CompositeKey {
        private final char[] localCompID;
        private final char[] remoteCompID;
        private final int hashCode;

        private CompositeKeyImpl(char[] localCompID, int localCompIDLength, char[] remoteCompID, int remoteCompIDLength) {
            this.localCompID = Arrays.copyOf(localCompID, localCompIDLength);
            this.remoteCompID = Arrays.copyOf(remoteCompID, remoteCompIDLength);
            this.hashCode = this.hash(this.localCompID, this.remoteCompID);
        }

        private CompositeKeyImpl(byte[] localCompID, byte[] remoteCompID) {
            this.localCompID = CodecUtil.fromBytes(localCompID);
            this.remoteCompID = CodecUtil.fromBytes(remoteCompID);
            this.hashCode = this.hash(this.localCompID, this.remoteCompID);
        }

        private int hash(char[] senderCompID, char[] targetCompID) {
            int result = Arrays.hashCode(senderCompID);
            result = 31 * result + Arrays.hashCode(targetCompID);
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompositeKeyImpl) {
                CompositeKeyImpl compositeKey = (CompositeKeyImpl)obj;
                return Arrays.equals(compositeKey.localCompID, this.localCompID) && Arrays.equals(compositeKey.remoteCompID, this.remoteCompID);
            }
            return false;
        }

        public String toString() {
            return "CompositeKey{localCompId=" + this.localCompId() + ", remoteCompId=" + this.remoteCompId() + '}';
        }

        @Override
        public String localCompId() {
            return new String(this.localCompID);
        }

        @Override
        public String localSubId() {
            return "";
        }

        @Override
        public String localLocationId() {
            return "";
        }

        @Override
        public String remoteCompId() {
            return new String(this.remoteCompID);
        }

        @Override
        public String remoteSubId() {
            return "";
        }

        @Override
        public String remoteLocationId() {
            return "";
        }
    }
}

