/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.sbe_util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import uk.co.real_logic.artio.messages.MessageSchemaLocation;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrEncoder;
import uk.co.real_logic.sbe.xml.IrGenerator;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.ParserOptions;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public final class MessageSchemaIr {
    private static final String PATH = "message-schema.xml";
    public static final Ir SCHEMA_IR = MessageSchemaIr.loadIr();
    public static final ByteBuffer SCHEMA_BUFFER = MessageSchemaIr.encodeSchema();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Ir loadIr() {
        try (InputStream in = MessageSchemaLocation.class.getResourceAsStream(PATH);){
            MessageSchema schema = XmlSchemaParser.parse(in, ParserOptions.DEFAULT);
            Ir ir = new IrGenerator().generate(schema);
            return ir;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static ByteBuffer encodeSchema() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        try (IrEncoder irEncoder = new IrEncoder(byteBuffer, SCHEMA_IR);){
            irEncoder.encode();
        }
        byteBuffer.flip();
        return byteBuffer;
    }
}

