/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.logbuffer.Header;

public final class ReservedValue {
    public static final int NO_FILTER = 0;
    private static final int BITS_IN_INT = 32;

    public static long ofClusterStreamId(int clusterStreamId) {
        return (long)clusterStreamId & 0xFFFFFFFFL;
    }

    public static long ofChecksum(int checksum) {
        return (long)checksum << 32;
    }

    public static long of(int clusterStreamId, int checksum) {
        return ReservedValue.ofChecksum(checksum) | ReservedValue.ofClusterStreamId(clusterStreamId);
    }

    public static int clusterStreamId(long reservedValue) {
        return (int)reservedValue;
    }

    public static int clusterStreamId(Header header) {
        long reservedValue = header.reservedValue();
        return ReservedValue.clusterStreamId(reservedValue);
    }

    public static int streamId(Header header) {
        int clusterStreamId = ReservedValue.clusterStreamId(header);
        if (clusterStreamId == 0) {
            return header.streamId();
        }
        return clusterStreamId;
    }

    public static int checksum(long reservedValue) {
        return (int)(reservedValue >> 32);
    }
}

