/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

public enum SessionState {
    CONNECTING(0),
    CONNECTED(1),
    SENT_LOGON(2),
    ACTIVE(3),
    LOGGING_OUT(5),
    LOGGING_OUT_AND_DISCONNECTING(6),
    AWAITING_LOGOUT(7),
    DISCONNECTING(8),
    DISCONNECTED(9),
    DISABLED(10),
    NULL_VAL(255);

    private final short value;

    private SessionState(short value) {
        this.value = value;
    }

    public short value() {
        return this.value;
    }

    public static SessionState get(short value) {
        switch (value) {
            case 0: {
                return CONNECTING;
            }
            case 1: {
                return CONNECTED;
            }
            case 2: {
                return SENT_LOGON;
            }
            case 3: {
                return ACTIVE;
            }
            case 5: {
                return LOGGING_OUT;
            }
            case 6: {
                return LOGGING_OUT_AND_DISCONNECTING;
            }
            case 7: {
                return AWAITING_LOGOUT;
            }
            case 8: {
                return DISCONNECTING;
            }
            case 9: {
                return DISCONNECTED;
            }
            case 10: {
                return DISABLED;
            }
            case 255: {
                return NULL_VAL;
            }
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

