/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.ControlNotificationDecoder;
import uk.co.real_logic.artio.messages.InitialAcceptedSessionOwner;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class ControlNotificationEncoder {
    public static final int BLOCK_LENGTH = 5;
    public static final int TEMPLATE_ID = 39;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 20;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ControlNotificationEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final SessionsEncoder sessions = new SessionsEncoder(this);

    public int sbeBlockLength() {
        return 5;
    }

    public int sbeTemplateId() {
        return 39;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 20;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ControlNotificationEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 5);
        return this;
    }

    public ControlNotificationEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(5).templateId(39).schemaId(666).version(20);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ControlNotificationEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int initialAcceptedSessionOwnerId() {
        return 3;
    }

    public static int initialAcceptedSessionOwnerSinceVersion() {
        return 10;
    }

    public static int initialAcceptedSessionOwnerEncodingOffset() {
        return 4;
    }

    public static int initialAcceptedSessionOwnerEncodingLength() {
        return 1;
    }

    public static String initialAcceptedSessionOwnerMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ControlNotificationEncoder initialAcceptedSessionOwner(InitialAcceptedSessionOwner value) {
        this.buffer.putByte(this.offset + 4, (byte)value.value());
        return this;
    }

    public static long sessionsId() {
        return 2L;
    }

    public SessionsEncoder sessionsCount(int count) {
        this.sessions.wrap(this.buffer, count);
        return this.sessions;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ControlNotificationDecoder decoder = new ControlNotificationDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 5, 20);
        return decoder.appendTo(builder);
    }

    public static final class SessionsEncoder {
        public static final int HEADER_SIZE = 3;
        private final ControlNotificationEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        SessionsEncoder(ControlNotificationEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)8, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public SessionsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + SessionsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public static int sessionIdId() {
            return 10;
        }

        public static int sessionIdSinceVersion() {
            return 0;
        }

        public static int sessionIdEncodingOffset() {
            return 0;
        }

        public static int sessionIdEncodingLength() {
            return 8;
        }

        public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long sessionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long sessionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long sessionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public SessionsEncoder sessionId(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }
    }
}

