/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import uk.co.real_logic.artio.messages.AllFixSessionsReplyDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.SlowStatus;

public final class AllFixSessionsReplyEncoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 63;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 20;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AllFixSessionsReplyEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final SessionsEncoder sessions = new SessionsEncoder(this);

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 63;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 20;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public AllFixSessionsReplyEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 8);
        return this;
    }

    public AllFixSessionsReplyEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(8).templateId(63).schemaId(666).version(20);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int correlationIdId() {
        return 0;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 0;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public AllFixSessionsReplyEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long sessionsId() {
        return 7L;
    }

    public SessionsEncoder sessionsCount(int count) {
        this.sessions.wrap(this.buffer, count);
        return this.sessions;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        AllFixSessionsReplyDecoder decoder = new AllFixSessionsReplyDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 8, 20);
        return decoder.appendTo(builder);
    }

    public static final class SessionsEncoder {
        public static final int HEADER_SIZE = 3;
        private final AllFixSessionsReplyEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        SessionsEncoder(AllFixSessionsReplyEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)37, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public SessionsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + SessionsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 37;
        }

        public static int sessionIdId() {
            return 1;
        }

        public static int sessionIdSinceVersion() {
            return 0;
        }

        public static int sessionIdEncodingOffset() {
            return 0;
        }

        public static int sessionIdEncodingLength() {
            return 8;
        }

        public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long sessionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long sessionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long sessionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public SessionsEncoder sessionId(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int connectionIdId() {
            return 2;
        }

        public static int connectionIdSinceVersion() {
            return 0;
        }

        public static int connectionIdEncodingOffset() {
            return 8;
        }

        public static int connectionIdEncodingLength() {
            return 8;
        }

        public static String connectionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long connectionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long connectionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long connectionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public SessionsEncoder connectionId(long value) {
            this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int lastReceivedSequenceNumberId() {
            return 3;
        }

        public static int lastReceivedSequenceNumberSinceVersion() {
            return 0;
        }

        public static int lastReceivedSequenceNumberEncodingOffset() {
            return 16;
        }

        public static int lastReceivedSequenceNumberEncodingLength() {
            return 4;
        }

        public static String lastReceivedSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int lastReceivedSequenceNumberNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int lastReceivedSequenceNumberMinValue() {
            return -2147483647;
        }

        public static int lastReceivedSequenceNumberMaxValue() {
            return Integer.MAX_VALUE;
        }

        public SessionsEncoder lastReceivedSequenceNumber(int value) {
            this.buffer.putInt(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int lastSentSequenceNumberId() {
            return 4;
        }

        public static int lastSentSequenceNumberSinceVersion() {
            return 0;
        }

        public static int lastSentSequenceNumberEncodingOffset() {
            return 20;
        }

        public static int lastSentSequenceNumberEncodingLength() {
            return 4;
        }

        public static String lastSentSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int lastSentSequenceNumberNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int lastSentSequenceNumberMinValue() {
            return -2147483647;
        }

        public static int lastSentSequenceNumberMaxValue() {
            return Integer.MAX_VALUE;
        }

        public SessionsEncoder lastSentSequenceNumber(int value) {
            this.buffer.putInt(this.offset + 20, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int lastLogonTimeId() {
            return 5;
        }

        public static int lastLogonTimeSinceVersion() {
            return 0;
        }

        public static int lastLogonTimeEncodingOffset() {
            return 24;
        }

        public static int lastLogonTimeEncodingLength() {
            return 8;
        }

        public static String lastLogonTimeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long lastLogonTimeNullValue() {
            return Long.MIN_VALUE;
        }

        public static long lastLogonTimeMinValue() {
            return -9223372036854775807L;
        }

        public static long lastLogonTimeMaxValue() {
            return Long.MAX_VALUE;
        }

        public SessionsEncoder lastLogonTime(long value) {
            this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int sequenceIndexId() {
            return 6;
        }

        public static int sequenceIndexSinceVersion() {
            return 0;
        }

        public static int sequenceIndexEncodingOffset() {
            return 32;
        }

        public static int sequenceIndexEncodingLength() {
            return 4;
        }

        public static String sequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int sequenceIndexNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int sequenceIndexMinValue() {
            return -2147483647;
        }

        public static int sequenceIndexMaxValue() {
            return Integer.MAX_VALUE;
        }

        public SessionsEncoder sequenceIndex(int value) {
            this.buffer.putInt(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int slowStatusId() {
            return 15;
        }

        public static int slowStatusSinceVersion() {
            return 0;
        }

        public static int slowStatusEncodingOffset() {
            return 36;
        }

        public static int slowStatusEncodingLength() {
            return 1;
        }

        public static String slowStatusMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public SessionsEncoder slowStatus(SlowStatus value) {
            this.buffer.putByte(this.offset + 36, (byte)value.value());
            return this;
        }

        public static int addressId() {
            return 8;
        }

        public static String addressCharacterEncoding() {
            return "UTF-8";
        }

        public static String addressMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int addressHeaderLength() {
            return 2;
        }

        public SessionsEncoder putAddress(DirectBuffer src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder putAddress(byte[] src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder address(String value) {
            byte[] bytes;
            try {
                bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, bytes, 0, length);
            return this;
        }

        public static int localCompIdId() {
            return 9;
        }

        public static String localCompIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String localCompIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int localCompIdHeaderLength() {
            return 2;
        }

        public SessionsEncoder putLocalCompId(DirectBuffer src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder putLocalCompId(byte[] src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder localCompId(String value) {
            byte[] bytes;
            try {
                bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, bytes, 0, length);
            return this;
        }

        public static int localSubIdId() {
            return 10;
        }

        public static String localSubIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String localSubIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int localSubIdHeaderLength() {
            return 2;
        }

        public SessionsEncoder putLocalSubId(DirectBuffer src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder putLocalSubId(byte[] src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder localSubId(String value) {
            byte[] bytes;
            try {
                bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, bytes, 0, length);
            return this;
        }

        public static int localLocationIdId() {
            return 11;
        }

        public static String localLocationIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String localLocationIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int localLocationIdHeaderLength() {
            return 2;
        }

        public SessionsEncoder putLocalLocationId(DirectBuffer src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder putLocalLocationId(byte[] src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder localLocationId(String value) {
            byte[] bytes;
            try {
                bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, bytes, 0, length);
            return this;
        }

        public static int remoteCompIdId() {
            return 12;
        }

        public static String remoteCompIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String remoteCompIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int remoteCompIdHeaderLength() {
            return 2;
        }

        public SessionsEncoder putRemoteCompId(DirectBuffer src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder putRemoteCompId(byte[] src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder remoteCompId(String value) {
            byte[] bytes;
            try {
                bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, bytes, 0, length);
            return this;
        }

        public static int remoteSubIdId() {
            return 13;
        }

        public static String remoteSubIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String remoteSubIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int remoteSubIdHeaderLength() {
            return 2;
        }

        public SessionsEncoder putRemoteSubId(DirectBuffer src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder putRemoteSubId(byte[] src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder remoteSubId(String value) {
            byte[] bytes;
            try {
                bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, bytes, 0, length);
            return this;
        }

        public static int remoteLocationIdId() {
            return 14;
        }

        public static String remoteLocationIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String remoteLocationIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int remoteLocationIdHeaderLength() {
            return 2;
        }

        public SessionsEncoder putRemoteLocationId(DirectBuffer src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder putRemoteLocationId(byte[] src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public SessionsEncoder remoteLocationId(String value) {
            byte[] bytes;
            try {
                bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 65534) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, bytes, 0, length);
            return this;
        }
    }
}

