/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.ilink.ILink3Connection;
import uk.co.real_logic.artio.ilink.ILink3ConnectionConfiguration;
import uk.co.real_logic.artio.library.LibraryPoller;
import uk.co.real_logic.artio.library.LibraryReply;
import uk.co.real_logic.artio.messages.GatewayError;

class InitiateILink3ConnectionReply
extends LibraryReply<ILink3Connection> {
    private final ILink3ConnectionConfiguration configuration;
    private boolean onTcpConnected = false;

    InitiateILink3ConnectionReply(LibraryPoller libraryPoller, long latestReplyArrivalTime, ILink3ConnectionConfiguration configuration) {
        super(libraryPoller, latestReplyArrivalTime);
        this.configuration = configuration;
        if (libraryPoller.isConnected()) {
            this.sendMessage();
        }
    }

    @Override
    protected void sendMessage() {
        long position = this.libraryPoller.saveInitiateILink(this.correlationId, this.configuration);
        this.requiresResend = position < 0L;
    }

    @Override
    void onComplete(ILink3Connection result) {
        this.libraryPoller.deregister(this.correlationId);
        super.onComplete(result);
    }

    void onTcpConnected() {
        this.onTcpConnected = true;
    }

    @Override
    protected boolean onTimeout() {
        if (!this.onTcpConnected) {
            this.libraryPoller.onTimeoutWaitingForConnection(this.correlationId);
            super.onTimeout();
        }
        return true;
    }

    @Override
    void onError(GatewayError errorType, String errorMessage) {
        this.onError(new FixGatewayException(String.format("%s: %s", new Object[]{errorType, errorMessage})));
    }

    ILink3ConnectionConfiguration configuration() {
        return this.configuration;
    }
}

