/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixp;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.sbe.CompositeDecoderFlyweight;
import uk.co.real_logic.artio.ArtioLogHeader;
import uk.co.real_logic.artio.fixp.FixPMessageConsumer;
import uk.co.real_logic.artio.fixp.FixPMessageDissector;
import uk.co.real_logic.artio.fixp.FixPProtocol;
import uk.co.real_logic.artio.messages.FixPMessageDecoder;

public class PrintingFixPMessageConsumer
implements FixPMessageConsumer {
    private final CompositeDecoderFlyweight header;
    private final MethodHandle templateId;
    private final MethodHandle blockLength;
    private final MethodHandle version;
    private final StringBuilder builder = new StringBuilder();
    private final int inboundStreamId;
    private FixPMessageDissector dissector;

    public PrintingFixPMessageConsumer(int inboundStreamId, FixPProtocol protocol) {
        this(inboundStreamId, protocol, null);
        this.dissector = new FixPMessageDissector(this::log, protocol.messageDecoders());
    }

    public PrintingFixPMessageConsumer(int inboundStreamId, FixPProtocol protocol, FixPMessageDissector dissector) {
        this.inboundStreamId = inboundStreamId;
        this.dissector = dissector;
        this.header = protocol.makeHeader();
        Class<?> protocolHdrClass = this.header.getClass();
        MethodType methodType = MethodType.methodType(Integer.TYPE);
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            this.templateId = lookup.findVirtual(protocolHdrClass, "templateId", methodType).bindTo(this.header);
            this.blockLength = lookup.findVirtual(protocolHdrClass, "blockLength", methodType).bindTo(this.header);
            this.version = lookup.findVirtual(protocolHdrClass, "version", methodType).bindTo(this.header);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void log(String prefix, Consumer<StringBuilder> appendTo) {
        StringBuilder builder = this.builder;
        builder.setLength(0);
        builder.append(prefix);
        appendTo.accept(builder);
        System.out.println(builder);
    }

    @Override
    public void onMessage(FixPMessageDecoder unused, DirectBuffer buffer, int start, ArtioLogHeader logHeader) {
        int offset = start + 4;
        CompositeDecoderFlyweight header = this.header;
        header.wrap(buffer, offset);
        try {
            int templateId = this.templateId.invokeExact();
            int blockLength = this.blockLength.invokeExact();
            int version = this.version.invokeExact();
            boolean inbound = logHeader != null && logHeader.streamId() == this.inboundStreamId;
            this.dissector.onBusinessMessage(templateId, buffer, offset += header.encodedLength(), blockLength, version, inbound);
        }
        catch (Throwable t) {
            LangUtil.rethrowUnchecked(t);
        }
    }
}

