/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.PowerOf10;
import uk.co.real_logic.artio.util.float_parsing.CharSequenceCharReader;
import uk.co.real_logic.artio.util.float_parsing.DecimalFloatParser;

public final class DecimalFloat
implements Comparable<DecimalFloat> {
    private static final int SCALE_NAN_VALUE = -128;
    private static final long VALUE_NAN_VALUE = Long.MIN_VALUE;
    private static final double DOUBLE_NAN_VALUE = Double.NaN;
    private static final long VALUE_MAX_VAL = 999999999999999999L;
    private static final double VALUE_MAX_VAL_AS_DOUBLE = 1.0E18;
    private static final long VALUE_MIN_VAL = -999999999999999999L;
    private static final double VALUE_MIN_VAL_AS_DOUBLE = -1.0E18;
    private static final int SCALE_MAX_VAL = 127;
    private static final int SCALE_MIN_VAL = 0;
    public static final DecimalFloat MIN_VALUE = new DecimalFloat(-999999999999999999L, 0);
    public static final DecimalFloat MAX_VALUE = new DecimalFloat(999999999999999999L, 0);
    public static final DecimalFloat ZERO = new DecimalFloat();
    public static final DecimalFloat NAN;
    public static final DecimalFloat MISSING_FLOAT;
    private static final double FRACTION_LOWER_THRESHOLD = 1.0E-7;
    private static final double FRACTION_UPPER_THRESHOLD = 0.9999999;
    private long value;
    private int scale;

    public DecimalFloat() {
        this(0L, 0);
    }

    public DecimalFloat(long value) {
        this(value, 0);
    }

    public DecimalFloat(long value, int scale) {
        this.setAndNormalise(value, scale);
    }

    public void reset() {
        this.value = Long.MIN_VALUE;
        this.scale = -128;
    }

    public long value() {
        return this.value;
    }

    public int scale() {
        return this.scale;
    }

    public DecimalFloat set(DecimalFloat other) {
        this.value = other.value;
        this.scale = other.scale;
        return this;
    }

    public DecimalFloat fromLong(long value) {
        this.setAndNormalise(value, 0);
        return this;
    }

    public DecimalFloat set(long value, int scale) {
        this.setAndNormalise(value, scale);
        return this;
    }

    @Deprecated
    public DecimalFloat value(long value) {
        this.value = value;
        return this;
    }

    @Deprecated
    public DecimalFloat scale(int scale) {
        this.scale = scale;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalFloat that = (DecimalFloat)o;
        return this.scale == that.scale && this.value == that.value;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        return 31 * result + this.scale;
    }

    public void appendTo(StringBuilder builder) {
        CodecUtil.appendFloat(builder, this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    public DecimalFloat negate() {
        this.value *= -1L;
        return this;
    }

    public DecimalFloat copy() {
        return new DecimalFloat(this.value, this.scale);
    }

    @Override
    public int compareTo(DecimalFloat other) {
        long otherDecimalPointDivisor;
        long otherValueBeforeDecimalPoint;
        long value = this.value;
        int scale = this.scale;
        long otherValue = other.value;
        int otherScale = other.scale;
        long decimalPointDivisor = PowerOf10.pow10(scale);
        long valueBeforeDecimalPoint = value / decimalPointDivisor;
        int beforeDecimalPointComparison = Long.compare(valueBeforeDecimalPoint, otherValueBeforeDecimalPoint = otherValue / (otherDecimalPointDivisor = PowerOf10.pow10(otherScale)));
        if (beforeDecimalPointComparison != 0) {
            return beforeDecimalPointComparison;
        }
        long valueAfterDecimalPoint = value % decimalPointDivisor;
        long otherValueAfterDecimalPoint = otherValue % otherDecimalPointDivisor;
        if (scale > otherScale) {
            int differenceInScale = scale - otherScale;
            otherValueAfterDecimalPoint *= PowerOf10.pow10(differenceInScale);
        } else {
            int differenceInScale = otherScale - scale;
            valueAfterDecimalPoint *= PowerOf10.pow10(differenceInScale);
        }
        return Long.compare(valueAfterDecimalPoint, otherValueAfterDecimalPoint);
    }

    public double toDouble() {
        if (this.isNaNValue()) {
            return Double.NaN;
        }
        return DecimalFloat.toDouble(this.value, this.scale);
    }

    public boolean fromDouble(double doubleValue) {
        if (Double.isNaN(doubleValue)) {
            this.value = Long.MIN_VALUE;
            this.scale = -128;
            return true;
        }
        if (!Double.isFinite(doubleValue) || DecimalFloat.isOutsideLimits(doubleValue, -1.0E18, 1.0E18)) {
            return false;
        }
        if (doubleValue == 0.0) {
            this.value = 0L;
            this.scale = 0;
            return true;
        }
        boolean isNegative = doubleValue < 0.0;
        double remainingValue = Math.abs(doubleValue);
        long newValue = (long)remainingValue;
        if (DecimalFloat.isOutsideLimits(newValue, -999999999999999999L, 999999999999999999L)) {
            return false;
        }
        int newScale = 0;
        if ((remainingValue -= (double)newValue) == 0.0) {
            this.setAndNormalise(DecimalFloat.signedValue(isNegative, newValue), newScale);
            return true;
        }
        while (DecimalFloat.canValueAcceptMoreDigits(newValue, newScale) && (newValue == 0L || !DecimalFloat.isOutsideLimits(remainingValue, 1.0E-7, 0.9999999))) {
            double digit = Math.floor(remainingValue *= 10.0);
            remainingValue -= digit;
            newValue = newValue * 10L + (long)digit;
            ++newScale;
        }
        if (0.9999999 < remainingValue) {
            ++newValue;
        }
        this.setAndNormalise(DecimalFloat.signedValue(isNegative, newValue), newScale);
        return true;
    }

    public DecimalFloat fromString(CharSequence string) {
        return this.fromString(string, 0, string.length());
    }

    public DecimalFloat fromString(CharSequence string, int start, int length) {
        return DecimalFloatParser.extract(this, CharSequenceCharReader.INSTANCE, string, start, length);
    }

    public boolean isNaNValue() {
        return DecimalFloat.isNaNValue(this.value, this.scale);
    }

    public static boolean isNaNValue(long value, int scale) {
        return value == Long.MIN_VALUE && scale == -128;
    }

    public static DecimalFloat newNaNValue() {
        DecimalFloat nanFloat = new DecimalFloat();
        nanFloat.value = Long.MIN_VALUE;
        nanFloat.scale = -128;
        return nanFloat;
    }

    private void setAndNormalise(long value, int scale) {
        this.value = value;
        this.scale = scale;
        this.normalise();
    }

    private void normalise() {
        int scale;
        long value = this.value;
        if (value == 0L) {
            scale = 0;
        } else if (0 < scale) {
            for (scale = this.scale; value % 10L == 0L && 0 < scale; --scale) {
                value /= 10L;
            }
        } else if (scale < 0) {
            while (!DecimalFloat.isOutsideLimits(value, -999999999999999999L, 999999999999999999L) && scale < 0) {
                value *= 10L;
                ++scale;
            }
        }
        if (DecimalFloat.isOutsideLimits(scale, 0L, 127L) || DecimalFloat.isOutsideLimits(value, -999999999999999999L, 999999999999999999L)) {
            throw new ArithmeticException("Out of range: value: " + this.value + ", scale: " + this.scale);
        }
        this.value = value;
        this.scale = scale;
    }

    private static double toDouble(long value, int scale) {
        int remainingPowersOfTen;
        double divisor = 1.0;
        for (remainingPowersOfTen = scale; remainingPowersOfTen >= 18; remainingPowersOfTen -= 18) {
            divisor *= (double)PowerOf10.POWERS_OF_TEN[18];
        }
        return (double)value / (divisor *= (double)PowerOf10.POWERS_OF_TEN[remainingPowersOfTen]);
    }

    private static boolean canValueAcceptMoreDigits(long value, int scale) {
        return value <= PowerOf10.POWERS_OF_TEN[17] && scale < 127;
    }

    private static boolean isOutsideLimits(long value, long lowerBound, long upperBound) {
        return value < lowerBound || upperBound < value;
    }

    private static boolean isOutsideLimits(double value, double lowerBound, double upperBound) {
        return value < lowerBound || upperBound < value;
    }

    private static long signedValue(boolean isNegative, long value) {
        return isNegative ? -value : value;
    }

    static {
        MISSING_FLOAT = NAN = DecimalFloat.newNaNValue();
    }
}

