/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.artio.engine.SectorFramer;
import uk.co.real_logic.artio.engine.logger.IndexedPositionReader;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexDescriptor;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaDataStatus;
import uk.co.real_logic.artio.storage.messages.LastKnownSequenceNumberDecoder;

public class SequenceNumberIndexReader
implements AutoCloseable {
    private final MessageHeaderDecoder fileHeaderDecoder = new MessageHeaderDecoder();
    private final LastKnownSequenceNumberDecoder lastKnownDecoder = new LastKnownSequenceNumberDecoder();
    private final AtomicBuffer inMemoryBuffer;
    private final SectorFramer sectorFramer;
    private final IndexedPositionReader positions;
    private final ErrorHandler errorHandler;
    private final RecordingIdLookup recordingIdLookup;
    private final RandomAccessFile metaDataFile;

    public SequenceNumberIndexReader(AtomicBuffer inMemoryBuffer, ErrorHandler errorHandler, RecordingIdLookup recordingIdLookup, String metaDataDir) {
        this.inMemoryBuffer = inMemoryBuffer;
        this.errorHandler = errorHandler;
        this.recordingIdLookup = recordingIdLookup;
        int positionTableOffset = SequenceNumberIndexDescriptor.positionTableOffset(inMemoryBuffer.capacity());
        this.sectorFramer = new SectorFramer(positionTableOffset);
        this.validateBuffer();
        this.positions = new IndexedPositionReader(SequenceNumberIndexDescriptor.positionsBuffer(inMemoryBuffer, positionTableOffset));
        this.metaDataFile = this.openMetaDataFile(metaDataDir);
    }

    private RandomAccessFile openMetaDataFile(String metaDataDir) {
        if (metaDataDir != null) {
            File metaDataFile = SequenceNumberIndexDescriptor.metaDataFile(metaDataDir);
            try {
                return new RandomAccessFile(metaDataFile, "r");
            }
            catch (FileNotFoundException e) {
                LangUtil.rethrowUnchecked(e);
            }
        }
        return null;
    }

    public int lastKnownSequenceNumber(long sessionId) {
        int position = 8;
        while ((position = this.sectorFramer.claim(position, 24)) != -1) {
            this.lastKnownDecoder.wrap(this.inMemoryBuffer, position, 24, 8);
            if (this.lastKnownDecoder.sessionId() == sessionId) {
                int sequenceNumber = this.lastKnownDecoder.sequenceNumber();
                return sequenceNumber;
            }
            position += 24;
        }
        return -1;
    }

    public long indexedPosition(int aeronSessionId) {
        if (this.recordingIdLookup == null) {
            return -1L;
        }
        long recordingId = this.recordingIdLookup.findRecordingId(aeronSessionId);
        if (recordingId == -1L) {
            return -1L;
        }
        return this.positions.indexedPosition(recordingId);
    }

    private void validateBuffer() {
        LoggerUtil.validateBuffer(this.inMemoryBuffer, this.fileHeaderDecoder, 666, this.errorHandler);
    }

    public MetaDataStatus readMetaData(long sessionId, DirectBuffer buffer) {
        if (this.metaDataFile == null) {
            return MetaDataStatus.FILE_ERROR;
        }
        if (this.lastKnownSequenceNumber(sessionId) == -1) {
            return MetaDataStatus.UNKNOWN_SESSION;
        }
        int metaDataPosition = this.lastKnownDecoder.metaDataPosition();
        if (metaDataPosition == -1) {
            return MetaDataStatus.NO_META_DATA;
        }
        try {
            this.metaDataFile.seek(metaDataPosition);
            int metaDataLength = this.metaDataFile.readInt();
            byte[] metaDataValue = new byte[metaDataLength];
            this.metaDataFile.read(metaDataValue);
            buffer.wrap(metaDataValue);
            return MetaDataStatus.OK;
        }
        catch (IOException e) {
            this.errorHandler.onError(e);
            return MetaDataStatus.FILE_ERROR;
        }
    }

    @Override
    public void close() {
        CloseHelper.close(this.metaDataFile);
    }
}

