/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.ReplayerTimestampEncoder;

class ReplayTimestamper {
    private static final long TIMESTAMP_MESSAGE_INTERVAL = TimeUnit.SECONDS.toNanos(2L);
    private final UnsafeBuffer timestampBuffer = new UnsafeBuffer(new byte[16]);
    private final ReplayerTimestampEncoder replayerTimestampEncoder = new ReplayerTimestampEncoder();
    private final EpochNanoClock clock;
    private final ExclusivePublication publication;
    private long nextTimestampMessageInNs;

    ReplayTimestamper(ExclusivePublication publication, EpochNanoClock clock) {
        this.publication = publication;
        this.clock = clock;
        this.updateTimestamp(clock.nanoTime());
        MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
        this.replayerTimestampEncoder.wrapAndApplyHeader(this.timestampBuffer, 0, messageHeaderEncoder);
    }

    void sendTimestampMessage() {
        long timeInNs = this.clock.nanoTime();
        if (timeInNs > this.nextTimestampMessageInNs) {
            this.replayerTimestampEncoder.timestamp(timeInNs);
            long position = this.publication.offer(this.timestampBuffer);
            if (position > 0L) {
                this.updateTimestamp(timeInNs);
            }
        }
    }

    private void updateTimestamp(long timeInNs) {
        this.nextTimestampMessageInNs = timeInNs + TIMESTAMP_MESSAGE_INTERVAL;
    }
}

