/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.UnsafeAccess;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.Long2ObjectCache;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.ExistingBufferFactory;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.engine.logger.RecordingRange;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.engine.logger.ReplayOperation;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordDecoder;

public class ReplayQuery
implements AutoCloseable {
    private final MessageHeaderDecoder messageFrameHeader = new MessageHeaderDecoder();
    private final ReplayIndexRecordDecoder indexRecord = new ReplayIndexRecordDecoder();
    private final LongFunction<SessionQuery> newSessionQuery = x$0 -> new SessionQuery(x$0);
    private final Long2ObjectCache<SessionQuery> fixSessionToIndex;
    private final String logFileDir;
    private final File logFileDirFile;
    private final ExistingBufferFactory indexBufferFactory;
    private final int requiredStreamId;
    private final IdleStrategy idleStrategy;
    private final AeronArchive aeronArchive;
    private final ErrorHandler errorHandler;
    private final int archiveReplayStream;
    private Subscription replaySubscription;

    public ReplayQuery(String logFileDir, int cacheNumSets, int cacheSetSize, ExistingBufferFactory indexBufferFactory, int requiredStreamId, IdleStrategy idleStrategy, AeronArchive aeronArchive, ErrorHandler errorHandler, int archiveReplayStream) {
        this.logFileDir = logFileDir;
        this.indexBufferFactory = indexBufferFactory;
        this.requiredStreamId = requiredStreamId;
        this.idleStrategy = idleStrategy;
        this.aeronArchive = aeronArchive;
        this.errorHandler = errorHandler;
        this.archiveReplayStream = archiveReplayStream;
        this.logFileDirFile = new File(logFileDir);
        this.fixSessionToIndex = new Long2ObjectCache<SessionQuery>(cacheNumSets, cacheSetSize, SessionQuery::close);
    }

    public ReplayOperation query(long sessionId, int beginSequenceNumber, int beginSequenceIndex, int endSequenceNumber, int endSequenceIndex, LogTag logTag, MessageTracker tracker) {
        return this.lookupSessionQuery(sessionId).query(beginSequenceNumber, beginSequenceIndex, endSequenceNumber, endSequenceIndex, logTag, tracker);
    }

    public void queryStartPositions(Long2LongHashMap newStartPositions) {
        LongHashSet allSessionIds = ReplayIndexDescriptor.listReplayIndexSessionIds(this.logFileDirFile, this.requiredStreamId);
        for (SessionQuery query : this.fixSessionToIndex.values()) {
            ReplayQuery.aggregateLowerPosition(query.queryStartPositions(), newStartPositions);
            allSessionIds.remove(query.sessionId);
        }
        LongHashSet.LongIterator sessionIdIt = allSessionIds.iterator();
        while (sessionIdIt.hasNext()) {
            long sessionId = sessionIdIt.nextValue();
            SessionQuery query = this.lookupSessionQuery(sessionId);
            ReplayQuery.aggregateLowerPosition(query.queryStartPositions(), newStartPositions);
        }
    }

    private SessionQuery lookupSessionQuery(long sessionId) {
        return this.fixSessionToIndex.computeIfAbsent(sessionId, this.newSessionQuery);
    }

    @Override
    public void close() {
        this.fixSessionToIndex.clear();
        CloseHelper.close(this.replaySubscription);
    }

    static int updateStartPosition(int sequenceIndex, int highestSequenceIndex, Long2LongHashMap recordingIdToStartPosition, long recordingId, long beginPosition) {
        long oldPosition;
        if (sequenceIndex > highestSequenceIndex) {
            recordingIdToStartPosition.clear();
            recordingIdToStartPosition.put(recordingId, ReplayQuery.trueBeginPosition(beginPosition));
            return sequenceIndex;
        }
        if (sequenceIndex == highestSequenceIndex && (oldPosition = recordingIdToStartPosition.get(recordingId)) == -1L) {
            recordingIdToStartPosition.put(recordingId, ReplayQuery.trueBeginPosition(beginPosition));
        }
        return highestSequenceIndex;
    }

    static long trueBeginPosition(long beginPosition) {
        return beginPosition - 32L;
    }

    static void aggregateLowerPosition(Long2LongHashMap recordingIdToStartPosition, Long2LongHashMap newStartPositions) {
        Long2LongHashMap.EntryIterator it = recordingIdToStartPosition.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            long recordingId = it.getLongKey();
            long position = it.getLongValue();
            long oldPosition = newStartPositions.get(recordingId);
            if (oldPosition != -1L && position >= oldPosition) continue;
            newStartPositions.put(recordingId, position);
        }
    }

    private final class SessionQuery
    implements AutoCloseable {
        private final ByteBuffer wrappedBuffer;
        private final long sessionId;
        private final UnsafeBuffer buffer;
        private final int capacity;
        private final int actingBlockLength;
        private final int actingVersion;

        SessionQuery(long sessionId) {
            this.wrappedBuffer = ReplayQuery.this.indexBufferFactory.map(ReplayIndexDescriptor.replayIndexFile(ReplayQuery.this.logFileDir, sessionId, ReplayQuery.this.requiredStreamId));
            this.buffer = new UnsafeBuffer(this.wrappedBuffer);
            this.capacity = ReplayIndexDescriptor.recordCapacity(this.buffer.capacity());
            this.sessionId = sessionId;
            ReplayQuery.this.messageFrameHeader.wrap(this.buffer, 0);
            this.actingBlockLength = ReplayQuery.this.messageFrameHeader.blockLength();
            this.actingVersion = ReplayQuery.this.messageFrameHeader.version();
        }

        ReplayOperation query(int beginSequenceNumber, int beginSequenceIndex, int endSequenceNumber, int endSequenceIndex, LogTag logTag, MessageTracker messageTracker) {
            int actingBlockLength = this.actingBlockLength;
            int actingVersion = this.actingVersion;
            boolean upToMostRecentMessage = endSequenceNumber == 0;
            ArrayList<RecordingRange> ranges = new ArrayList<RecordingRange>();
            RecordingRange currentRange = null;
            long iteratorPosition = this.getIteratorPosition();
            long stopIteratingPosition = iteratorPosition + (long)this.capacity;
            int lastSequenceNumber = -1;
            while (iteratorPosition < stopIteratingPosition) {
                long changePosition = ReplayIndexDescriptor.endChangeVolatile(this.buffer);
                if (changePosition > iteratorPosition && iteratorPosition + (long)this.capacity <= ReplayIndexDescriptor.beginChangeVolatile(this.buffer)) {
                    iteratorPosition = changePosition;
                    stopIteratingPosition = iteratorPosition + (long)this.capacity;
                }
                int offset = ReplayIndexDescriptor.offset(iteratorPosition, this.capacity);
                ReplayQuery.this.indexRecord.wrap(this.buffer, offset, actingBlockLength, actingVersion);
                long beginPosition = ReplayQuery.this.indexRecord.position();
                int sequenceIndex = ReplayQuery.this.indexRecord.sequenceIndex();
                int sequenceNumber = ReplayQuery.this.indexRecord.sequenceNumber();
                long recordingId = ReplayQuery.this.indexRecord.recordingId();
                int readLength = ReplayQuery.this.indexRecord.length();
                UnsafeAccess.UNSAFE.loadFence();
                if (changePosition == ReplayIndexDescriptor.beginChangeVolatile(this.buffer)) {
                    boolean withinQueryRange;
                    boolean afterEnd;
                    ReplayQuery.this.idleStrategy.reset();
                    boolean bl = afterEnd = !upToMostRecentMessage && (sequenceIndex > endSequenceIndex || sequenceIndex == endSequenceIndex && sequenceNumber > endSequenceNumber);
                    if (beginPosition == 0L || afterEnd) break;
                    boolean bl2 = withinQueryRange = sequenceIndex > beginSequenceIndex || sequenceIndex == beginSequenceIndex && sequenceNumber >= beginSequenceNumber;
                    if (withinQueryRange) {
                        currentRange = this.addRange(ranges, currentRange, lastSequenceNumber, beginPosition, sequenceNumber, recordingId, readLength);
                        lastSequenceNumber = sequenceNumber;
                        iteratorPosition += 32L;
                        continue;
                    }
                    iteratorPosition = this.skipToStart(beginSequenceNumber, iteratorPosition, sequenceNumber);
                    continue;
                }
                ReplayQuery.this.idleStrategy.idle();
            }
            if (currentRange != null) {
                ranges.add(currentRange);
            }
            return this.newReplayOperation(ranges, logTag, messageTracker);
        }

        private long skipToStart(int beginSequenceNumber, long iteratorPosition, int sequenceNumber) {
            if (sequenceNumber < beginSequenceNumber) {
                return this.jumpPosition(beginSequenceNumber, sequenceNumber, iteratorPosition);
            }
            return iteratorPosition + 32L;
        }

        private long jumpPosition(int beginSequenceNumber, int sequenceNumber, long iteratorPosition) {
            int sequenceNumberJump = beginSequenceNumber - sequenceNumber;
            int jumpInBytes = sequenceNumberJump * 32;
            return iteratorPosition + (long)jumpInBytes;
        }

        private ReplayOperation newReplayOperation(List<RecordingRange> ranges, LogTag logTag, MessageTracker messageTracker) {
            if (ReplayQuery.this.replaySubscription == null) {
                ReplayQuery.this.replaySubscription = ReplayQuery.this.aeronArchive.context().aeron().addSubscription("aeron:ipc", ReplayQuery.this.archiveReplayStream);
            }
            return new ReplayOperation(ranges, ReplayQuery.this.aeronArchive, ReplayQuery.this.errorHandler, ReplayQuery.this.replaySubscription, ReplayQuery.this.archiveReplayStream, logTag, messageTracker);
        }

        private RecordingRange addRange(List<RecordingRange> ranges, RecordingRange currentRange, int lastSequenceNumber, long beginPosition, int sequenceNumber, long recordingId, int readLength) {
            RecordingRange range = currentRange;
            if (range == null) {
                range = new RecordingRange(recordingId, this.sessionId);
            } else if (range.recordingId != recordingId) {
                ranges.add(range);
                range = new RecordingRange(recordingId, this.sessionId);
            }
            range.add(ReplayQuery.trueBeginPosition(beginPosition), readLength + 32);
            if (lastSequenceNumber != sequenceNumber) {
                ++range.count;
            }
            return range;
        }

        private long getIteratorPosition() {
            long iteratorPosition = ReplayIndexDescriptor.beginChangeVolatile(this.buffer);
            if (iteratorPosition < (long)this.capacity) {
                iteratorPosition = 0L;
            }
            return iteratorPosition;
        }

        public Long2LongHashMap queryStartPositions() {
            int actingBlockLength = this.actingBlockLength;
            int actingVersion = this.actingVersion;
            long iteratorPosition = this.getIteratorPosition();
            long stopIteratingPosition = iteratorPosition + (long)this.capacity;
            Long2LongHashMap recordingIdToStartPosition = new Long2LongHashMap(-1L);
            int highestSequenceIndex = 0;
            while (iteratorPosition != stopIteratingPosition) {
                long changePosition = ReplayIndexDescriptor.endChangeVolatile(this.buffer);
                if (changePosition > iteratorPosition && iteratorPosition + (long)this.capacity <= ReplayIndexDescriptor.beginChangeVolatile(this.buffer)) {
                    iteratorPosition = changePosition;
                    stopIteratingPosition = iteratorPosition + (long)this.capacity;
                }
                int offset = ReplayIndexDescriptor.offset(iteratorPosition, this.capacity);
                ReplayQuery.this.indexRecord.wrap(this.buffer, offset, actingBlockLength, actingVersion);
                long beginPosition = ReplayQuery.this.indexRecord.position();
                int sequenceIndex = ReplayQuery.this.indexRecord.sequenceIndex();
                int sequenceNumber = ReplayQuery.this.indexRecord.sequenceNumber();
                long recordingId = ReplayQuery.this.indexRecord.recordingId();
                UnsafeAccess.UNSAFE.loadFence();
                if (changePosition == ReplayIndexDescriptor.beginChangeVolatile(this.buffer)) {
                    ReplayQuery.this.idleStrategy.reset();
                    if (beginPosition == 0L) {
                        return recordingIdToStartPosition;
                    }
                    highestSequenceIndex = ReplayQuery.updateStartPosition(sequenceIndex, highestSequenceIndex, recordingIdToStartPosition, recordingId, beginPosition);
                    iteratorPosition += 32L;
                    continue;
                }
                ReplayQuery.this.idleStrategy.idle();
            }
            return recordingIdToStartPosition;
        }

        @Override
        public void close() {
            if (this.wrappedBuffer instanceof MappedByteBuffer) {
                IoUtil.unmap((MappedByteBuffer)this.wrappedBuffer);
            }
        }
    }
}

