/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.status.RecordingPos;
import io.aeron.logbuffer.FragmentHandler;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.CountersReader;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.engine.logger.RecordingRange;
import uk.co.real_logic.artio.util.CharFormatter;

public class ReplayOperation {
    private static final FragmentHandler EMPTY_FRAGMENT_HANDLER = (buffer, offset, length, header) -> {};
    private static final ThreadLocal<CharFormatter> RECORDING_RANGE_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("ReplayOperation : Attempting Recording Range: RecordingRange{recordingId=%s, sessionId=%s, position=%s, length=%s, count=%s}"));
    private static final ThreadLocal<CharFormatter> POLLING_REPLAY_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("Polling Replay Image pos=%s"));
    private static final ThreadLocal<CharFormatter> FINISHED_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("Finished with Image @ pos=%s, closed=%s, eos=%s"));
    private static final ThreadLocal<CharFormatter> MESSAGE_REPLAY_COUNT_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("Finished with messageTrackerCount=%s, recordingRangeCount=%s"));
    private static final ThreadLocal<CharFormatter> INIT_CLOSING_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("ReplayOperation:INIT_CLOSING - stopReplay id=%s"));
    private static final ThreadLocal<CharFormatter> FIND_IMAGE_CLOSING_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("ReplayOperation:FIND_IMAGE_CLOSING: - id=%s,image=%s"));
    private static final ThreadLocal<CharFormatter> POLL_IMAGE_CLOSING_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("ReplayOperation:POLL_IMAGE_CLOSING: - id=%s"));
    private static final ThreadLocal<CharFormatter> CLOSED_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("ReplayOperation:CLOSED - id=%s"));
    private final MessageTracker messageTracker;
    private final ControlledFragmentAssembler assembler;
    private final List<RecordingRange> ranges;
    private final AeronArchive aeronArchive;
    private final ErrorHandler errorHandler;
    private final int archiveReplayStream;
    private final LogTag logTag;
    private final CountersReader countersReader;
    private final Subscription subscription;
    private int replayedMessages = 0;
    private RecordingRange recordingRange;
    private long replaySessionId;
    private int aeronSessionId;
    private Image image;
    private State state = State.REPLAYING;

    ReplayOperation(List<RecordingRange> ranges, AeronArchive aeronArchive, ErrorHandler errorHandler, Subscription subscription, int archiveReplayStream, LogTag logTag, MessageTracker messageTracker) {
        this.messageTracker = messageTracker;
        this.assembler = new ControlledFragmentAssembler(this.messageTracker);
        this.ranges = ranges;
        this.aeronArchive = aeronArchive;
        this.errorHandler = errorHandler;
        this.archiveReplayStream = archiveReplayStream;
        this.logTag = logTag;
        Aeron aeron = aeronArchive.context().aeron();
        this.countersReader = aeron.countersReader();
        this.subscription = subscription;
    }

    public boolean pollReplay() {
        if (this.state == State.REPLAYING) {
            return this.attemptReplay();
        }
        return this.attemptClose();
    }

    /*
     * Unable to fully structure code
     */
    private boolean attemptClose() {
        switch (1.$SwitchMap$uk$co$real_logic$artio$engine$logger$ReplayOperation$State[this.state.ordinal()]) {
            case 1: {
                if (this.replaySessionId == 0L) ** GOTO lbl13
                DebugLogger.log(this.logTag, ReplayOperation.INIT_CLOSING_FORMATTER.get(), this.replaySessionId);
                try {
                    this.aeronArchive.stopReplay(this.replaySessionId);
                }
                catch (ArchiveException e) {
                    if (e.errorCode() == 6) ** GOTO lbl11
                    this.errorHandler.onError(e);
                }
lbl11:
                // 3 sources

                this.state = this.image == null ? State.FIND_IMAGE_CLOSING : State.POLL_IMAGE_CLOSING;
                return false;
lbl13:
                // 1 sources

                this.logClosed();
                this.state = State.CLOSED;
                return true;
            }
            case 2: {
                this.image = this.subscription.imageBySessionId(this.aeronSessionId);
                logId = this.image == null ? 0 : this.aeronSessionId;
                DebugLogger.log(this.logTag, ReplayOperation.FIND_IMAGE_CLOSING_FORMATTER.get(), this.replaySessionId, (long)logId);
                if (this.image == null) {
                    return false;
                }
                this.state = State.POLL_IMAGE_CLOSING;
                return this.attemptClose();
            }
            case 3: {
                DebugLogger.log(this.logTag, ReplayOperation.POLL_IMAGE_CLOSING_FORMATTER.get(), this.replaySessionId);
                while (null != this.image && !this.image.isClosed() && !this.image.isEndOfStream()) {
                    this.image.poll(ReplayOperation.EMPTY_FRAGMENT_HANDLER, 0x7FFFFFFF);
                }
                this.logClosed();
                this.state = State.CLOSED;
                return true;
            }
        }
        this.logClosed();
        return true;
    }

    private void logClosed() {
        DebugLogger.log(this.logTag, CLOSED_FORMATTER.get(), this.replaySessionId);
    }

    private boolean attemptReplay() {
        if (this.recordingRange == null) {
            DebugLogger.log(this.logTag, "Acquiring Recording Range");
            if (this.ranges.isEmpty()) {
                return true;
            }
            this.recordingRange = this.ranges.get(0);
            this.logRange();
            long beginPosition = this.recordingRange.position;
            long length = this.recordingRange.length;
            long endPosition = beginPosition + length;
            long recordingId = this.recordingRange.recordingId;
            if (this.archivingNotComplete(endPosition, recordingId)) {
                DebugLogger.log(this.logTag, "Archiving not complete");
                this.recordingRange = null;
                return false;
            }
            this.ranges.remove(0);
            try {
                this.replaySessionId = this.aeronArchive.startReplay(recordingId, beginPosition, length, "aeron:ipc", this.archiveReplayStream);
                this.aeronSessionId = (int)this.replaySessionId;
                this.messageTracker.reset();
                if (this.image != null && this.aeronSessionId != this.image.sessionId()) {
                    this.image = null;
                }
            }
            catch (Throwable exception) {
                this.errorHandler.onError(exception);
                return true;
            }
        }
        if (this.image == null) {
            DebugLogger.log(this.logTag, "Acquiring Replay Image");
            this.image = this.subscription.imageBySessionId(this.aeronSessionId);
            return false;
        }
        if (DebugLogger.isEnabled(this.logTag)) {
            DebugLogger.log(this.logTag, POLLING_REPLAY_FORMATTER.get().clear().with(this.image.position()));
        }
        this.image.controlledPoll(this.assembler, Integer.MAX_VALUE);
        int messageTrackerCount = this.messageTracker.count;
        int recordingRangeCount = this.recordingRange.count;
        boolean closed = this.image.isClosed();
        boolean endOfStream = this.image.isEndOfStream();
        if (closed || endOfStream) {
            return this.onEndOfImage(recordingRangeCount, closed, endOfStream);
        }
        if (messageTrackerCount < recordingRangeCount) {
            return false;
        }
        return this.onReachedMessageReplayCount(messageTrackerCount, recordingRangeCount);
    }

    private void logRange() {
        LogTag logTag = this.logTag;
        if (DebugLogger.isEnabled(logTag)) {
            RecordingRange recordingRange = this.recordingRange;
            DebugLogger.log(logTag, RECORDING_RANGE_FORMATTER.get().clear().with(recordingRange.recordingId).with(recordingRange.sessionId).with(recordingRange.position).with(recordingRange.length).with(recordingRange.count));
        }
    }

    private boolean onReachedMessageReplayCount(int messageTrackerCount, int recordingRangeCount) {
        DebugLogger.log(this.logTag, MESSAGE_REPLAY_COUNT_FORMATTER.get(), (long)messageTrackerCount, (long)recordingRangeCount);
        this.replayedMessages += recordingRangeCount;
        this.recordingRange = null;
        return this.ranges.isEmpty();
    }

    private boolean onEndOfImage(int recordingRangeCount, boolean closed, boolean endOfStream) {
        if (DebugLogger.isEnabled(this.logTag)) {
            DebugLogger.log(this.logTag, FINISHED_FORMATTER.get().clear().with(this.image.position()).with(closed).with(endOfStream));
        }
        this.aeronSessionId = 0;
        this.replaySessionId = 0L;
        this.replayedMessages += recordingRangeCount;
        this.recordingRange = null;
        this.image = null;
        return this.ranges.isEmpty();
    }

    int replayedMessages() {
        return this.replayedMessages;
    }

    private boolean archivingNotComplete(long endPosition, long recordingId) {
        int counterId = RecordingPos.findCounterIdByRecording(this.countersReader, recordingId);
        if (counterId != -1) {
            long counterPosition = this.countersReader.getCounterValue(counterId);
            return counterPosition < endPosition;
        }
        return false;
    }

    public void startClose() {
        this.state = State.INIT_CLOSING;
    }

    public void closeNow() {
        this.startClose();
        this.attemptClose();
    }

    private static enum State {
        REPLAYING,
        INIT_CLOSING,
        FIND_IMAGE_CLOSING,
        POLL_IMAGE_CLOSING,
        CLOSED;

    }
}

