/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import java.util.Objects;
import org.agrona.BitUtil;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;

public final class ReplayIndexDescriptor {
    private static final int BEGIN_CHANGE_OFFSET = 8;
    private static final int END_CHANGE_OFFSET = 16;
    public static final int INITIAL_RECORD_OFFSET = 24;
    public static final int RECORD_LENGTH = 32;

    static File replayIndexFile(String logFileDir, long fixSessionId, int streamId) {
        return new File(String.format(logFileDir + File.separator + "replay-index-%d-%d", fixSessionId, streamId));
    }

    static LongHashSet listReplayIndexSessionIds(File logFileDir, int streamId) {
        String prefix = "replay-index-";
        String suffix = "-" + streamId;
        LongHashSet sessionIds = new LongHashSet();
        for (File file : Objects.requireNonNull(logFileDir.listFiles())) {
            String fileName = file.getName();
            if (!fileName.startsWith("replay-index-") || !fileName.endsWith(suffix)) continue;
            int suffixIndex = fileName.length() - suffix.length();
            String sessionIdString = fileName.substring("replay-index-".length(), suffixIndex);
            long sessionId = Long.parseLong(sessionIdString);
            sessionIds.add(sessionId);
        }
        return sessionIds;
    }

    public static UnsafeBuffer replayPositionBuffer(String logFileDir, int streamId, int bufferSize) {
        String pathname = ReplayIndexDescriptor.replayPositionPath(logFileDir, streamId);
        return new UnsafeBuffer(LoggerUtil.map(new File(pathname), bufferSize));
    }

    static String replayPositionPath(String logFileDir, int streamId) {
        return logFileDir + File.separator + "replay-positions-" + streamId;
    }

    static void endChangeOrdered(AtomicBuffer buffer, long changePosition) {
        buffer.putLongOrdered(16, changePosition);
    }

    static long endChangeVolatile(AtomicBuffer buffer) {
        return buffer.getLongVolatile(16);
    }

    static void beginChangeOrdered(AtomicBuffer buffer, long changePosition) {
        buffer.putLongOrdered(8, changePosition);
    }

    static long beginChangeVolatile(AtomicBuffer buffer) {
        return buffer.getLongVolatile(8);
    }

    static long beginChange(AtomicBuffer buffer) {
        return buffer.getLong(8);
    }

    static int recordCapacity(int indexFileSize) {
        return indexFileSize - 24;
    }

    static int offset(long changePosition, int capacity) {
        return 24 + ((int)changePosition & capacity - 1);
    }

    static void checkIndexFileSize(int indexFileSize) {
        int recordCapacity = ReplayIndexDescriptor.recordCapacity(indexFileSize);
        if (!BitUtil.isPowerOfTwo(recordCapacity)) {
            throw new IllegalStateException("IndexFileSize must be a positive power of 2 + INITIAL_RECORD_OFFSET: indexFileSize=" + indexFileSize);
        }
        if (recordCapacity % 32 != 0) {
            throw new IllegalStateException("IndexFileSize must be a multiple of RECORD_LENGTH + INITIAL_RECORD_OFFSET: indexFileSize=" + indexFileSize);
        }
    }
}

