/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;

public final class LoggerUtil {
    public static ByteBuffer map(File file, int size) {
        if (file.exists()) {
            return IoUtil.mapExistingFile(file, file.getName());
        }
        return LoggerUtil.mapNewFile(file, size);
    }

    public static MappedByteBuffer mapNewFile(File file, int size) {
        File parentDir = file.getParentFile();
        IoUtil.ensureDirectoryExists(parentDir, parentDir.getAbsolutePath());
        return IoUtil.mapNewFile(file, size);
    }

    public static MappedByteBuffer mapExistingFile(File file) {
        return IoUtil.mapExistingFile(file, file.getName());
    }

    public static boolean initialiseBuffer(AtomicBuffer buffer, MessageHeaderEncoder headerEncoder, MessageHeaderDecoder headerDecoder, int sbeSchemaId, int sbeTemplateId, int actingVersion, int actingBlockLength, ErrorHandler errorHandler) {
        headerDecoder.wrap(buffer, 0);
        if (headerDecoder.blockLength() == 0) {
            LoggerUtil.writeHeader(buffer, headerEncoder, sbeSchemaId, sbeTemplateId, actingVersion, actingBlockLength);
            return true;
        }
        if (!LoggerUtil.validateBuffer(buffer, headerDecoder, sbeSchemaId, errorHandler)) {
            LoggerUtil.writeHeader(buffer, headerEncoder, sbeSchemaId, sbeTemplateId, actingVersion, actingBlockLength);
            int offset = headerEncoder.encodedLength();
            int length = buffer.capacity() - offset;
            buffer.setMemory(offset, length, (byte)0);
        }
        return false;
    }

    private static void writeHeader(AtomicBuffer buffer, MessageHeaderEncoder headerEncoder, int sbeSchemaId, int sbeTemplateId, int actingVersion, int actingBlockLength) {
        headerEncoder.wrap(buffer, 0).blockLength(actingBlockLength).templateId(sbeTemplateId).schemaId(sbeSchemaId).version(actingVersion);
    }

    static boolean validateBuffer(AtomicBuffer buffer, MessageHeaderDecoder headerDecoder, int sbeSchemaId, ErrorHandler errorHandler) {
        headerDecoder.wrap(buffer, 0);
        return LoggerUtil.validateField(sbeSchemaId, headerDecoder.schemaId(), "Schema Id", errorHandler);
    }

    private static boolean validateField(int expected, int read, String name, ErrorHandler errorHandler) {
        if (read != expected) {
            IllegalStateException exception = new IllegalStateException(String.format("Wrong %s: expected %d and got %d", name, expected, read));
            errorHandler.onError(exception);
            return false;
        }
        return true;
    }
}

