/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.Long2LongHashMap;
import uk.co.real_logic.artio.engine.logger.FixPSequenceNumberHandler;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.fixp.AbstractFixPSequenceExtractor;
import uk.co.real_logic.artio.fixp.FixPProtocol;
import uk.co.real_logic.artio.fixp.FixPProtocolFactory;
import uk.co.real_logic.artio.messages.FixPMessageDecoder;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.ILinkConnectDecoder;
import uk.co.real_logic.artio.messages.InboundFixPConnectDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

class FixPSequenceIndexer {
    private final Long2LongHashMap connectionIdToFixPSessionId;
    private final ErrorHandler errorHandler;
    private final FixPProtocolType fixPProtocolType;
    private final FixPSequenceNumberHandler handler;
    private final SequenceNumberIndexReader sequenceNumberReader;
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final FixPMessageDecoder fixPMessage = new FixPMessageDecoder();
    private final ILinkConnectDecoder iLinkConnect = new ILinkConnectDecoder();
    private final InboundFixPConnectDecoder inboundFixPConnect = new InboundFixPConnectDecoder();
    private AbstractFixPSequenceExtractor sequenceExtractor;
    private boolean attemptedProtocolInit = false;

    FixPSequenceIndexer(Long2LongHashMap connectionIdToFixPSessionId, ErrorHandler errorHandler, FixPProtocolType fixPProtocolType, SequenceNumberIndexReader sequenceNumberReader, FixPSequenceNumberHandler handler) {
        this.connectionIdToFixPSessionId = connectionIdToFixPSessionId;
        this.errorHandler = errorHandler;
        this.fixPProtocolType = fixPProtocolType;
        this.sequenceNumberReader = sequenceNumberReader;
        this.handler = handler;
    }

    public void onFragment(DirectBuffer buffer, int srcOffset, int srcLength, Header header) {
        long endPosition = header.position();
        if ((header.flags() & 0x80) == 128) {
            int offset = srcOffset;
            this.messageHeader.wrap(buffer, offset);
            offset += this.messageHeader.encodedLength();
            int actingBlockLength = this.messageHeader.blockLength();
            int version = this.messageHeader.version();
            int templateId = this.messageHeader.templateId();
            switch (templateId) {
                case 58: {
                    int totalLength = BitUtil.align(srcLength, 32);
                    this.onFixPMessage(buffer, endPosition, offset, actingBlockLength, version, totalLength, header.sessionId());
                    break;
                }
                case 57: {
                    this.iLinkConnect.wrap(buffer, offset, actingBlockLength, version);
                    this.connectionIdToFixPSessionId.put(this.iLinkConnect.connection(), this.iLinkConnect.uuid());
                    break;
                }
                case 67: {
                    this.inboundFixPConnect.wrap(buffer, offset, actingBlockLength, version);
                    this.connectionIdToFixPSessionId.put(this.inboundFixPConnect.connection(), this.inboundFixPConnect.sessionId());
                }
            }
        }
    }

    private void onFixPMessage(DirectBuffer buffer, long endPosition, int offset, int actingBlockLength, int version, int totalLength, int aeronSessionId) {
        if (this.lazyLoadSequenceExtractor(true)) {
            return;
        }
        this.fixPMessage.wrap(buffer, offset, actingBlockLength, version);
        int sofhOffset = offset + 24;
        int headerOffset = sofhOffset + 4;
        long timestamp = this.fixPMessage.enqueueTime();
        this.sequenceExtractor.onMessage(this.fixPMessage, buffer, headerOffset, totalLength, endPosition, aeronSessionId, timestamp);
    }

    public void onRedactSequenceUpdate(long sessionId, int newSequenceNumber) {
        if (this.lazyLoadSequenceExtractor(false)) {
            return;
        }
        this.sequenceExtractor.onRedactSequenceUpdate(sessionId, newSequenceNumber);
    }

    private boolean lazyLoadSequenceExtractor(boolean logError) {
        if (!this.attemptedProtocolInit) {
            this.attemptedProtocolInit = true;
            FixPProtocol protocol = FixPProtocolFactory.make(this.fixPProtocolType, logError ? this.errorHandler : null);
            if (protocol == null) {
                if (logError) {
                    this.errorHandler.onError(new IllegalStateException("Configuration Issue: could not setup Binary FIXP protocol on the Engine classpath, despite Binary FIXP message requiring processing. Sequence Index update ignored. If you're using iLink3 then you should be the artio-ilink3-codecs and artio-ilink3-impldependencies on the classpath. Binary entrypoint requires a call to EngineConfiguration.acceptBinaryEntryPoint()"));
                }
                return true;
            }
            this.sequenceExtractor = protocol.makeSequenceExtractor(this.handler, this.sequenceNumberReader);
        }
        return this.sequenceExtractor == null;
    }
}

