/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.collections.LongHashSet;
import uk.co.real_logic.artio.ArtioLogHeader;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.engine.framer.MessageTypeExtractor;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.FixMessagePredicate;
import uk.co.real_logic.artio.engine.logger.HeaderField;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.BufferAsciiSequence;
import uk.co.real_logic.artio.util.MessageTypeEncoding;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class FixMessagePredicates {
    private FixMessagePredicates() {
    }

    public static FixMessageConsumer filterBy(FixMessageConsumer consumer, FixMessagePredicate predicate) {
        return new FilterBy(consumer, predicate);
    }

    public static FixMessagePredicate between(long beginTimestampInclusive, long endTimestampExclusive) {
        return FixMessagePredicates.from(beginTimestampInclusive).and(FixMessagePredicates.to(endTimestampExclusive));
    }

    public static FixMessagePredicate from(long beginTimestampInclusive) {
        return new From(beginTimestampInclusive);
    }

    public static FixMessagePredicate to(long endTimestampExclusive) {
        return new To(endTimestampExclusive);
    }

    public static FixMessagePredicate messageTypeOf(String ... messageTypes) {
        LongHashSet hashSet = new LongHashSet();
        Stream.of(messageTypes).mapToLong(MessageTypeEncoding::packMessageType).forEach(hashSet::add);
        return FixMessagePredicates.messageTypeOf(hashSet);
    }

    public static FixMessagePredicate messageTypeOf(long ... messageTypes) {
        LongHashSet hashSet = new LongHashSet();
        LongStream.of(messageTypes).forEach(hashSet::add);
        return FixMessagePredicates.messageTypeOf(hashSet);
    }

    private static FixMessagePredicate messageTypeOf(LongHashSet hashSet) {
        return message -> {
            long messageType = MessageTypeExtractor.getMessageType(message);
            return hashSet.contains(messageType);
        };
    }

    public static FixMessagePredicate sessionOf(FixDictionary fixDictionary, String senderCompId, String targetCompId) {
        return FixMessagePredicates.whereHeader(fixDictionary, FixMessagePredicates.senderCompIdOf(senderCompId).and(FixMessagePredicates.targetCompIdOf(targetCompId)));
    }

    public static Predicate<SessionHeaderDecoder> senderCompIdOf(String senderCompId) {
        return FixMessagePredicates.headerMatches(senderCompId, HeaderField.SENDER_COMP_ID, SessionHeaderDecoder::senderCompID, SessionHeaderDecoder::senderCompIDLength);
    }

    public static Predicate<SessionHeaderDecoder> targetCompIdOf(String targetCompId) {
        return FixMessagePredicates.headerMatches(targetCompId, HeaderField.TARGET_COMP_ID, SessionHeaderDecoder::targetCompID, SessionHeaderDecoder::targetCompIDLength);
    }

    public static Predicate<SessionHeaderDecoder> senderSubIdOf(String senderSubId) {
        return FixMessagePredicates.headerMatches(senderSubId, SessionHeaderDecoder::senderSubID, SessionHeaderDecoder::senderSubIDLength);
    }

    public static Predicate<SessionHeaderDecoder> targetSubIdOf(String targetSubId) {
        return FixMessagePredicates.headerMatches(targetSubId, SessionHeaderDecoder::targetSubID, SessionHeaderDecoder::targetSubIDLength);
    }

    public static Predicate<SessionHeaderDecoder> senderLocationIdOf(String senderLocationId) {
        return FixMessagePredicates.headerMatches(senderLocationId, SessionHeaderDecoder::senderLocationID, SessionHeaderDecoder::senderLocationIDLength);
    }

    public static Predicate<SessionHeaderDecoder> targetLocationIdOf(String targetLocationId) {
        return FixMessagePredicates.headerMatches(targetLocationId, SessionHeaderDecoder::targetLocationID, SessionHeaderDecoder::targetLocationIDLength);
    }

    public static Predicate<SessionHeaderDecoder> headerMatches(String value, Function<SessionHeaderDecoder, char[]> charExtractor, ToIntFunction<SessionHeaderDecoder> lengthExtractor) {
        return FixMessagePredicates.headerMatches(value, HeaderField.NOT_OPTIMISED, charExtractor, lengthExtractor);
    }

    private static Predicate<SessionHeaderDecoder> headerMatches(String value, HeaderField headerField, Function<SessionHeaderDecoder, char[]> charExtractor, ToIntFunction<SessionHeaderDecoder> lengthExtractor) {
        return new HeaderMatches(value, headerField, charExtractor, lengthExtractor);
    }

    public static FixMessagePredicate whereHeader(FixDictionary fixDictionary, Predicate<SessionHeaderDecoder> matches) {
        return new WhereHeader(fixDictionary, matches);
    }

    public static FixMessagePredicate sessionOf(long sessionId) {
        return message -> message.session() == sessionId;
    }

    public static FixMessagePredicate bodyMatches(Pattern pattern) {
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(1024);
        BufferAsciiSequence sequence = new BufferAsciiSequence();
        return message -> {
            int length = message.bodyLength();
            buffer.checkLimit(length);
            message.getBody(buffer, 0, length);
            sequence.wrap(buffer, 0, length);
            return pattern.matcher(sequence).matches();
        };
    }

    public static FixMessagePredicate alwaysTrue() {
        return message -> true;
    }

    static class WhereHeader
    implements FixMessagePredicate {
        private final Predicate<SessionHeaderDecoder> matches;
        private final SessionHeaderDecoder header;
        private final ExpandableArrayBuffer buffer;
        private final AsciiBuffer asciiBuffer;

        WhereHeader(FixDictionary fixDictionary, Predicate<SessionHeaderDecoder> matches) {
            this.header = fixDictionary.makeHeaderDecoder();
            this.matches = matches;
            this.buffer = new ExpandableArrayBuffer(1024);
            this.asciiBuffer = new MutableAsciiBuffer();
        }

        @Override
        public boolean test(FixMessageDecoder message) {
            int length = message.bodyLength();
            this.buffer.checkLimit(length);
            message.getBody(this.buffer, 0, length);
            this.asciiBuffer.wrap(this.buffer);
            this.header.decode(this.asciiBuffer, 0, length);
            return this.matches.test(this.header);
        }

        public Predicate<SessionHeaderDecoder> matches() {
            return this.matches;
        }
    }

    static class HeaderMatches
    implements Predicate<SessionHeaderDecoder> {
        final char[] expectedChars;
        final HeaderField headerField;
        final String value;
        private final Function<SessionHeaderDecoder, char[]> charExtractor;
        private final ToIntFunction<SessionHeaderDecoder> lengthExtractor;

        HeaderMatches(String value, HeaderField headerField, Function<SessionHeaderDecoder, char[]> charExtractor, ToIntFunction<SessionHeaderDecoder> lengthExtractor) {
            this.expectedChars = value.toCharArray();
            this.value = value;
            this.headerField = headerField;
            this.charExtractor = charExtractor;
            this.lengthExtractor = lengthExtractor;
        }

        @Override
        public boolean test(SessionHeaderDecoder header) {
            char[] actualChars = this.charExtractor.apply(header);
            int length = this.lengthExtractor.applyAsInt(header);
            return CodecUtil.equals(actualChars, this.expectedChars, length);
        }
    }

    static class To
    implements FixMessagePredicate {
        private final long endTimestampExclusive;

        To(long endTimestampExclusive) {
            this.endTimestampExclusive = endTimestampExclusive;
        }

        @Override
        public boolean test(FixMessageDecoder message) {
            return message.timestamp() < this.endTimestampExclusive;
        }

        public long endTimestampExclusive() {
            return this.endTimestampExclusive;
        }
    }

    static class From
    implements FixMessagePredicate {
        private final long beginTimestampInclusive;

        From(long beginTimestampInclusive) {
            this.beginTimestampInclusive = beginTimestampInclusive;
        }

        @Override
        public boolean test(FixMessageDecoder message) {
            return message.timestamp() >= this.beginTimestampInclusive;
        }

        long beginTimestampInclusive() {
            return this.beginTimestampInclusive;
        }

        public String toString() {
            return "From{beginTimestampInclusive=" + this.beginTimestampInclusive + '}';
        }
    }

    static class FilterBy
    implements FixMessageConsumer {
        final FixMessageConsumer consumer;
        final FixMessagePredicate predicate;

        FilterBy(FixMessageConsumer consumer, FixMessagePredicate predicate) {
            this.consumer = consumer;
            this.predicate = predicate;
        }

        @Override
        public void onMessage(FixMessageDecoder message, DirectBuffer buffer, int offset, int length, ArtioLogHeader header) {
            int actingVersion = message.sbeSchemaVersion();
            int actingBlockLength = message.sbeBlockLength();
            if (this.predicate.test(message)) {
                message.wrap(buffer, offset, actingBlockLength, actingVersion);
                this.consumer.onMessage(message, buffer, offset, length, header);
            }
        }

        public String toString() {
            return "FilterBy{consumer=" + this.consumer + ", predicate=" + this.predicate + '}';
        }
    }
}

