/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.ReplayCompleteEncoder;

public class SenderEndPoint
implements AutoCloseable {
    private static final int REPLAY_COMPLETE_LENGTH = 20;
    private final MessageHeaderEncoder messageHeader = new MessageHeaderEncoder();
    private final ReplayCompleteEncoder replayComplete = new ReplayCompleteEncoder();
    private final BufferClaim bufferClaim = new BufferClaim();
    private final ExclusivePublication inboundPublication;
    protected final TcpChannel channel;
    protected final AtomicCounter bytesInBuffer;
    protected final int maxBytesInBuffer;
    protected final long connectionId;
    protected int libraryId;
    protected final ErrorHandler errorHandler;
    protected final Framer framer;

    public SenderEndPoint(long connectionId, ExclusivePublication inboundPublication, int libraryId, TcpChannel channel, AtomicCounter bytesInBuffer, int maxBytesInBuffer, ErrorHandler errorHandler, Framer framer) {
        this.connectionId = connectionId;
        this.inboundPublication = inboundPublication;
        this.libraryId = libraryId;
        this.channel = channel;
        this.bytesInBuffer = bytesInBuffer;
        this.maxBytesInBuffer = maxBytesInBuffer;
        this.errorHandler = errorHandler;
        this.framer = framer;
    }

    public ControlledFragmentHandler.Action onReplayComplete() {
        BufferClaim bufferClaim = this.bufferClaim;
        long position = this.inboundPublication.tryClaim(20, bufferClaim);
        if (Pressure.isBackPressured(position)) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.replayComplete.wrapAndApplyHeader(bufferClaim.buffer(), bufferClaim.offset(), this.messageHeader).connection(this.connectionId).libraryId(this.libraryId);
        bufferClaim.commit();
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    void libraryId(int libraryId) {
        this.libraryId = libraryId;
    }

    public int libraryId() {
        return this.libraryId;
    }

    public long connectionId() {
        return this.connectionId;
    }

    protected void becomeNormalConsumer() {
        this.sendSlowStatus(false);
    }

    protected void sendSlowStatus(boolean hasBecomeSlow) {
        this.framer.slowStatus(this.libraryId, this.connectionId, hasBecomeSlow);
    }

    protected void removeEndpoint(DisconnectReason reason) {
        this.framer.onDisconnect(this.libraryId, this.connectionId, reason);
    }

    @Override
    public void close() {
        this.bytesInBuffer.close();
    }
}

