/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.engine.framer.AcceptorLogonResult;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public abstract class ReceiverEndPoint {
    protected static final int SOCKET_DISCONNECTED = -1;
    protected final GatewayPublication publication;
    protected final TcpChannel channel;
    protected final long connectionId;
    protected boolean hasDisconnected = false;
    protected final MutableAsciiBuffer buffer;
    protected final ByteBuffer byteBuffer;
    protected final ErrorHandler errorHandler;
    protected final Framer framer;
    protected int libraryId;
    protected int usedBufferData = 0;
    protected SelectionKey selectionKey;
    protected AcceptorLogonResult pendingAcceptorLogon;
    private long throttleWindowInNs;
    private int throttleLimitOfMessages;
    private long[] lastMessageTimestampsInNs;
    private int lastMessageTimestampsInNsMask;
    private int throttlePosition;

    public ReceiverEndPoint(GatewayPublication publication, TcpChannel channel, long connectionId, int bufferSize, ErrorHandler errorHandler, Framer framer, int libraryId, int throttleWindowInMs, int throttleLimitOfMessages) {
        Objects.requireNonNull(publication, "publication");
        this.publication = publication;
        this.channel = channel;
        this.connectionId = connectionId;
        this.errorHandler = errorHandler;
        this.framer = framer;
        this.libraryId = libraryId;
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.buffer = new MutableAsciiBuffer(this.byteBuffer);
        this.configureThrottle(throttleWindowInMs, throttleLimitOfMessages);
    }

    void configureThrottle(int throttleWindowInMs, int throttleLimitOfMessages) {
        if (this.throttleWindowInNs == (long)throttleWindowInMs && this.throttleLimitOfMessages == throttleLimitOfMessages) {
            return;
        }
        long[] oldLastMessageTimestampsInNs = this.lastMessageTimestampsInNs;
        int oldThrottleLimitOfMessages = this.throttleLimitOfMessages;
        int oldLastMessageTimestampsInNsMask = this.lastMessageTimestampsInNsMask;
        int oldThrottlePosition = this.throttlePosition;
        if (throttleWindowInMs == Integer.MIN_VALUE) {
            this.throttleWindowInNs = Long.MIN_VALUE;
            this.lastMessageTimestampsInNs = null;
            this.lastMessageTimestampsInNsMask = 0;
        } else {
            this.throttleWindowInNs = TimeUnit.MILLISECONDS.toNanos(throttleWindowInMs);
            int lastMessageTimestampsInNsCapacity = BitUtil.findNextPositivePowerOfTwo(throttleLimitOfMessages);
            this.lastMessageTimestampsInNs = new long[lastMessageTimestampsInNsCapacity];
            this.lastMessageTimestampsInNsMask = lastMessageTimestampsInNsCapacity - 1;
        }
        this.throttleLimitOfMessages = throttleLimitOfMessages;
        this.throttlePosition = 0;
        if (oldLastMessageTimestampsInNs != null && this.lastMessageTimestampsInNs != null) {
            int minLimitOfMessages = Math.min(oldThrottleLimitOfMessages, throttleLimitOfMessages);
            int srcPosition = Math.max(0, oldThrottlePosition - minLimitOfMessages);
            while (srcPosition < oldThrottlePosition) {
                this.lastMessageTimestampsInNs[this.throttlePosition & this.lastMessageTimestampsInNsMask] = oldLastMessageTimestampsInNs[srcPosition & oldLastMessageTimestampsInNsMask];
                ++srcPosition;
                ++this.throttlePosition;
            }
        }
    }

    final boolean shouldThrottle(long readTimestampInNs) {
        long throttleWindowInNs = this.throttleWindowInNs;
        if (throttleWindowInNs == Long.MIN_VALUE) {
            return false;
        }
        long[] lastMessageTimestampsInNs = this.lastMessageTimestampsInNs;
        int lastMessageTimestampsMask = this.lastMessageTimestampsInNsMask;
        int throttlePosition = this.throttlePosition;
        int oldestMessagePosition = throttlePosition - this.throttleLimitOfMessages;
        int oldestMessageIndex = oldestMessagePosition & lastMessageTimestampsMask;
        long oldestMessageTimestampInNs = lastMessageTimestampsInNs[oldestMessageIndex];
        int currentIndex = throttlePosition & lastMessageTimestampsMask;
        lastMessageTimestampsInNs[currentIndex] = readTimestampInNs;
        this.throttlePosition = throttlePosition + 1;
        long timeAgoOfOldestMessageInNs = readTimestampInNs - oldestMessageTimestampInNs;
        return timeAgoOfOldestMessageInNs < throttleWindowInNs;
    }

    long connectionId() {
        return this.connectionId;
    }

    void register(Selector selector) throws IOException {
        this.selectionKey = this.channel.register(selector, 1, this);
    }

    void onDisconnectDetected() {
        this.completeDisconnect(DisconnectReason.REMOTE_DISCONNECT);
    }

    void close(DisconnectReason reason) {
        this.closeResources();
        if (!this.hasDisconnected) {
            this.disconnectEndpoint(reason);
        }
    }

    void onNoLogonDisconnect() {
        this.completeDisconnect(DisconnectReason.NO_LOGON);
    }

    void onAuthenticationTimeoutDisconnect() {
        this.completeDisconnect(DisconnectReason.AUTHENTICATION_TIMEOUT);
    }

    void completeDisconnect(DisconnectReason reason) {
        this.disconnectEndpoint(reason);
        this.removeEndpointFromFramer();
    }

    abstract void removeEndpointFromFramer();

    void disconnectEndpoint(DisconnectReason reason) {
        this.framer.schedule(() -> this.publication.saveDisconnect(this.libraryId, this.connectionId, reason));
        this.cleanupDisconnectState(reason);
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        this.hasDisconnected = true;
    }

    abstract void cleanupDisconnectState(DisconnectReason var1);

    abstract int poll();

    abstract boolean retryFrameMessages();

    abstract boolean requiresAuthentication();

    abstract void closeResources();

    public void libraryId(int libraryId) {
        this.libraryId = libraryId;
    }

    public int libraryId() {
        return this.libraryId;
    }

    boolean hasDisconnected() {
        return this.hasDisconnected;
    }
}

