/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.engine.framer.ILink3Key;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPFirstMessageResponse;
import uk.co.real_logic.artio.messages.FixPProtocolType;

public final class ILink3Context
implements FixPContext {
    private final int offset;
    private long connectLastUuid;
    private long connectUuid;
    private final ILink3Key key;
    private final EpochNanoClock clock;
    private long uuid;
    private long lastUuid;
    private boolean newlyAllocated;
    private boolean primaryConnected;
    private boolean backupConnected;

    public ILink3Context(ILink3Key key, EpochNanoClock clock, long uuid, long lastUuid, long connectUuid, long connectLastUuid, boolean newlyAllocated, int offset) {
        this.key = key;
        this.clock = clock;
        this.uuid = uuid;
        this.lastUuid = lastUuid;
        this.connectLastUuid = connectLastUuid;
        this.connectUuid = connectUuid;
        this.newlyAllocated = newlyAllocated;
        this.offset = offset;
    }

    public long uuid() {
        return this.uuid;
    }

    void uuid(long uuid) {
        this.uuid = uuid;
    }

    long lastUuid() {
        return this.lastUuid;
    }

    void lastUuid(long lastUuid) {
        this.lastUuid = lastUuid;
    }

    boolean newlyAllocated() {
        return this.newlyAllocated;
    }

    void newlyAllocated(boolean newlyAllocated) {
        this.newlyAllocated = newlyAllocated;
    }

    boolean primaryConnected() {
        return this.primaryConnected;
    }

    public void primaryConnected(boolean connected) {
        this.primaryConnected = connected;
    }

    boolean backupConnected() {
        return this.backupConnected;
    }

    public void backupConnected(boolean connected) {
        this.backupConnected = connected;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public boolean onInitiatorNegotiateResponse() {
        this.uuid = this.connectUuid;
        this.lastUuid = this.connectLastUuid;
        return this.lastUuid == 0L;
    }

    @Override
    public void onInitiatorDisconnect() {
        if (this.backupConnected) {
            this.backupConnected(false);
        } else {
            this.primaryConnected(false);
        }
    }

    public void connectLastUuid(long uuid) {
        this.connectLastUuid = uuid;
    }

    public long connectLastUuid() {
        return this.connectLastUuid;
    }

    public void connectUuid(long newUuid) {
        this.connectUuid = newUuid;
    }

    public long connectUuid() {
        return this.connectUuid;
    }

    @Override
    public FixPFirstMessageResponse checkAccept(FixPContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareVersion(FixPContext oldContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initiatorReconnect(boolean reestablishConnection) {
        long connectLastUuid = this.uuid();
        this.connectLastUuid(connectLastUuid);
        boolean newlyAllocated = !reestablishConnection || connectLastUuid == 0L;
        this.newlyAllocated(newlyAllocated);
        if (newlyAllocated) {
            long newUuid = this.clock.nanoTime();
            this.connectUuid(newUuid);
        } else {
            this.connectUuid(connectLastUuid);
        }
    }

    @Override
    public FixPProtocolType protocolType() {
        return FixPProtocolType.ILINK_3;
    }

    @Override
    public void onEndSequence() {
    }

    @Override
    public ILink3Key key() {
        return this.key;
    }

    public String toString() {
        return "ILink3Context{connectLastUuid=" + this.connectLastUuid + ", connectUuid=" + this.connectUuid + ", uuid=" + this.uuid + ", lastUuid=" + this.lastUuid + ", newlyAllocated=" + this.newlyAllocated + ", primaryConnected=" + this.primaryConnected + ", backupConnected=" + this.backupConnected + '}';
    }

    @Override
    public long surrogateSessionId() {
        return this.connectUuid;
    }
}

