/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.function.LongToIntFunction;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.engine.framer.FixSenderEndPoint;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.ThrottleRejectDecoder;

class FixSenderEndPoints
implements AutoCloseable,
ControlledFragmentHandler {
    private static final int HEADER_LENGTH = 8;
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final FixMessageDecoder fixMessage = new FixMessageDecoder();
    private final ThrottleRejectDecoder throttleReject = new ThrottleRejectDecoder();
    private final Long2ObjectHashMap<FixSenderEndPoint> connectionIdToSenderEndpoint = new Long2ObjectHashMap();
    private final ErrorHandler errorHandler;
    private final LongToIntFunction libraryLookup = this::libraryLookup;
    private long timeInMs;

    private int libraryLookup(long sessionId) {
        for (FixSenderEndPoint senderEndPoint : this.connectionIdToSenderEndpoint.values()) {
            if (senderEndPoint.sessionId() != sessionId) continue;
            return senderEndPoint.libraryId();
        }
        return 0;
    }

    FixSenderEndPoints(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void add(FixSenderEndPoint senderEndPoint) {
        this.connectionIdToSenderEndpoint.put(senderEndPoint.connectionId(), senderEndPoint);
    }

    void removeConnection(long connectionId) {
        FixSenderEndPoint senderEndPoint = this.connectionIdToSenderEndpoint.remove(connectionId);
        if (senderEndPoint != null) {
            senderEndPoint.close();
        }
    }

    boolean onMessage(int libraryId, long connectionId, DirectBuffer buffer, int offset, int length, int sequenceNumber, long position) {
        FixSenderEndPoint endPoint = this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            endPoint.onOutboundMessage(libraryId, buffer, offset, length, sequenceNumber, position, this.timeInMs);
            return true;
        }
        return false;
    }

    ControlledFragmentHandler.Action onThrottleReject(int libraryId, long connectionId, long refMsgType, int refSeqNum, int sequenceNumber, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength, long position) {
        FixSenderEndPoint endPoint = this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            endPoint.onThrottleReject(libraryId, refMsgType, refSeqNum, sequenceNumber, businessRejectRefIDBuffer, businessRejectRefIDOffset, businessRejectRefIDLength, position, this.timeInMs);
        }
        return null;
    }

    ControlledFragmentHandler.Action onReplayMessage(long connectionId, DirectBuffer buffer, int offset, int length, long position) {
        FixSenderEndPoint endPoint = this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            return endPoint.onReplayMessage(buffer, offset, length, this.timeInMs, position);
        }
        this.logReplayError(connectionId, buffer, offset, length);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onSlowReplayMessage(long connectionId, DirectBuffer buffer, int offset, int length, long position, int metaDataLength) {
        FixSenderEndPoint endPoint = this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            return endPoint.onSlowReplayMessage(buffer, offset, length, this.timeInMs, position, metaDataLength);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void logReplayError(long connectionId, DirectBuffer buffer, int offset, int length) {
        this.errorHandler.onError(new IllegalArgumentException(String.format("Failed to replay message on conn=%1$d [%2$s], this probably indicates the connection has disconnected from Artio whilst this message was in the process of being replayed", connectionId, buffer.getStringWithoutLengthUtf8(offset, length))));
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        return this.onSlowConsumerMessageFragment(buffer, offset, length, header.position());
    }

    private ControlledFragmentHandler.Action onSlowConsumerMessageFragment(DirectBuffer buffer, int offset, int length, long position) {
        MessageHeaderDecoder messageHeader = this.messageHeader;
        messageHeader.wrap(buffer, offset);
        int templateId = messageHeader.templateId();
        if (templateId == 1) {
            int version = messageHeader.version();
            this.fixMessage.wrap(buffer, offset += 8, messageHeader.blockLength(), version);
            long connectionId = this.fixMessage.connection();
            FixSenderEndPoint senderEndPoint = this.connectionIdToSenderEndpoint.get(connectionId);
            if (senderEndPoint != null) {
                int metaDataLength = this.fixMessage.skipMetaData();
                int bodyLength = this.fixMessage.bodyLength();
                int libraryId = this.fixMessage.libraryId();
                int sequenceNumber = this.fixMessage.sequenceNumber();
                return senderEndPoint.onSlowOutboundMessage(buffer, offset, length - 8, position, bodyLength, libraryId, this.timeInMs, metaDataLength, sequenceNumber);
            }
        } else if (templateId == 71) {
            int version = messageHeader.version();
            this.throttleReject.wrap(buffer, offset += 8, messageHeader.blockLength(), version);
            long connectionId = this.throttleReject.connection();
            FixSenderEndPoint senderEndPoint = this.connectionIdToSenderEndpoint.get(connectionId);
            if (senderEndPoint != null) {
                int businessRejectRefIDOffset = this.throttleReject.limit() + ThrottleRejectDecoder.businessRejectRefIDHeaderLength();
                return senderEndPoint.onSlowThrottleReject(this.throttleReject.libraryId(), this.throttleReject.refMsgType(), this.throttleReject.refSeqNum(), this.throttleReject.sequenceNumber(), buffer, businessRejectRefIDOffset, this.throttleReject.businessRejectRefIDLength(), position, this.timeInMs);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onReplayComplete(long connectionId) {
        FixSenderEndPoint senderEndPoint = this.connectionIdToSenderEndpoint.get(connectionId);
        if (senderEndPoint != null) {
            return senderEndPoint.onReplayComplete();
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public void close() {
        this.connectionIdToSenderEndpoint.values().forEach(FixSenderEndPoint::close);
    }

    public boolean isSlowConsumer(long connectionId) {
        FixSenderEndPoint fixSenderEndPoint = this.connectionIdToSenderEndpoint.get(connectionId);
        return fixSenderEndPoint != null && fixSenderEndPoint.isSlowConsumer();
    }

    void timeInMs(long timeInMs) {
        this.timeInMs = timeInMs;
    }

    int checkTimeouts(long timeInMs) {
        int count = 0;
        for (FixSenderEndPoint senderEndPoint : this.connectionIdToSenderEndpoint.values()) {
            if (!senderEndPoint.checkTimeouts(timeInMs)) continue;
            ++count;
        }
        return count;
    }

    LongToIntFunction libraryLookup() {
        return this.libraryLookup;
    }
}

