/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.framer.FixPGatewaySession;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.fixp.FixPRejectRefIdExtractor;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.FixPMessageEncoder;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

abstract class FixPReceiverEndPoint
extends ReceiverEndPoint {
    public static final int ARTIO_HEADER_LENGTH = 32;
    private static final int TEMPLATE_ID_OFFSET = 6;
    private final FixPMessageEncoder fixPMessage = new FixPMessageEncoder();
    private final UnsafeBuffer headerBuffer = new UnsafeBuffer(new byte[32]);
    private final ExclusivePublication inboundPublication;
    private final EpochNanoClock epochNanoClock;
    private final long correlationId;
    private final short encodingType;
    private final FixPRejectRefIdExtractor fixPRejectRefIdExtractor;
    protected FixPGatewaySession fixPGatewaySession;
    private long sessionId;

    FixPReceiverEndPoint(long connectionId, TcpChannel channel, int bufferSize, ErrorHandler errorHandler, Framer framer, GatewayPublication publication, int libraryId, EpochNanoClock epochNanoClock, long correlationId, short encodingType, int throttleWindowInMs, int throttleLimitOfMessages, FixPRejectRefIdExtractor fixPRejectRefIdExtractor) {
        super(publication, channel, connectionId, bufferSize, errorHandler, framer, libraryId, throttleWindowInMs, throttleLimitOfMessages);
        this.inboundPublication = publication.dataPublication();
        this.epochNanoClock = epochNanoClock;
        this.correlationId = correlationId;
        this.encodingType = encodingType;
        this.fixPRejectRefIdExtractor = fixPRejectRefIdExtractor;
        this.makeHeader();
    }

    private void makeHeader() {
        MessageHeaderEncoder header = new MessageHeaderEncoder();
        this.fixPMessage.wrapAndApplyHeader(this.headerBuffer, 0, header).connection(this.connectionId);
    }

    public void sessionId(long sessionId) {
        this.sessionId = sessionId;
        this.fixPMessage.sessionId(sessionId);
    }

    @Override
    void removeEndpointFromFramer() {
        this.trackDisconnect();
        this.framer.onDisconnect(this.libraryId, this.connectionId, null);
    }

    @Override
    void cleanupDisconnectState(DisconnectReason reason) {
    }

    @Override
    boolean retryFrameMessages() {
        return this.frameMessages();
    }

    private int readData() throws IOException {
        int dataRead = this.channel.read(this.byteBuffer);
        if (dataRead != -1) {
            if (dataRead > 0) {
                DebugLogger.logBytes(LogTag.FIX_MESSAGE_TCP, "Read     ", this.byteBuffer, this.usedBufferData, dataRead);
            }
            this.usedBufferData += dataRead;
        } else {
            this.onDisconnectDetected();
        }
        return dataRead;
    }

    @Override
    int poll() {
        if (this.pendingAcceptorLogon != null) {
            return this.pollPendingAcceptorLogon();
        }
        try {
            int bytesRead = this.readData();
            if (bytesRead > 0) {
                return this.frameMessages() ? bytesRead : -bytesRead;
            }
            if (this.usedBufferData > 0) {
                return this.frameMessages() ? 1 : -1;
            }
            return bytesRead;
        }
        catch (ClosedChannelException ex) {
            this.onDisconnectDetected();
        }
        catch (IllegalArgumentException ex) {
            this.errorHandler.onError(ex);
            this.saveError(ex);
            this.completeDisconnect(DisconnectReason.INVALID_FIXP_MESSAGE);
        }
        catch (Exception ex) {
            if (!Exceptions.isJustDisconnect(ex)) {
                this.errorHandler.onError(ex);
            }
            this.saveError(ex);
            this.onDisconnectDetected();
        }
        return 1;
    }

    private int pollPendingAcceptorLogon() {
        if (this.pendingAcceptorLogon.poll()) {
            if (!this.pendingAcceptorLogon.isAccepted()) {
                this.completeDisconnect(this.pendingAcceptorLogon.reason());
            }
            this.pendingAcceptorLogon = null;
        }
        return 1;
    }

    private void saveError(Exception ex) {
        this.framer.saveError(GatewayError.EXCEPTION, this.libraryId, this.correlationId, ex.getMessage());
    }

    private boolean frameMessages() {
        MutableAsciiBuffer buffer = this.buffer;
        int offset = 0;
        while (this.usedBufferData > 4) {
            int messageSize = SimpleOpenFramingHeader.readSofh(buffer, offset, this.encodingType);
            if (messageSize > this.usedBufferData) {
                this.moveRemainingDataToBufferStart(offset);
                return true;
            }
            this.checkMessage(buffer, offset, messageSize);
            long nanoTime = this.epochNanoClock.nanoTime();
            if (this.shouldThrottle(nanoTime)) {
                if (!this.throttleMessage(buffer, offset)) {
                    this.moveRemainingDataToBufferStart(offset);
                    return false;
                }
            } else {
                this.fixPMessage.enqueueTime(nanoTime);
                long position = this.inboundPublication.offer(this.headerBuffer, 0, 32, buffer, offset, messageSize);
                if (position < 0L) {
                    this.moveRemainingDataToBufferStart(offset);
                    return false;
                }
            }
            this.usedBufferData -= messageSize;
            offset += messageSize;
        }
        this.moveRemainingDataToBufferStart(offset);
        return true;
    }

    private boolean throttleMessage(DirectBuffer buffer, int offset) {
        FixPRejectRefIdExtractor fixPRejectRefIdExtractor = this.fixPRejectRefIdExtractor;
        fixPRejectRefIdExtractor.search(buffer, offset);
        long refMsgType = fixPRejectRefIdExtractor.messageType();
        int refIdOffset = fixPRejectRefIdExtractor.offset();
        int refIdLength = fixPRejectRefIdExtractor.length();
        long position = this.publication.saveThrottleNotification(this.libraryId, this.connectionId, refMsgType, -1, this.sessionId, -1, buffer, refIdOffset, refIdLength);
        return position > 0L;
    }

    abstract void checkMessage(MutableAsciiBuffer var1, int var2, int var3);

    static int readTemplateId(MutableAsciiBuffer buffer, int offset) {
        return buffer.getShort(offset + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    private void moveRemainingDataToBufferStart(int offset) {
        if (this.usedBufferData > 0) {
            this.buffer.putBytes(0, this.buffer, offset, this.usedBufferData);
        }
        ByteBufferUtil.position(this.byteBuffer, this.usedBufferData);
    }

    @Override
    void closeResources() {
        this.trackDisconnect();
        try {
            this.channel.close();
        }
        catch (Exception ex) {
            this.errorHandler.onError(ex);
        }
    }

    public void gatewaySession(FixPGatewaySession fixPGatewaySession) {
        this.fixPGatewaySession = fixPGatewaySession;
    }

    abstract void trackDisconnect();
}

