/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.io.IOException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.engine.MessageTimingHandler;
import uk.co.real_logic.artio.engine.framer.FixPSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.fixp.AbstractFixPOffsets;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;

class ExplicitFixPSenderEndPoint
extends FixPSenderEndPoint {
    private final MessageTimingHandler messageTimingHandler;

    ExplicitFixPSenderEndPoint(long connectionId, TcpChannel channel, ErrorHandler errorHandler, ExclusivePublication inboundPublication, int libraryId, MessageTimingHandler messageTimingHandler, AtomicCounter bytesInBuffer, int maxBytesInBuffer, Framer framer) {
        super(connectionId, channel, errorHandler, inboundPublication, libraryId, bytesInBuffer, maxBytesInBuffer, framer);
        this.messageTimingHandler = messageTimingHandler;
    }

    @Override
    public ControlledFragmentHandler.Action onMessage(DirectBuffer directBuffer, int offset, boolean retransmit) {
        try {
            int sbeHeaderOffset;
            long sequenceNumber;
            int messageSize = SimpleOpenFramingHeader.readSofhMessageSize(directBuffer, offset);
            int totalWritten = this.writeBuffer(directBuffer, offset, messageSize);
            if (totalWritten < messageSize) {
                this.reattemptBytesWritten = totalWritten;
                return ControlledFragmentHandler.Action.ABORT;
            }
            if (this.messageTimingHandler != null && (sequenceNumber = AbstractFixPOffsets.clientSeqNum(directBuffer, sbeHeaderOffset = offset + 4)) != -1L) {
                this.messageTimingHandler.onMessage(sequenceNumber, this.connectionId);
            }
            this.reattemptBytesWritten = 0;
        }
        catch (IOException e) {
            this.errorHandler.onError(e);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    boolean reattempt() {
        return true;
    }
}

