/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import uk.co.real_logic.artio.dictionary.generation.GeneratorDictionaryConfiguration;

public final class SharedCodecConfiguration {
    private final boolean allowDuplicateFieldsDefault;
    private boolean splitDirectories = true;
    private final List<GeneratorDictionaryConfiguration> dictionaries = new ArrayList<GeneratorDictionaryConfiguration>();

    SharedCodecConfiguration(boolean allowDuplicateFieldsDefault) {
        this.allowDuplicateFieldsDefault = allowDuplicateFieldsDefault;
    }

    public SharedCodecConfiguration splitDirectories(boolean splitDirectories) {
        this.splitDirectories = splitDirectories;
        return this;
    }

    public SharedCodecConfiguration withDictionary(String dictionaryName, String ... fileNames) {
        return this.withDictionary(dictionaryName, this.allowDuplicateFieldsDefault, fileNames);
    }

    public SharedCodecConfiguration withDictionary(String dictionaryName, boolean allowDuplicateFields, String ... fileNames) {
        if (fileNames.length == 0) {
            throw new IllegalArgumentException("Please provide file names for Dictionary");
        }
        return this.withDictionary(dictionaryName, null, fileNames, allowDuplicateFields);
    }

    public SharedCodecConfiguration withDictionary(String dictionaryName, InputStream ... fileStreams) {
        return this.withDictionary(dictionaryName, this.allowDuplicateFieldsDefault, fileStreams);
    }

    public SharedCodecConfiguration withDictionary(String dictionaryName, boolean allowDuplicateFields, InputStream ... fileStreams) {
        if (fileStreams.length == 0) {
            throw new IllegalArgumentException("Please provide file names for Dictionary");
        }
        return this.withDictionary(dictionaryName, fileStreams, null, allowDuplicateFields);
    }

    private SharedCodecConfiguration withDictionary(String dictionaryName, InputStream[] fileStreams, String[] fileNames, boolean allowDuplicateFields) {
        Objects.requireNonNull(dictionaryName);
        this.dictionaries.add(new GeneratorDictionaryConfiguration(dictionaryName, fileStreams, fileNames, allowDuplicateFields));
        return this;
    }

    List<GeneratorDictionaryConfiguration> dictionaries() {
        return this.dictionaries;
    }

    boolean splitDirectories() {
        return this.splitDirectories;
    }
}

