/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.agrona.LangUtil;
import org.agrona.collections.IntHashSet;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.artio.builder.CharRepresentable;
import uk.co.real_logic.artio.builder.IntRepresentable;
import uk.co.real_logic.artio.builder.StringRepresentable;
import uk.co.real_logic.artio.dictionary.CharArrayMap;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.dictionary.generation.ConstantGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

final class EnumGenerator {
    static final String NULL_VAL_NAME = "NULL_VAL";
    public static final String NULL_VAL_CHAR_AS_STRING = Character.toString('\u0001');
    public static final String NULL_VAL_INT_AS_STRING = Integer.toString(Integer.MIN_VALUE);
    public static final String NULL_VAL_STRING = CodecUtil.ENUM_MISSING_STRING;
    static final String UNKNOWN_NAME = "ARTIO_UNKNOWN";
    public static final String UNKNOWN_CHAR_AS_STRING = Character.toString('\u0002');
    public static final String UNKNOWN_INT_AS_STRING = Integer.toString(Integer.MAX_VALUE);
    public static final String UNKNOWN_STRING = CodecUtil.ENUM_UNKNOWN_STRING;
    private final Dictionary dictionary;
    private final String builderPackage;
    private final OutputManager outputManager;

    static String enumName(String name) {
        return JavaUtil.formatClassName(name);
    }

    EnumGenerator(Dictionary dictionary, String builderPackage, OutputManager outputManager) {
        this.dictionary = dictionary;
        this.builderPackage = builderPackage;
        this.outputManager = outputManager;
    }

    public void generate() {
        if (this.dictionary.hasSharedParent()) {
            return;
        }
        this.dictionary.fields().values().stream().filter(EnumGenerator::hasEnumGenerated).forEach(this::generateEnum);
    }

    static boolean hasEnumGenerated(Field field) {
        return field.isEnum() && field.type() != Field.Type.BOOLEAN;
    }

    private void generateEnum(Field field) {
        String interfaceToImport;
        String interfaceToImplement;
        String unknownValue;
        String nullValue;
        String enumName = EnumGenerator.enumName(field.name());
        Field.Type type = field.type();
        List<Field.Value> values = field.values();
        if (this.isCharBased(type)) {
            nullValue = NULL_VAL_CHAR_AS_STRING;
            unknownValue = UNKNOWN_CHAR_AS_STRING;
            interfaceToImplement = "Char";
            interfaceToImport = GenerationUtil.importFor(CharRepresentable.class);
        } else if (type.isIntBased()) {
            nullValue = NULL_VAL_INT_AS_STRING;
            unknownValue = UNKNOWN_INT_AS_STRING;
            interfaceToImplement = "Int";
            interfaceToImport = GenerationUtil.importFor(IntRepresentable.class);
        } else if (type.isStringBased()) {
            nullValue = NULL_VAL_STRING;
            unknownValue = UNKNOWN_STRING;
            interfaceToImplement = "String";
            interfaceToImport = GenerationUtil.importFor(StringRepresentable.class);
        } else {
            System.err.printf("Unable to generate an enum for type: %s. No sentinel defined for %s\n", new Object[]{enumName, type});
            return;
        }
        ArrayList<Field.Value> valuesWithSentinels = new ArrayList<Field.Value>(values);
        valuesWithSentinels.add(new Field.Value(nullValue, NULL_VAL_NAME));
        valuesWithSentinels.add(new Field.Value(unknownValue, UNKNOWN_NAME));
        this.outputManager.withOutput(enumName, out -> {
            try {
                out.append(GenerationUtil.fileHeader(this.builderPackage));
                out.append(GenerationUtil.importFor(CharArrayMap.class));
                out.append(GenerationUtil.importFor(CharArrayWrapper.class));
                out.append(GenerationUtil.importFor(IntHashSet.class));
                out.append(GenerationUtil.importFor(Map.class));
                out.append(GenerationUtil.importFor(HashMap.class));
                out.append(interfaceToImport);
                out.append(this.generateEnumDeclaration(enumName, interfaceToImplement));
                out.append(this.generateEnumValues(valuesWithSentinels, type));
                out.append(this.generateEnumBody(enumName, type));
                out.append(this.generateEnumLookupMethod(enumName, values, type));
            }
            catch (IOException e) {
                LangUtil.rethrowUnchecked(e);
            }
            catch (IllegalArgumentException e) {
                System.err.printf("Unable to generate an enum for type: %s\n", enumName);
                System.err.println(e.getMessage());
            }
            finally {
                out.append("}\n");
            }
        });
    }

    private boolean isCharBased(Field.Type type) {
        return type == Field.Type.CHAR;
    }

    private String generateEnumDeclaration(String name, String interfaceToImplement) {
        String format = "public enum " + name + " implements %sRepresentable\n{\n";
        return String.format(format, interfaceToImplement);
    }

    private String generateEnumValues(List<Field.Value> allValues, Field.Type type) {
        return allValues.stream().map(value -> {
            String javadoc = "";
            List<String> alternativeNames = value.alternativeNames();
            if (alternativeNames != null) {
                javadoc = alternativeNames.stream().collect(Collectors.joining(", ", "/** Altnames: ", " */ "));
            }
            return String.format("%1$s%4$s%2$s(%3$s)", "    ", value.description(), this.literal((Field.Value)value, type), javadoc);
        }).collect(Collectors.joining(",\n"));
    }

    private String generateEnumBody(String name, Field.Type type) {
        GenerationUtil.Var representation = this.representation(type);
        return ";\n\n" + representation.field() + GenerationUtil.constructor(name, representation) + representation.getter();
    }

    private String generateEnumLookupMethod(String name, List<Field.Value> allValues, Field.Type type) {
        if (this.hasGeneratedValueOf(type)) {
            return "";
        }
        String optionalCharArrayDecode = this.optionalCharArrayDecode(name, allValues, type);
        String enumValidation = this.enumValidation(allValues, type);
        GenerationUtil.Var representation = this.representation(type);
        String cases = allValues.stream().map(value -> String.format("        case %s: return %s;\n", this.literal((Field.Value)value, type), value.description())).collect(Collectors.joining());
        return String.format("%s%s    public static %s decode(%s)\n    {\n        switch(representation)\n        {\n%s        default:\n            return %s;\n        }\n    }\n", optionalCharArrayDecode, enumValidation, name, representation.methodArgsDeclaration(), cases, UNKNOWN_NAME);
    }

    private String enumValidation(List<Field.Value> allValues, Field.Type type) {
        switch (type) {
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case STRING: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return "    public static boolean isValid(final CharArrayWrapper key)\n    {\n        return charMap.containsKey(key);\n    }\n";
            }
        }
        String primitiveValues = allValues.stream().map(value -> this.literal((Field.Value)value, type)).map(repr -> String.format("        intSet.add(%1$s);\n", repr)).collect(Collectors.joining());
        return String.format("    private static final IntHashSet intSet = new IntHashSet(%2$s);\n    %1$s\n\n    public static boolean isValid(final int representation)\n    {\n        return intSet.contains(representation);\n    }\n", GenerationUtil.optionalStaticInit(primitiveValues), ConstantGenerator.sizeHashSet(allValues));
    }

    private String optionalCharArrayDecode(String typeName, List<Field.Value> allValues, Field.Type type) {
        switch (type) {
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case STRING: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                String entries = allValues.stream().map(v -> String.format("        stringMap.put(%s, %s);\n", this.literal((Field.Value)v, type), v.description())).collect(Collectors.joining());
                return String.format("    private static final CharArrayMap<%1$s> charMap;\n    static\n    {\n        final Map<String, %1$s> stringMap = new HashMap<>();\n%2$s        charMap = new CharArrayMap<>(stringMap);\n    }\n\n    public static %1$s decode(final CharArrayWrapper key)\n    {\n        final %1$s value = charMap.get(key);\n        if (value == null)\n        {\n            return %3$s;\n        }\n        return value;\n    }\n", typeName, entries, UNKNOWN_NAME);
            }
        }
        return "";
    }

    private boolean hasGeneratedValueOf(Field.Type type) {
        switch (type) {
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: {
                return true;
            }
        }
        return false;
    }

    private GenerationUtil.Var representation(Field.Type type) {
        String argTypeValue;
        String typeValue;
        switch (type) {
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case STRING: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: {
                typeValue = "String";
                argTypeValue = "String";
                break;
            }
            case CHAR: {
                typeValue = "char";
                argTypeValue = "int";
                break;
            }
            default: {
                typeValue = "int";
                argTypeValue = "int";
            }
        }
        return new GenerationUtil.Var(typeValue, argTypeValue, "representation");
    }

    private String literal(Field.Value value, Field.Type type) {
        String representation = value.representation();
        switch (type) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                Integer.parseInt(representation);
                return representation;
            }
            case LONG: {
                Long.parseLong(representation);
                return representation;
            }
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case STRING: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: {
                return '\"' + representation + '\"';
            }
            case CHAR: {
                if (representation.length() > 1) {
                    throw new IllegalArgumentException(representation + " has a length of 2 and thus won't fit into a char");
                }
                return "'" + representation + "'";
            }
        }
        throw new IllegalArgumentException("Unknown type for creating an enum from: " + (Object)((Object)type) + " for value " + value.description());
    }
}

