/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.BiFunction;
import org.agrona.generation.OutputManager;
import org.agrona.generation.PackageOutputManager;
import uk.co.real_logic.artio.builder.RejectUnknownEnumValue;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.DictionaryParser;
import uk.co.real_logic.artio.dictionary.generation.AcceptorGenerator;
import uk.co.real_logic.artio.dictionary.generation.CodecConfiguration;
import uk.co.real_logic.artio.dictionary.generation.CodecSharer;
import uk.co.real_logic.artio.dictionary.generation.ConstantGenerator;
import uk.co.real_logic.artio.dictionary.generation.DecoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.EncoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.dictionary.generation.FixDictionaryGenerator;
import uk.co.real_logic.artio.dictionary.generation.GeneratorDictionaryConfiguration;
import uk.co.real_logic.artio.dictionary.generation.PrinterGenerator;
import uk.co.real_logic.artio.dictionary.generation.SharedCodecConfiguration;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;

public final class CodecGenerator {
    public static final String SHARED_DIR_NAME = "shared";

    public static void generate(CodecConfiguration configuration) throws Exception {
        boolean hasSharedCodecs;
        configuration.conclude();
        String outputPath = configuration.outputPath();
        String codecRejectUnknownEnumValueEnabled = configuration.codecRejectUnknownEnumValueEnabled();
        boolean bl = hasSharedCodecs = configuration.sharedCodecConfiguration() != null;
        if (hasSharedCodecs) {
            CodecGenerator.generateSharedDictionaries(configuration, outputPath, codecRejectUnknownEnumValueEnabled);
        } else {
            CodecGenerator.generateNormalDictionaries(configuration, outputPath, codecRejectUnknownEnumValueEnabled);
        }
    }

    private static void generateSharedDictionaries(CodecConfiguration configuration, String outputPath, String codecRejectUnknownEnumValueEnabled) {
        SharedCodecConfiguration sharedCodecs = configuration.sharedCodecConfiguration();
        ArrayList<Dictionary> inputDictionaries = new ArrayList<Dictionary>();
        for (GeneratorDictionaryConfiguration dictionaryConfig : sharedCodecs.dictionaries()) {
            String name = CodecGenerator.normalise(dictionaryConfig.dictionaryName());
            try {
                DictionaryParser parser = new DictionaryParser(dictionaryConfig.allowDuplicateFields());
                Dictionary dictionary2 = CodecGenerator.parseStreams(parser, dictionaryConfig.toStreams());
                dictionary2.name(name);
                inputDictionaries.add(dictionary2);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse: " + name, e);
            }
        }
        new CodecSharer(inputDictionaries).share();
        boolean splitDirectories = sharedCodecs.splitDirectories();
        inputDictionaries.forEach(dictionary -> {
            String suffixDir = dictionary.shared() ? SHARED_DIR_NAME : dictionary.name();
            String dictOutputPath = outputPath + (splitDirectories ? File.separatorChar + suffixDir : "");
            CodecGenerator.generateDictionary(configuration, dictOutputPath, codecRejectUnknownEnumValueEnabled, dictionary);
        });
    }

    private static String normalise(String dictionaryName) {
        return dictionaryName.replace('.', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateNormalDictionaries(CodecConfiguration configuration, String outputPath, String codecRejectUnknownEnumValueEnabled) throws Exception {
        GeneratorDictionaryConfiguration nonSharedDictionary = configuration.nonSharedDictionary();
        DictionaryParser parser = new DictionaryParser(nonSharedDictionary.allowDuplicateFields());
        AutoCloseable[] fileStreams = nonSharedDictionary.toStreams();
        try {
            Dictionary dictionary = CodecGenerator.parseStreams(parser, (InputStream[])fileStreams);
            CodecGenerator.generateDictionary(configuration, outputPath, codecRejectUnknownEnumValueEnabled, dictionary);
        }
        finally {
            Exceptions.closeAll(fileStreams);
        }
    }

    private static Dictionary parseStreams(DictionaryParser parser, InputStream[] fileStreams) throws Exception {
        Dictionary dictionary = null;
        for (InputStream fileStream : fileStreams) {
            dictionary = parser.parse(fileStream, dictionary);
        }
        return dictionary;
    }

    private static void generateDictionary(CodecConfiguration configuration, String outputPath, String codecRejectUnknownEnumValueEnabled, Dictionary dictionary) {
        String parentPackage = configuration.parentPackage();
        String name = dictionary.name();
        if (name != null) {
            parentPackage = parentPackage + "." + name;
        }
        String encoderPackage = parentPackage + ".builder";
        String decoderPackage = parentPackage + ".decoder";
        String decoderFlyweightPackage = parentPackage + ".decoder_flyweight";
        BiFunction<String, String, OutputManager> outputManagerFactory = configuration.outputManagerFactory();
        OutputManager parentOutput = outputManagerFactory.apply(outputPath, parentPackage);
        OutputManager decoderOutput = outputManagerFactory.apply(outputPath, decoderPackage);
        OutputManager encoderOutput = outputManagerFactory.apply(outputPath, encoderPackage);
        new EnumGenerator(dictionary, parentPackage, parentOutput).generate();
        new ConstantGenerator(dictionary, parentPackage, configuration.parentPackage(), parentOutput).generate();
        new FixDictionaryGenerator(dictionary, parentOutput, encoderPackage, decoderPackage, parentPackage).generate();
        new EncoderGenerator(dictionary, encoderPackage, parentPackage, encoderOutput, Validation.class, RejectUnknownField.class, RejectUnknownEnumValue.class, codecRejectUnknownEnumValueEnabled).generate();
        new DecoderGenerator(dictionary, 1, decoderPackage, parentPackage, encoderPackage, decoderOutput, Validation.class, RejectUnknownField.class, RejectUnknownEnumValue.class, false, codecRejectUnknownEnumValueEnabled).generate();
        new PrinterGenerator(dictionary, decoderPackage, decoderOutput).generate();
        new AcceptorGenerator(dictionary, decoderPackage, decoderOutput).generate();
        if (configuration.flyweightsEnabled()) {
            PackageOutputManager flyweightDecoderOutput = new PackageOutputManager(outputPath, decoderFlyweightPackage);
            new DecoderGenerator(dictionary, 1, decoderFlyweightPackage, parentPackage, encoderPackage, flyweightDecoderOutput, Validation.class, RejectUnknownField.class, RejectUnknownEnumValue.class, true, codecRejectUnknownEnumValueEnabled).generate();
        }
    }
}

