/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.util.function.Predicate;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;

public final class LongDictionary {
    private static final int MISSING_FIELD = -1;
    private static final int CAPACITY = 1024;
    private final Long2ObjectHashMap<IntHashSet> map = new Long2ObjectHashMap();

    public static LongDictionary requiredFields(Dictionary dictionary) {
        return LongDictionary.fields(dictionary, Entry::required);
    }

    public static LongDictionary allFields(Dictionary dictionary) {
        return LongDictionary.fields(dictionary, entry -> true);
    }

    private static LongDictionary fields(Dictionary dictionary, Predicate<Entry> entryPredicate) {
        LongDictionary fields = new LongDictionary();
        dictionary.messages().forEach(message -> {
            long type = message.packedType();
            message.entries().stream().filter(entryPredicate).filter(entry -> entry.element() instanceof Field).map(entry -> (Field)entry.element()).forEach(field -> fields.put(type, field.number()));
        });
        return fields;
    }

    public void put(long key, int value) {
        this.valuesOrDefault(key).add(value);
    }

    public void putAll(long key, int ... valuesToAdd) {
        IntHashSet values = this.valuesOrDefault(key);
        for (int value : valuesToAdd) {
            values.add(value);
        }
    }

    private IntHashSet valuesOrDefault(long key) {
        return this.map.computeIfAbsent(key, ignore -> new IntHashSet(1024));
    }

    public IntHashSet values(long key) {
        return this.map.get(key);
    }

    public boolean contains(long key, int value) {
        IntHashSet fields = this.values(key);
        return fields != null && fields.contains(value);
    }
}

