/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.EstablishDecoder;
import b3.entrypoint.fixp.sbe.FinishedReceivingDecoder;
import b3.entrypoint.fixp.sbe.FinishedSendingDecoder;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.NegotiateDecoder;
import b3.entrypoint.fixp.sbe.RetransmitRequestDecoder;
import b3.entrypoint.fixp.sbe.SequenceDecoder;
import b3.entrypoint.fixp.sbe.TerminateDecoder;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointContext;
import uk.co.real_logic.artio.binary_entrypoint.InternalBinaryEntryPointConnection;
import uk.co.real_logic.artio.fixp.AbstractFixPParser;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;

public class BinaryEntryPointParser
extends AbstractFixPParser {
    private final MessageHeaderDecoder header = new MessageHeaderDecoder();
    private final NegotiateDecoder negotiate = new NegotiateDecoder();
    private final EstablishDecoder establish = new EstablishDecoder();
    private final TerminateDecoder terminate = new TerminateDecoder();
    private final SequenceDecoder sequence = new SequenceDecoder();
    private final FinishedSendingDecoder finishedSending = new FinishedSendingDecoder();
    private final FinishedReceivingDecoder finishedReceiving = new FinishedReceivingDecoder();
    private final RetransmitRequestDecoder retransmitRequest = new RetransmitRequestDecoder();
    private final Consumer<StringBuilder> negotiateAppendTo = this.negotiate::appendTo;
    private final Consumer<StringBuilder> establishAppendTo = this.establish::appendTo;
    private final Consumer<StringBuilder> terminateAppendTo = this.terminate::appendTo;
    private final Consumer<StringBuilder> sequenceAppendTo = this.sequence::appendTo;
    private final Consumer<StringBuilder> finishedSendingAppendTo = this.finishedSending::appendTo;
    private final Consumer<StringBuilder> finishedReceivingAppendTo = this.finishedReceiving::appendTo;
    private final Consumer<StringBuilder> retransmitRequestAppendTo = this.retransmitRequest::appendTo;
    private final InternalBinaryEntryPointConnection handler;

    public BinaryEntryPointParser(InternalBinaryEntryPointConnection handler) {
        this.handler = handler;
    }

    @Override
    public int templateId(DirectBuffer buffer, int offset) {
        this.header.wrap(buffer, offset);
        return this.header.templateId();
    }

    @Override
    public int blockLength(DirectBuffer buffer, int offset) {
        this.header.wrap(buffer, offset);
        return this.header.blockLength();
    }

    @Override
    public int version(DirectBuffer buffer, int offset) {
        this.header.wrap(buffer, offset);
        return this.header.version();
    }

    @Override
    public long onMessage(DirectBuffer buffer, int start) {
        int offset = start + 4;
        this.header.wrap(buffer, offset);
        int templateId = this.header.templateId();
        int blockLength = this.header.blockLength();
        int version = this.header.version();
        offset += 8;
        switch (templateId) {
            case 1: {
                return this.onNegotiate(buffer, offset, blockLength, version);
            }
            case 4: {
                return this.onEstablish(buffer, offset, blockLength, version);
            }
            case 7: {
                return this.onTerminate(buffer, offset, blockLength, version);
            }
            case 9: {
                return this.onSequence(buffer, offset, blockLength, version);
            }
            case 10: {
                return this.onFinishedSending(buffer, offset, blockLength, version);
            }
            case 11: {
                return this.onFinishedReceiving(buffer, offset, blockLength, version);
            }
            case 12: {
                return this.onRetransmitRequest(buffer, offset, blockLength, version);
            }
        }
        int sofhMessageSize = SimpleOpenFramingHeader.readSofhMessageSize(buffer, start);
        return this.handler.onMessage(buffer, offset, templateId, blockLength, version, sofhMessageSize);
    }

    private long onRetransmitRequest(DirectBuffer buffer, int offset, int blockLength, int version) {
        RetransmitRequestDecoder retransmitRequest = this.retransmitRequest;
        retransmitRequest.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "> ", this.retransmitRequestAppendTo);
        return this.handler.onRetransmitRequest(retransmitRequest.sessionID(), retransmitRequest.timestamp().time(), retransmitRequest.fromSeqNo(), retransmitRequest.count());
    }

    private long onFinishedSending(DirectBuffer buffer, int offset, int blockLength, int version) {
        FinishedSendingDecoder finishedSending = this.finishedSending;
        finishedSending.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "> ", this.finishedSendingAppendTo);
        return this.handler.onFinishedSending(finishedSending.sessionID(), finishedSending.sessionVerID(), finishedSending.lastSeqNo());
    }

    private long onFinishedReceiving(DirectBuffer buffer, int offset, int blockLength, int version) {
        FinishedReceivingDecoder finishedReceiving = this.finishedReceiving;
        finishedReceiving.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "> ", this.finishedReceivingAppendTo);
        return this.handler.onFinishedReceiving(finishedReceiving.sessionID(), finishedReceiving.sessionVerID());
    }

    private long onSequence(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.sequence.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "> ", this.sequenceAppendTo);
        return this.handler.onSequence(this.sequence.nextSeqNo());
    }

    private long onTerminate(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.terminate.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "> ", this.terminateAppendTo);
        return this.handler.onTerminate(this.terminate.sessionID(), this.terminate.sessionVerID(), this.terminate.terminationCode());
    }

    private long onEstablish(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.establish.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "> ", this.establishAppendTo);
        return this.handler.onEstablish(this.establish.sessionID(), this.establish.sessionVerID(), this.establish.timestamp().time(), this.establish.keepAliveInterval().time(), this.establish.nextSeqNo(), this.establish.cancelOnDisconnectType(), this.establish.codTimeoutWindow().time());
    }

    private long onNegotiate(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.negotiate.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "> ", this.negotiateAppendTo);
        return this.handler.onNegotiate(this.negotiate.sessionID(), this.negotiate.sessionVerID(), this.negotiate.timestamp().time(), this.negotiate.enteringFirm(), this.negotiate.onbehalfFirm(), this.negotiate.senderLocation());
    }

    @Override
    public BinaryEntryPointContext lookupContext(DirectBuffer messageBuffer, int messageOffset, int messageLength) {
        int offset = messageOffset + 4;
        this.header.wrap(messageBuffer, offset);
        int templateId = this.header.templateId();
        int blockLength = this.header.blockLength();
        int version = this.header.version();
        offset += 8;
        switch (templateId) {
            case 1: {
                this.negotiate.wrap(messageBuffer, offset, blockLength, version);
                return new BinaryEntryPointContext(this.negotiate.sessionID(), this.negotiate.sessionVerID(), this.negotiate.timestamp().time(), this.negotiate.enteringFirm(), true);
            }
            case 4: {
                this.establish.wrap(messageBuffer, offset, blockLength, version);
                return new BinaryEntryPointContext(this.establish.sessionID(), this.establish.sessionVerID(), this.establish.timestamp().time(), NegotiateDecoder.enteringFirmNullValue(), false);
            }
        }
        throw new IllegalArgumentException("Template id: " + templateId + " isn't a negotiate or establish");
    }

    @Override
    public long sessionId(DirectBuffer buffer, int start) {
        int offset = start + 4;
        this.header.wrap(buffer, offset);
        int templateId = this.header.templateId();
        int blockLength = this.header.blockLength();
        int version = this.header.version();
        offset += 8;
        switch (templateId) {
            case 1: {
                this.negotiate.wrap(buffer, offset, blockLength, version);
                return this.negotiate.sessionID();
            }
            case 4: {
                this.establish.wrap(buffer, offset, blockLength, version);
                return this.establish.sessionID();
            }
        }
        throw new IllegalArgumentException("Template id: " + templateId + " isn't a negotiate or establish");
    }

    @Override
    public int retransmissionTemplateId() {
        return 13;
    }
}

