/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import io.aeron.Aeron;
import io.aeron.archive.client.AeronArchive;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.CompositeAgent;
import org.agrona.concurrent.SystemEpochClock;
import uk.co.real_logic.artio.CloseChecker;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.MonitoringAgentFactory;
import uk.co.real_logic.artio.MonitoringFile;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.timing.HistogramLogAgent;
import uk.co.real_logic.artio.timing.Timer;

public abstract class GatewayProcess
implements AutoCloseable {
    public static final long NO_CORRELATION_ID = 0L;
    public static final long NO_CONNECTION_ID = -1L;
    protected CommonConfiguration configuration;
    protected MonitoringFile monitoringFile;
    protected FixCounters fixCounters;
    protected ErrorHandler errorHandler;
    protected Aeron aeron;
    protected Agent monitoringAgent;

    protected void init(CommonConfiguration configuration) {
        this.configuration = configuration;
        this.initMonitoring(configuration);
        this.initAeron(configuration);
    }

    protected abstract boolean shouldRethrowExceptionInErrorHandler();

    protected void initMonitoring(CommonConfiguration configuration) {
        this.monitoringFile = new MonitoringFile(true, configuration);
        this.errorHandler = configuration.errorHandlerFactory().make(this.monitoringFile.errorBuffer());
    }

    public Agent conductorAgent() {
        AgentInvoker invoker = this.aeron.conductorAgentInvoker();
        if (invoker == null) {
            return null;
        }
        return invoker.agent();
    }

    protected void initAeron(CommonConfiguration configuration) {
        Aeron.Context context = this.configureAeronContext(configuration);
        this.aeron = Aeron.connect(context);
        CloseChecker.onOpen(context.aeronDirectoryName(), this.aeron);
        this.fixCounters = new FixCounters(this.aeron, this instanceof FixEngine);
    }

    protected Aeron.Context configureAeronContext(CommonConfiguration configuration) {
        Aeron.Context ctx = configuration.aeronContext();
        ctx.errorHandler(throwable -> {
            if (this.shouldRethrowExceptionInErrorHandler()) {
                LangUtil.rethrowUnchecked(throwable);
            }
            if (!(throwable instanceof ClosedByInterruptException)) {
                this.errorHandler.onError(throwable);
            }
        });
        return ctx;
    }

    protected void initMonitoringAgent(List<Timer> timers, CommonConfiguration configuration, AeronArchive aeronArchive, Agent agent) {
        MonitoringAgentFactory monitoringAgentFactory;
        ArrayList<Agent> agents = new ArrayList<Agent>();
        if (CommonConfiguration.TIME_MESSAGES) {
            agents.add(new HistogramLogAgent(timers, configuration.histogramLoggingFile(), configuration.histogramPollPeriodInMs(), this.errorHandler, new SystemEpochClock(), configuration.histogramHandler(), configuration.agentNamePrefix()));
        }
        if ((monitoringAgentFactory = configuration.monitoringAgentFactory()) != null) {
            agents.add(monitoringAgentFactory.make(this.monitoringFile.errorBuffer(), configuration.agentNamePrefix(), aeronArchive));
        }
        if (agent != null) {
            agents.add(agent);
        }
        if (!agents.isEmpty()) {
            this.monitoringAgent = new CompositeAgent(agents);
        }
    }

    @Override
    public void close() {
        Exceptions.closeAll(this.fixCounters, () -> {
            this.aeron.close();
            CloseChecker.onClose(this.configuration.aeronContext().aeronDirectoryName(), this.aeron);
        }, this.monitoringFile);
    }
}

