/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import java.util.HashMap;
import java.util.Map;

public final class CloseChecker {
    private static final boolean CLOSE_CHECKER_ENABLED = Boolean.getBoolean("fix.core.close_checker");
    private static final Map<String, Resource> RESOURCES = new HashMap<String, Resource>();

    public static synchronized void onOpen(String resourceId, Object owner) {
        block3: {
            if (CLOSE_CHECKER_ENABLED) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Resource resource = RESOURCES.computeIfAbsent(resourceId, key -> new Resource());
                    Exception oldException = resource.currentlyOpen.put(owner, e);
                    if (oldException == null) break block3;
                    Error error = CloseChecker.error(resourceId, owner);
                    error.addSuppressed(oldException);
                    throw error;
                }
            }
        }
    }

    public static synchronized void onClose(String resourceId, Object owner) {
        Resource resource;
        if (CLOSE_CHECKER_ENABLED && (resource = RESOURCES.get(resourceId)) != null) {
            resource.currentlyOpen.remove(owner);
        }
    }

    public static synchronized void validateAll() {
        if (CLOSE_CHECKER_ENABLED) {
            RESOURCES.keySet().forEach(CloseChecker::validate);
        }
    }

    public static synchronized void validate(String resourceId) {
        Resource resource;
        if (CLOSE_CHECKER_ENABLED && (resource = RESOURCES.get(resourceId)) != null && !resource.isEmpty()) {
            Error error = CloseChecker.error(resourceId, resource.currentlyOpen.keySet());
            resource.currentlyOpen.values().forEach(error::addSuppressed);
            throw error;
        }
    }

    private static Error error(String resourceId, Object owned) {
        return new Error(String.format("Resource [%s] open by %s [%s]", resourceId, owned, owned.getClass()));
    }

    private static final class Resource {
        final Map<Object, Exception> currentlyOpen = new HashMap<Object, Exception>();

        private Resource() {
        }

        private boolean isEmpty() {
            return this.currentlyOpen.size() <= 0;
        }
    }
}

