/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import org.agrona.DirectBuffer;
import org.agrona.collections.Long2LongHashMap;
import uk.co.real_logic.artio.ValidationError;
import uk.co.real_logic.artio.dictionary.LongDictionary;
import uk.co.real_logic.artio.fields.AsciiFieldFlyweight;
import uk.co.real_logic.artio.otf.MessageControl;
import uk.co.real_logic.artio.otf.OtfMessageAcceptor;
import uk.co.real_logic.artio.otf.OtfParser;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MessageTypeEncoding;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class BusinessRejectRefIdExtractor
implements OtfMessageAcceptor {
    private static final MutableAsciiBuffer NO_RESULT = new MutableAsciiBuffer(new byte[0]);
    private static final Long2LongHashMap PACKED_MESSAGE_TYPE_TO_REF_ID_TAG = new Long2LongHashMap(Long.MIN_VALUE);
    private final OtfParser parser = new OtfParser(this, new LongDictionary());
    private AsciiBuffer buffer;
    private int offset;
    private int length;
    private int sequenceNumber;
    private int searchTag;

    private static void putReferenceTag(String messageType, int searchTag) {
        PACKED_MESSAGE_TYPE_TO_REF_ID_TAG.put(MessageTypeEncoding.packMessageType(messageType), searchTag);
    }

    public void search(long msgType, DirectBuffer msgBuffer, int msgOffset, int msgLength) {
        this.buffer = NO_RESULT;
        this.offset = 0;
        this.length = 0;
        this.sequenceNumber = 0;
        this.searchTag = (int)PACKED_MESSAGE_TYPE_TO_REF_ID_TAG.get(msgType);
        this.parser.onMessage(msgBuffer, msgOffset, msgLength);
    }

    @Override
    public MessageControl onNext() {
        return MessageControl.CONTINUE;
    }

    @Override
    public MessageControl onComplete() {
        return MessageControl.CONTINUE;
    }

    @Override
    public MessageControl onField(int tag, AsciiBuffer buffer, int offset, int length) {
        if (tag == 34) {
            this.sequenceNumber = buffer.getInt(offset, offset + length);
        }
        if (tag == this.searchTag) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }
        return MessageControl.CONTINUE;
    }

    @Override
    public MessageControl onGroupHeader(int tag, int numInGroup) {
        return MessageControl.CONTINUE;
    }

    @Override
    public MessageControl onGroupBegin(int tag, int numInGroup, int index) {
        return MessageControl.CONTINUE;
    }

    @Override
    public MessageControl onGroupEnd(int tag, int numInGroup, int index) {
        return MessageControl.CONTINUE;
    }

    @Override
    public boolean onError(ValidationError error, long messageType, int tagNumber, AsciiFieldFlyweight value) {
        return false;
    }

    public AsciiBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public int sequenceNumber() {
        return this.sequenceNumber;
    }

    static {
        BusinessRejectRefIdExtractor.putReferenceTag("6", 23);
        BusinessRejectRefIdExtractor.putReferenceTag("7", 2);
        BusinessRejectRefIdExtractor.putReferenceTag("B", 148);
        BusinessRejectRefIdExtractor.putReferenceTag("C", 164);
        BusinessRejectRefIdExtractor.putReferenceTag("9", 11);
        BusinessRejectRefIdExtractor.putReferenceTag("P", 70);
        BusinessRejectRefIdExtractor.putReferenceTag("AT", 70);
        BusinessRejectRefIdExtractor.putReferenceTag("N", 66);
        BusinessRejectRefIdExtractor.putReferenceTag("T", 162);
        BusinessRejectRefIdExtractor.putReferenceTag("W", 262);
        BusinessRejectRefIdExtractor.putReferenceTag("X", 262);
        BusinessRejectRefIdExtractor.putReferenceTag("Y", 262);
        BusinessRejectRefIdExtractor.putReferenceTag("b", 117);
        BusinessRejectRefIdExtractor.putReferenceTag("d", 322);
        BusinessRejectRefIdExtractor.putReferenceTag("f", 324);
        BusinessRejectRefIdExtractor.putReferenceTag("h", 335);
        BusinessRejectRefIdExtractor.putReferenceTag("r", 37);
        BusinessRejectRefIdExtractor.putReferenceTag("w", 322);
        BusinessRejectRefIdExtractor.putReferenceTag("y", 322);
        BusinessRejectRefIdExtractor.putReferenceTag("AA", 322);
        BusinessRejectRefIdExtractor.putReferenceTag("AG", 131);
        BusinessRejectRefIdExtractor.putReferenceTag("AH", 644);
        BusinessRejectRefIdExtractor.putReferenceTag("AI", 117);
        BusinessRejectRefIdExtractor.putReferenceTag("p", 513);
        BusinessRejectRefIdExtractor.putReferenceTag("AE", 571);
        BusinessRejectRefIdExtractor.putReferenceTag("AU", 664);
        BusinessRejectRefIdExtractor.putReferenceTag("l", 390);
        BusinessRejectRefIdExtractor.putReferenceTag("m", 66);
        BusinessRejectRefIdExtractor.putReferenceTag("T", 777);
        BusinessRejectRefIdExtractor.putReferenceTag("AQ", 568);
        BusinessRejectRefIdExtractor.putReferenceTag("AR", 571);
        BusinessRejectRefIdExtractor.putReferenceTag("AM", 721);
        BusinessRejectRefIdExtractor.putReferenceTag("AO", 721);
        BusinessRejectRefIdExtractor.putReferenceTag("AP", 721);
        BusinessRejectRefIdExtractor.putReferenceTag("AW", 833);
        BusinessRejectRefIdExtractor.putReferenceTag("AZ", 904);
        BusinessRejectRefIdExtractor.putReferenceTag("BG", 909);
    }
}

