/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class RttMeasurementFlyweight
extends HeaderFlyweight {
    public static final short REPLY_FLAG = 128;
    public static final int HEADER_LENGTH = 40;
    private static final int SESSION_ID_FIELD_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int ECHO_TIMESTAMP_FIELD_OFFSET = 16;
    private static final int RECEPTION_DELTA_FIELD_OFFSET = 24;
    private static final int RECEIVER_ID_FIELD_OFFSET = 32;

    public RttMeasurementFlyweight() {
    }

    public RttMeasurementFlyweight(ByteBuffer buffer) {
        super(buffer);
    }

    public RttMeasurementFlyweight(UnsafeBuffer buffer) {
        super(buffer);
    }

    public int sessionId() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight sessionId(int sessionId) {
        this.putInt(8, sessionId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight streamId(int streamId) {
        this.putInt(12, streamId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long echoTimestampNs() {
        return this.getLong(16, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight echoTimestampNs(long timestampNs) {
        this.putLong(16, timestampNs, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long receptionDelta() {
        return this.getLong(24, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight receptionDelta(long deltaNs) {
        this.putLong(24, deltaNs, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long receiverId() {
        return this.getLong(32, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight receiverId(long id) {
        this.putLong(32, id, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public String toString() {
        return "RTTM{frame-length=" + this.frameLength() + " version=" + this.version() + " flags=" + String.valueOf(RttMeasurementFlyweight.flagsToChars(this.flags())) + " type=" + this.headerType() + " session-id=" + this.sessionId() + " stream-id=" + this.streamId() + " echo-timestamp=" + this.echoTimestampNs() + " reception-delta=" + this.receptionDelta() + " receiver-id=" + this.receiverId() + "}";
    }
}

