/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ChannelUri;
import io.aeron.driver.DefaultNameResolver;
import io.aeron.driver.NameResolver;
import io.aeron.driver.exceptions.InvalidChannelException;
import io.aeron.driver.media.InterfaceSearchAddress;
import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.media.SocketAddressParser;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.agrona.BitUtil;
import org.agrona.SystemUtil;

public final class UdpChannel {
    public static final int RESERVED_VALUE_MESSAGE_OFFSET = -8;
    private static final AtomicInteger UNIQUE_CANONICAL_FORM_VALUE = new AtomicInteger();
    private static final InetSocketAddress ANY_IPV4 = new InetSocketAddress("0.0.0.0", 0);
    private static final InetSocketAddress ANY_IPV6 = new InetSocketAddress("::", 0);
    private final boolean isManualControlMode;
    private final boolean isDynamicControlMode;
    private final boolean hasExplicitControl;
    private final boolean hasExplicitEndpoint;
    private final boolean isMulticast;
    private final boolean hasMulticastTtl;
    private final boolean hasTag;
    private final int multicastTtl;
    private final int socketRcvbufLength;
    private final int socketSndbufLength;
    private final int receiverWindowLength;
    private final long tag;
    private final InetSocketAddress remoteData;
    private final InetSocketAddress localData;
    private final InetSocketAddress remoteControl;
    private final InetSocketAddress localControl;
    private final String uriStr;
    private final String canonicalForm;
    private final NetworkInterface localInterface;
    private final ProtocolFamily protocolFamily;
    private final ChannelUri channelUri;
    private final int channelReceiveTimestampOffset;
    private final int channelSendTimestampOffset;

    private UdpChannel(Context context) {
        this.isManualControlMode = context.isManualControlMode;
        this.isDynamicControlMode = context.isDynamicControlMode;
        this.hasExplicitEndpoint = context.hasExplicitEndpoint;
        this.hasExplicitControl = context.hasExplicitControl;
        this.isMulticast = context.isMulticast;
        this.hasTag = context.hasTagId;
        this.tag = context.tagId;
        this.hasMulticastTtl = context.hasMulticastTtl;
        this.multicastTtl = context.multicastTtl;
        this.remoteData = context.remoteData;
        this.localData = context.localData;
        this.remoteControl = context.remoteControl;
        this.localControl = context.localControl;
        this.uriStr = context.uriStr;
        this.canonicalForm = context.canonicalForm;
        this.localInterface = context.localInterface;
        this.protocolFamily = context.protocolFamily;
        this.channelUri = context.channelUri;
        this.socketRcvbufLength = context.socketRcvbufLength;
        this.socketSndbufLength = context.socketSndbufLength;
        this.receiverWindowLength = context.receiverWindowLength;
        this.channelReceiveTimestampOffset = context.channelReceiveTimestampOffset;
        this.channelSendTimestampOffset = context.channelSendTimestampOffset;
    }

    public static UdpChannel parse(String channelUriString) {
        return UdpChannel.parse(channelUriString, DefaultNameResolver.INSTANCE, false);
    }

    public static UdpChannel parse(String channelUriString, NameResolver nameResolver) {
        return UdpChannel.parse(channelUriString, nameResolver, false);
    }

    public static UdpChannel parse(String channelUriString, NameResolver nameResolver, boolean isDestination) {
        try {
            boolean hasNoDistinguishingCharacteristic;
            ChannelUri channelUri = ChannelUri.parse(channelUriString);
            UdpChannel.validateConfiguration(channelUri);
            InetSocketAddress endpointAddress = UdpChannel.getEndpointAddress(channelUri, nameResolver);
            InetSocketAddress controlAddress = UdpChannel.getExplicitControlAddress(channelUri, nameResolver);
            String tagIdStr = channelUri.channelTag();
            String controlMode = channelUri.get("control-mode");
            boolean isManualControlMode = "manual".equals(controlMode);
            boolean isDynamicControlMode = "dynamic".equals(controlMode);
            int socketRcvbufLength = UdpChannel.parseBufferLength(channelUri, "so-rcvbuf");
            int socketSndbufLength = UdpChannel.parseBufferLength(channelUri, "so-sndbuf");
            int receiverWindowLength = UdpChannel.parseBufferLength(channelUri, "rcv-wnd");
            boolean requiresAdditionalSuffix = !isDestination && (null == endpointAddress && null == controlAddress || null != endpointAddress && endpointAddress.getPort() == 0 || null != controlAddress && controlAddress.getPort() == 0);
            boolean bl = hasNoDistinguishingCharacteristic = null == endpointAddress && null == controlAddress && null == tagIdStr;
            if (isDynamicControlMode && null == controlAddress) {
                throw new IllegalArgumentException("explicit control expected with dynamic control mode: " + channelUriString);
            }
            if (hasNoDistinguishingCharacteristic && !isManualControlMode) {
                throw new IllegalArgumentException("URIs for UDP must specify an endpoint, control, tags, or control-mode=manual: " + channelUriString);
            }
            if (null != endpointAddress && endpointAddress.isUnresolved()) {
                throw new UnknownHostException("could not resolve endpoint address: " + endpointAddress);
            }
            if (null != controlAddress && controlAddress.isUnresolved()) {
                throw new UnknownHostException("could not resolve control address: " + controlAddress);
            }
            boolean hasExplicitEndpoint = true;
            if (null == endpointAddress) {
                hasExplicitEndpoint = false;
                endpointAddress = null != controlAddress && controlAddress.getAddress() instanceof Inet6Address ? ANY_IPV6 : ANY_IPV4;
            }
            Context context = new Context().uriStr(channelUriString).channelUri(channelUri).isManualControlMode(isManualControlMode).isDynamicControlMode(isDynamicControlMode).hasExplicitEndpoint(hasExplicitEndpoint).hasNoDistinguishingCharacteristic(hasNoDistinguishingCharacteristic).socketRcvbufLength(socketRcvbufLength).socketSndbufLength(socketSndbufLength).receiverWindowLength(receiverWindowLength);
            if (null != tagIdStr) {
                context.hasTagId(true).tagId(Long.parseLong(tagIdStr));
            }
            if (endpointAddress.getAddress().isMulticastAddress()) {
                InterfaceSearchAddress searchAddress = UdpChannel.getInterfaceSearchAddress(channelUri);
                NetworkInterface localInterface = UdpChannel.findInterface(searchAddress);
                InetSocketAddress resolvedAddress = UdpChannel.resolveToAddressOfInterface(localInterface, searchAddress);
                context.isMulticast(true).localControlAddress(resolvedAddress).remoteControlAddress(UdpChannel.getMulticastControlAddress(endpointAddress)).localDataAddress(resolvedAddress).remoteDataAddress(endpointAddress).localInterface(localInterface).protocolFamily(NetworkUtil.getProtocolFamily(endpointAddress.getAddress())).canonicalForm(UdpChannel.canonicalise(null, resolvedAddress, null, endpointAddress));
                String ttlValue = channelUri.get("ttl");
                if (null != ttlValue) {
                    context.hasMulticastTtl(true).multicastTtl(Integer.parseInt(ttlValue));
                }
            } else if (null != controlAddress) {
                String controlVal = channelUri.get("control");
                String endpointVal = channelUri.get("endpoint");
                String suffix = "";
                if (requiresAdditionalSuffix) {
                    suffix = null != tagIdStr ? "#" + tagIdStr : "-" + UNIQUE_CANONICAL_FORM_VALUE.getAndAdd(1);
                }
                String canonicalForm = UdpChannel.canonicalise(controlVal, controlAddress, endpointVal, endpointAddress) + suffix;
                context.hasExplicitControl(true).remoteControlAddress(endpointAddress).remoteDataAddress(endpointAddress).localControlAddress(controlAddress).localDataAddress(controlAddress).protocolFamily(NetworkUtil.getProtocolFamily(endpointAddress.getAddress())).canonicalForm(canonicalForm);
            } else {
                InterfaceSearchAddress searchAddress = UdpChannel.getInterfaceSearchAddress(channelUri);
                InetSocketAddress localAddress = searchAddress.getInetAddress().isAnyLocalAddress() ? searchAddress.getAddress() : UdpChannel.resolveToAddressOfInterface(UdpChannel.findInterface(searchAddress), searchAddress);
                String endpointVal = channelUri.get("endpoint");
                String suffix = "";
                if (requiresAdditionalSuffix) {
                    suffix = null != tagIdStr ? "#" + tagIdStr : "-" + UNIQUE_CANONICAL_FORM_VALUE.getAndAdd(1);
                }
                context.remoteControlAddress(endpointAddress).remoteDataAddress(endpointAddress).localControlAddress(localAddress).localDataAddress(localAddress).protocolFamily(NetworkUtil.getProtocolFamily(endpointAddress.getAddress())).canonicalForm(UdpChannel.canonicalise(null, localAddress, endpointVal, endpointAddress) + suffix);
            }
            context.channelReceiveTimestampOffset(UdpChannel.parseTimestampOffset(channelUri, "channel-rcv-ts-offset"));
            context.channelSendTimestampOffset(UdpChannel.parseTimestampOffset(channelUri, "channel-snd-ts-offset"));
            return new UdpChannel(context);
        }
        catch (Exception ex) {
            throw new InvalidChannelException(ex);
        }
    }

    private static int parseTimestampOffset(ChannelUri channelUri, String timestampOffsetParamName) {
        String offsetStr = channelUri.get(timestampOffsetParamName);
        if (null == offsetStr) {
            return -1;
        }
        if ("reserved".equals(offsetStr)) {
            return -8;
        }
        return Integer.parseInt(offsetStr);
    }

    public static int parseBufferLength(ChannelUri channelUri, String paramName) {
        int socketBufferLength = 0;
        String paramValue = channelUri.get(paramName);
        if (null != paramValue) {
            long size = SystemUtil.parseSize(paramName, paramValue);
            if (size < 0L || size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Invalid " + paramName + " length: " + size);
            }
            socketBufferLength = (int)size;
        }
        return socketBufferLength;
    }

    public static String canonicalise(String localParamValue, InetSocketAddress localData, String remoteParamValue, InetSocketAddress remoteData) {
        StringBuilder builder = new StringBuilder(48);
        builder.append("UDP-");
        if (null == localParamValue) {
            builder.append(localData.getHostString()).append(':').append(localData.getPort());
        } else {
            builder.append(localParamValue);
        }
        builder.append('-');
        if (null == remoteParamValue) {
            builder.append(remoteData.getHostString()).append(':').append(remoteData.getPort());
        } else {
            builder.append(remoteParamValue);
        }
        return builder.toString();
    }

    public InetSocketAddress remoteData() {
        return this.remoteData;
    }

    public InetSocketAddress localData() {
        return this.localData;
    }

    public InetSocketAddress remoteControl() {
        return this.remoteControl;
    }

    public InetSocketAddress localControl() {
        return this.localControl;
    }

    public ChannelUri channelUri() {
        return this.channelUri;
    }

    public boolean hasMulticastTtl() {
        return this.hasMulticastTtl;
    }

    public int multicastTtl() {
        return this.multicastTtl;
    }

    public String canonicalForm() {
        return this.canonicalForm;
    }

    public String toString() {
        return this.canonicalForm;
    }

    public boolean isMulticast() {
        return this.isMulticast;
    }

    public NetworkInterface localInterface() {
        return this.localInterface;
    }

    public String originalUriString() {
        return this.uriStr;
    }

    public ProtocolFamily protocolFamily() {
        return this.protocolFamily;
    }

    public long tag() {
        return this.tag;
    }

    public boolean isManualControlMode() {
        return this.isManualControlMode;
    }

    public boolean isDynamicControlMode() {
        return this.isDynamicControlMode;
    }

    public boolean hasExplicitEndpoint() {
        return this.hasExplicitEndpoint;
    }

    public boolean hasExplicitControl() {
        return this.hasExplicitControl;
    }

    public boolean hasTag() {
        return this.hasTag;
    }

    public boolean isMultiDestination() {
        return this.isDynamicControlMode || this.isManualControlMode || this.hasExplicitControl;
    }

    public int socketRcvbufLength() {
        return this.socketRcvbufLength;
    }

    public int socketRcvbufLengthOrDefault(int defaultValue) {
        return 0 != this.socketRcvbufLength ? this.socketRcvbufLength : defaultValue;
    }

    public int socketSndbufLength() {
        return this.socketSndbufLength;
    }

    public int socketSndbufLengthOrDefault(int defaultValue) {
        return 0 != this.socketSndbufLength ? this.socketSndbufLength : defaultValue;
    }

    public int receiverWindowLength() {
        return this.receiverWindowLength;
    }

    public int receiverWindowLengthOrDefault(int defaultValue) {
        return 0 != this.receiverWindowLength() ? this.receiverWindowLength() : defaultValue;
    }

    public boolean matchesTag(UdpChannel udpChannel) {
        if (!this.hasTag || !udpChannel.hasTag() || this.tag != udpChannel.tag()) {
            return false;
        }
        if (udpChannel.remoteData().getAddress().isAnyLocalAddress() && udpChannel.remoteData().getPort() == 0 && udpChannel.localData().getAddress().isAnyLocalAddress() && udpChannel.localData().getPort() == 0) {
            return true;
        }
        throw new IllegalArgumentException("matching tag=" + this.tag + " has explicit endpoint or control - " + this.uriStr + " <> " + udpChannel.uriStr);
    }

    public String description() {
        return "localData: " + NetworkUtil.formatAddressAndPort(this.localData.getAddress(), this.localData.getPort()) + ", remoteData: " + NetworkUtil.formatAddressAndPort(this.remoteData.getAddress(), this.remoteData.getPort()) + ", ttl: " + this.multicastTtl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UdpChannel that = (UdpChannel)o;
        return Objects.equals(this.canonicalForm, that.canonicalForm);
    }

    public int hashCode() {
        return this.canonicalForm != null ? this.canonicalForm.hashCode() : 0;
    }

    public static InetSocketAddress destinationAddress(ChannelUri uri, NameResolver nameResolver) {
        try {
            UdpChannel.validateConfiguration(uri);
            String endpointValue = uri.get("endpoint");
            return SocketAddressParser.parse(endpointValue, "endpoint", false, nameResolver);
        }
        catch (Exception ex) {
            throw new InvalidChannelException(ex);
        }
    }

    public static InetSocketAddress resolve(String endpoint, String uriParamName, boolean isReResolution, NameResolver nameResolver) {
        return SocketAddressParser.parse(endpoint, uriParamName, isReResolution, nameResolver);
    }

    public int channelReceiveTimestampOffset() {
        return this.channelReceiveTimestampOffset;
    }

    public boolean isChannelReceiveTimestampEnabled() {
        return -8 == this.channelReceiveTimestampOffset || 0 <= this.channelReceiveTimestampOffset;
    }

    public boolean isChannelSendTimestampEnabled() {
        return -8 == this.channelSendTimestampOffset || 0 <= this.channelSendTimestampOffset;
    }

    public int channelSendTimestampOffset() {
        return this.channelSendTimestampOffset;
    }

    private static InetSocketAddress getMulticastControlAddress(InetSocketAddress endpointAddress) throws UnknownHostException {
        byte[] addressAsBytes = endpointAddress.getAddress().getAddress();
        UdpChannel.validateDataAddress(addressAsBytes);
        int n = addressAsBytes.length - 1;
        addressAsBytes[n] = (byte)(addressAsBytes[n] + 1);
        return new InetSocketAddress(InetAddress.getByAddress(addressAsBytes), endpointAddress.getPort());
    }

    private static InterfaceSearchAddress getInterfaceSearchAddress(ChannelUri uri) throws UnknownHostException {
        String interfaceValue = uri.get("interface");
        if (null != interfaceValue) {
            return InterfaceSearchAddress.parse(interfaceValue);
        }
        return InterfaceSearchAddress.wildcard();
    }

    private static InetSocketAddress getEndpointAddress(ChannelUri uri, NameResolver nameResolver) throws UnknownHostException {
        InetSocketAddress address = null;
        String endpointValue = uri.get("endpoint");
        if (null != endpointValue && (address = SocketAddressParser.parse(endpointValue, "endpoint", false, nameResolver)).isUnresolved()) {
            throw new UnknownHostException("unresolved - endpoint=" + endpointValue + ", name-resolver=" + nameResolver.getClass().getName());
        }
        return address;
    }

    private static InetSocketAddress getExplicitControlAddress(ChannelUri uri, NameResolver nameResolver) throws UnknownHostException {
        InetSocketAddress address = null;
        String controlValue = uri.get("control");
        if (null != controlValue && (address = SocketAddressParser.parse(controlValue, "control", false, nameResolver)).isUnresolved()) {
            throw new UnknownHostException("unresolved - control=" + controlValue + ", name-resolver=" + nameResolver.getClass().getName());
        }
        return address;
    }

    private static void validateDataAddress(byte[] addressAsBytes) {
        if (BitUtil.isEven(addressAsBytes[addressAsBytes.length - 1])) {
            throw new IllegalArgumentException("multicast data address must be odd");
        }
    }

    private static void validateConfiguration(ChannelUri uri) {
        UdpChannel.validateMedia(uri);
    }

    private static void validateMedia(ChannelUri uri) {
        if (!uri.isUdp()) {
            throw new IllegalArgumentException("UdpChannel only supports UDP media: " + uri);
        }
    }

    private static InetSocketAddress resolveToAddressOfInterface(NetworkInterface localInterface, InterfaceSearchAddress searchAddress) {
        InetAddress interfaceAddress = NetworkUtil.findAddressOnInterface(localInterface, searchAddress.getInetAddress(), searchAddress.getSubnetPrefix());
        if (null == interfaceAddress) {
            throw new IllegalStateException();
        }
        return new InetSocketAddress(interfaceAddress, searchAddress.getPort());
    }

    private static NetworkInterface findInterface(InterfaceSearchAddress searchAddress) throws SocketException {
        NetworkInterface[] filteredInterfaces;
        for (NetworkInterface networkInterface : filteredInterfaces = NetworkUtil.filterBySubnet(searchAddress.getInetAddress(), searchAddress.getSubnetPrefix())) {
            if (!networkInterface.supportsMulticast() && !networkInterface.isLoopback()) continue;
            return networkInterface;
        }
        throw new IllegalArgumentException(UdpChannel.noMatchingInterfacesError(filteredInterfaces, searchAddress));
    }

    private static String noMatchingInterfacesError(NetworkInterface[] filteredInterfaces, InterfaceSearchAddress address) throws SocketException {
        StringBuilder builder = new StringBuilder().append("Unable to find multicast interface matching criteria: ").append(address.getAddress()).append('/').append(address.getSubnetPrefix());
        if (filteredInterfaces.length > 0) {
            builder.append(System.lineSeparator()).append("  Candidates:");
            for (NetworkInterface ifc : filteredInterfaces) {
                builder.append(System.lineSeparator()).append("  - Name: ").append(ifc.getDisplayName()).append(", addresses: ").append(ifc.getInterfaceAddresses()).append(", multicast: ").append(ifc.supportsMulticast());
            }
        }
        return builder.toString();
    }

    static final class Context {
        boolean isManualControlMode = false;
        boolean isDynamicControlMode = false;
        boolean hasExplicitEndpoint = false;
        boolean hasExplicitControl = false;
        boolean isMulticast = false;
        boolean hasMulticastTtl = false;
        boolean hasTagId = false;
        boolean hasNoDistinguishingCharacteristic = false;
        int socketRcvbufLength = 0;
        int socketSndbufLength = 0;
        int receiverWindowLength = 0;
        int multicastTtl;
        long tagId;
        InetSocketAddress remoteData;
        InetSocketAddress localData;
        InetSocketAddress remoteControl;
        InetSocketAddress localControl;
        String uriStr;
        String canonicalForm;
        NetworkInterface localInterface;
        ProtocolFamily protocolFamily;
        ChannelUri channelUri;
        int channelReceiveTimestampOffset;
        int channelSendTimestampOffset;

        Context() {
        }

        Context uriStr(String uri) {
            this.uriStr = uri;
            return this;
        }

        Context remoteDataAddress(InetSocketAddress remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        Context localDataAddress(InetSocketAddress localData) {
            this.localData = localData;
            return this;
        }

        Context remoteControlAddress(InetSocketAddress remoteControl) {
            this.remoteControl = remoteControl;
            return this;
        }

        Context localControlAddress(InetSocketAddress localControl) {
            this.localControl = localControl;
            return this;
        }

        Context canonicalForm(String canonicalForm) {
            this.canonicalForm = canonicalForm;
            return this;
        }

        Context localInterface(NetworkInterface networkInterface) {
            this.localInterface = networkInterface;
            return this;
        }

        Context protocolFamily(ProtocolFamily protocolFamily) {
            this.protocolFamily = protocolFamily;
            return this;
        }

        Context hasMulticastTtl(boolean hasMulticastTtl) {
            this.hasMulticastTtl = hasMulticastTtl;
            return this;
        }

        Context multicastTtl(int multicastTtl) {
            this.multicastTtl = multicastTtl;
            return this;
        }

        Context tagId(long tagId) {
            this.tagId = tagId;
            return this;
        }

        Context channelUri(ChannelUri channelUri) {
            this.channelUri = channelUri;
            return this;
        }

        Context isManualControlMode(boolean isManualControlMode) {
            this.isManualControlMode = isManualControlMode;
            return this;
        }

        Context isDynamicControlMode(boolean isDynamicControlMode) {
            this.isDynamicControlMode = isDynamicControlMode;
            return this;
        }

        Context hasExplicitEndpoint(boolean hasExplicitEndpoint) {
            this.hasExplicitEndpoint = hasExplicitEndpoint;
            return this;
        }

        Context hasExplicitControl(boolean hasExplicitControl) {
            this.hasExplicitControl = hasExplicitControl;
            return this;
        }

        Context isMulticast(boolean isMulticast) {
            this.isMulticast = isMulticast;
            return this;
        }

        Context hasTagId(boolean hasTagId) {
            this.hasTagId = hasTagId;
            return this;
        }

        Context hasNoDistinguishingCharacteristic(boolean hasNoDistinguishingCharacteristic) {
            this.hasNoDistinguishingCharacteristic = hasNoDistinguishingCharacteristic;
            return this;
        }

        Context socketRcvbufLength(int socketRcvbufLength) {
            this.socketRcvbufLength = socketRcvbufLength;
            return this;
        }

        Context socketSndbufLength(int socketSndbufLength) {
            this.socketSndbufLength = socketSndbufLength;
            return this;
        }

        Context receiverWindowLength(int receiverWindowLength) {
            this.receiverWindowLength = receiverWindowLength;
            return this;
        }

        Context channelReceiveTimestampOffset(int timestampOffset) {
            this.channelReceiveTimestampOffset = timestampOffset;
            return this;
        }

        Context channelSendTimestampOffset(int timestampOffset) {
            this.channelSendTimestampOffset = timestampOffset;
            return this;
        }
    }
}

