/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.MediaDriver;
import io.aeron.driver.ext.DebugChannelEndpointConfiguration;
import io.aeron.driver.ext.LossGenerator;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class DebugSendChannelEndpoint
extends SendChannelEndpoint {
    private final LossGenerator dataLossGenerator;
    private final LossGenerator controlLossGenerator;
    private final UnsafeBuffer dataBuffer = new UnsafeBuffer();

    public DebugSendChannelEndpoint(UdpChannel udpChannel, AtomicCounter statusIndicator, MediaDriver.Context context) {
        this(udpChannel, statusIndicator, context, DebugChannelEndpointConfiguration.sendDataLossGeneratorSupplier(), DebugChannelEndpointConfiguration.sendControlLossGeneratorSupplier());
    }

    public DebugSendChannelEndpoint(UdpChannel udpChannel, AtomicCounter statusIndicator, MediaDriver.Context context, LossGenerator dataLossGenerator, LossGenerator controlLossGenerator) {
        super(udpChannel, statusIndicator, context);
        this.dataLossGenerator = dataLossGenerator;
        this.controlLossGenerator = controlLossGenerator;
    }

    @Override
    public int send(ByteBuffer buffer) {
        int count = buffer.remaining();
        this.dataBuffer.wrap(buffer, buffer.position(), count);
        if (!this.dataLossGenerator.shouldDropFrame(this.connectAddress, this.dataBuffer, count)) {
            count = super.send(buffer);
        }
        return count;
    }

    @Override
    public void onStatusMessage(StatusMessageFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        if (!this.controlLossGenerator.shouldDropFrame(srcAddress, msg, msg.frameLength())) {
            super.onStatusMessage(msg, buffer, length, srcAddress);
        }
    }

    @Override
    public void onNakMessage(NakFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        if (!this.controlLossGenerator.shouldDropFrame(srcAddress, msg, msg.frameLength())) {
            super.onNakMessage(msg, buffer, length, srcAddress);
        }
    }

    @Override
    public void onRttMeasurement(RttMeasurementFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        if (!this.controlLossGenerator.shouldDropFrame(srcAddress, msg, msg.frameLength())) {
            super.onRttMeasurement(msg, buffer, length, srcAddress);
        }
    }
}

