/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import java.util.concurrent.ThreadLocalRandom;

public class OptimalMulticastDelayGenerator
implements FeedbackDelayGenerator {
    private final double randMax;
    private final double baseX;
    private final double constantT;
    private final double factorT;

    public OptimalMulticastDelayGenerator(double maxBackoffT, double groupSize) {
        double lambda = Math.log(groupSize) + 1.0;
        this.randMax = lambda / maxBackoffT;
        this.baseX = lambda / (maxBackoffT * (Math.exp(lambda) - 1.0));
        this.constantT = maxBackoffT / lambda;
        this.factorT = (Math.exp(lambda) - 1.0) * (maxBackoffT / lambda);
    }

    @Override
    public long generateDelay() {
        return (long)this.generateNewOptimalDelay();
    }

    @Override
    public boolean shouldFeedbackImmediately() {
        return false;
    }

    public double generateNewOptimalDelay() {
        double x = OptimalMulticastDelayGenerator.uniformRandom(this.randMax) + this.baseX;
        return this.constantT * Math.log(x * this.factorT);
    }

    public static double uniformRandom(double max) {
        return ThreadLocalRandom.current().nextDouble() * max;
    }

    public String toString() {
        return "OptimalMulticastDelayGenerator{randMax=" + this.randMax + ", baseX=" + this.baseX + ", constantT=" + this.constantT + ", factorT=" + this.factorT + ", shouldFeedbackImmediately=" + this.shouldFeedbackImmediately() + '}';
    }
}

