/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.StatusMessageFlyweight;
import java.util.Arrays;
import org.agrona.AsciiEncoding;
import org.agrona.SystemUtil;
import org.agrona.collections.ArrayUtil;

public abstract class AbstractMinMulticastFlowControl
implements FlowControl {
    static final Receiver[] EMPTY_RECEIVERS = new Receiver[0];
    private final boolean isGroupTagAware;
    private volatile boolean hasRequiredReceivers;
    private int groupMinSize;
    private long groupTag;
    private long receiverTimeoutNs;
    private Receiver[] receivers = EMPTY_RECEIVERS;
    private String channel;

    protected AbstractMinMulticastFlowControl(boolean isGroupTagAware) {
        this.isGroupTagAware = isGroupTagAware;
    }

    @Override
    public void initialize(MediaDriver.Context context, UdpChannel udpChannel, int initialTermId, int termBufferLength) {
        this.receiverTimeoutNs = context.flowControlReceiverTimeoutNs();
        this.groupTag = this.isGroupTagAware ? context.flowControlGroupTag() : 0L;
        this.groupMinSize = context.flowControlGroupMinSize();
        this.channel = udpChannel.originalUriString();
        this.parseUriParam(udpChannel.channelUri().get("fc"));
        this.hasRequiredReceivers = this.receivers.length >= this.groupMinSize;
    }

    @Override
    public long onIdle(long timeNs, long senderLimit, long senderPosition, boolean isEos) {
        int lastIndex;
        long minLimitPosition = Long.MAX_VALUE;
        int removed = 0;
        Receiver[] receivers = this.receivers;
        for (int i = lastIndex = receivers.length - 1; i >= 0; --i) {
            Receiver receiver = receivers[i];
            if (receiver.timeOfLastStatusMessageNs + this.receiverTimeoutNs - timeNs < 0L) {
                if (i != lastIndex) {
                    receivers[i] = receivers[lastIndex--];
                }
                this.receiverRemoved(receiver.receiverId, receiver.sessionId, receiver.streamId, this.channel, receivers.length - ++removed);
                continue;
            }
            minLimitPosition = Math.min(minLimitPosition, receiver.lastPositionPlusWindow);
        }
        if (removed > 0) {
            this.hasRequiredReceivers = (receivers = AbstractMinMulticastFlowControl.truncateReceivers(receivers, removed)).length >= this.groupMinSize;
            this.receivers = receivers;
        }
        return receivers.length < this.groupMinSize || receivers.length == 0 ? senderLimit : minLimitPosition;
    }

    @Override
    public boolean hasRequiredReceivers() {
        return this.hasRequiredReceivers;
    }

    protected final long processStatusMessage(StatusMessageFlyweight flyweight, long senderLimit, int initialTermId, int positionBitsToShift, long timeNs, boolean matchesTag) {
        Receiver[] receivers;
        long position = LogBufferDescriptor.computePosition(flyweight.consumptionTermId(), flyweight.consumptionTermOffset(), positionBitsToShift, initialTermId);
        long windowLength = flyweight.receiverWindowLength();
        long receiverId = flyweight.receiverId();
        long lastPositionPlusWindow = position + windowLength;
        boolean isExisting = false;
        long minPosition = Long.MAX_VALUE;
        for (Receiver receiver : receivers = this.receivers) {
            if (matchesTag && receiverId == receiver.receiverId) {
                receiver.lastPosition = Math.max(position, receiver.lastPosition);
                receiver.lastPositionPlusWindow = lastPositionPlusWindow;
                receiver.timeOfLastStatusMessageNs = timeNs;
                isExisting = true;
            }
            minPosition = Math.min(minPosition, receiver.lastPositionPlusWindow);
        }
        if (matchesTag && !isExisting) {
            Receiver receiver = new Receiver(receiverId, flyweight.sessionId(), flyweight.streamId(), position, lastPositionPlusWindow, timeNs);
            this.hasRequiredReceivers = (receivers = ArrayUtil.add(receivers, receiver)).length >= this.groupMinSize;
            this.receivers = receivers;
            minPosition = Math.min(minPosition, lastPositionPlusWindow);
            this.receiverAdded(receiver.receiverId, receiver.sessionId, receiver.streamId, this.channel, receivers.length);
        }
        if (receivers.length < this.groupMinSize) {
            return senderLimit;
        }
        if (receivers.length == 0) {
            return Math.max(senderLimit, lastPositionPlusWindow);
        }
        return Math.max(senderLimit, minPosition);
    }

    protected final long receiverTimeoutNs() {
        return this.receiverTimeoutNs;
    }

    protected final boolean hasGroupTag() {
        return this.isGroupTagAware;
    }

    protected final long groupTag() {
        return this.groupTag;
    }

    protected final int groupMinSize() {
        return this.groupMinSize;
    }

    static Receiver[] truncateReceivers(Receiver[] receivers, int removed) {
        int length = receivers.length;
        int newLength = length - removed;
        if (0 == newLength) {
            return EMPTY_RECEIVERS;
        }
        return Arrays.copyOf(receivers, newLength);
    }

    private void parseUriParam(String fcValue) {
        if (null != fcValue) {
            for (String arg : fcValue.split(",")) {
                if (arg.startsWith("t:")) {
                    this.receiverTimeoutNs = SystemUtil.parseDuration("fc receiver timeout", arg.substring(2));
                    continue;
                }
                if (!arg.startsWith("g:")) continue;
                int groupMinSizeIndex = arg.indexOf(47);
                if (2 != groupMinSizeIndex && this.isGroupTagAware) {
                    int lengthToParse = -1 == groupMinSizeIndex ? arg.length() - 2 : groupMinSizeIndex - 2;
                    this.groupTag = AsciiEncoding.parseLongAscii(arg, 2, lengthToParse);
                }
                if (-1 == groupMinSizeIndex) continue;
                this.groupMinSize = AsciiEncoding.parseIntAscii(arg, groupMinSizeIndex + 1, arg.length() - (groupMinSizeIndex + 1));
            }
        }
    }

    private void receiverAdded(long receiverId, int sessionId, int streamId, String channel, int receiverCount) {
    }

    private void receiverRemoved(long receiverId, int sessionId, int streamId, String channel, int receiverCount) {
    }

    static final class Receiver {
        final int sessionId;
        final int streamId;
        final long receiverId;
        long lastPosition;
        long lastPositionPlusWindow;
        long timeOfLastStatusMessageNs;

        Receiver(long receiverId, int sessionId, int streamId, long lastPosition, long lastPositionPlusWindow, long timeNs) {
            this.receiverId = receiverId;
            this.sessionId = sessionId;
            this.streamId = streamId;
            this.lastPosition = lastPosition;
            this.lastPositionPlusWindow = lastPositionPlusWindow;
            this.timeOfLastStatusMessageNs = timeNs;
        }
    }
}

