/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.exceptions.AeronException;

public class ArchiveException
extends AeronException {
    public static final int GENERIC = 0;
    public static final int ACTIVE_LISTING = 1;
    public static final int ACTIVE_RECORDING = 2;
    public static final int ACTIVE_SUBSCRIPTION = 3;
    public static final int UNKNOWN_SUBSCRIPTION = 4;
    public static final int UNKNOWN_RECORDING = 5;
    public static final int UNKNOWN_REPLAY = 6;
    public static final int MAX_REPLAYS = 7;
    public static final int MAX_RECORDINGS = 8;
    public static final int INVALID_EXTENSION = 9;
    public static final int AUTHENTICATION_REJECTED = 10;
    public static final int STORAGE_SPACE = 11;
    public static final int UNKNOWN_REPLICATION = 12;
    private final int errorCode;
    private final long correlationId;

    public ArchiveException() {
        this.errorCode = 0;
        this.correlationId = -1L;
    }

    public ArchiveException(String message) {
        super(message);
        this.errorCode = 0;
        this.correlationId = -1L;
    }

    public ArchiveException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
        this.correlationId = -1L;
    }

    public ArchiveException(String message, Throwable cause, int errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
        this.correlationId = -1L;
    }

    public ArchiveException(String message, int errorCode, long correlationId) {
        super(message);
        this.errorCode = errorCode;
        this.correlationId = correlationId;
    }

    public ArchiveException(String message, AeronException.Category category) {
        super(message, category);
        this.errorCode = 0;
        this.correlationId = -1L;
    }

    public ArchiveException(String message, long correlationId, AeronException.Category category) {
        super(message, category);
        this.errorCode = 0;
        this.correlationId = correlationId;
    }

    public ArchiveException(String message, int errorCode, long correlationId, AeronException.Category category) {
        super(message, category);
        this.errorCode = errorCode;
        this.correlationId = correlationId;
    }

    public int errorCode() {
        return this.errorCode;
    }

    public long correlationId() {
        return this.correlationId;
    }
}

