/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.archive.RecordingSummary;
import io.aeron.archive.SimpleFragmentHandler;
import io.aeron.archive.client.AeronArchive;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

class RecordingReader
implements AutoCloseable {
    private static final EnumSet<StandardOpenOption> FILE_OPTIONS = EnumSet.of(StandardOpenOption.READ);
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    private final File archiveDir;
    private final long recordingId;
    private final int segmentLength;
    private final int termLength;
    private final UnsafeBuffer termBuffer;
    private MappedByteBuffer mappedSegmentBuffer;
    private final long replayLimit;
    private long replayPosition;
    private long segmentFilePosition;
    private int termOffset;
    private int termBaseSegmentOffset;
    private boolean isDone = false;

    RecordingReader(RecordingSummary recordingSummary, File archiveDir, long position, long length) {
        long replayLength;
        if (position < -1L) {
            throw new IllegalArgumentException("invalid position: " + position);
        }
        if (length < -1L) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        this.archiveDir = archiveDir;
        this.termLength = recordingSummary.termBufferLength;
        this.segmentLength = recordingSummary.segmentFileLength;
        this.recordingId = recordingSummary.recordingId;
        long startPosition = recordingSummary.startPosition;
        long fromPosition = position == -1L ? startPosition : position;
        long maxLength = recordingSummary.stopPosition != -1L ? recordingSummary.stopPosition - fromPosition : Long.MAX_VALUE - fromPosition;
        long l = replayLength = length == -1L ? maxLength : Math.min(length, maxLength);
        if (replayLength < 0L) {
            throw new IllegalArgumentException("length must be positive");
        }
        int positionBitsToShift = LogBufferDescriptor.positionBitsToShift(this.termLength);
        long startTermBasePosition = startPosition - (startPosition & (long)(this.termLength - 1));
        int segmentOffset = (int)(fromPosition - startTermBasePosition) & this.segmentLength - 1;
        int termId = (int)(fromPosition >> positionBitsToShift) + recordingSummary.initialTermId;
        this.segmentFilePosition = AeronArchive.segmentFileBasePosition(startPosition, fromPosition, this.termLength, this.segmentLength);
        this.openRecordingSegment();
        this.termOffset = (int)(fromPosition & (long)(this.termLength - 1));
        this.termBaseSegmentOffset = segmentOffset - this.termOffset;
        this.termBuffer = new UnsafeBuffer(this.mappedSegmentBuffer, this.termBaseSegmentOffset, this.termLength);
        if (fromPosition > startPosition && (DataHeaderFlyweight.termOffset(this.termBuffer, this.termOffset) != this.termOffset || DataHeaderFlyweight.termId(this.termBuffer, this.termOffset) != termId || DataHeaderFlyweight.streamId(this.termBuffer, this.termOffset) != recordingSummary.streamId)) {
            this.close();
            throw new IllegalArgumentException(fromPosition + " position not aligned to valid fragment");
        }
        this.replayPosition = fromPosition;
        this.replayLimit = fromPosition + replayLength;
    }

    @Override
    public void close() {
        this.closeRecordingSegment();
    }

    long recordingId() {
        return this.recordingId;
    }

    long replayPosition() {
        return this.replayPosition;
    }

    boolean isDone() {
        return this.isDone;
    }

    int poll(SimpleFragmentHandler fragmentHandler, int fragmentLimit) {
        int fragments;
        for (fragments = 0; this.replayPosition < this.replayLimit && fragments < fragmentLimit; ++fragments) {
            int frameOffset;
            UnsafeBuffer termBuffer;
            int frameLength;
            if (this.termOffset == this.termLength) {
                this.nextTerm();
            }
            if ((frameLength = FrameDescriptor.frameLength(termBuffer = this.termBuffer, frameOffset = this.termOffset)) <= 0) {
                this.isDone = true;
                this.closeRecordingSegment();
                break;
            }
            int frameType = FrameDescriptor.frameType(termBuffer, frameOffset);
            byte flags = FrameDescriptor.frameFlags(termBuffer, frameOffset);
            long reservedValue = termBuffer.getLong(frameOffset + 24, ByteOrder.LITTLE_ENDIAN);
            int alignedLength = BitUtil.align(frameLength, 32);
            int dataOffset = frameOffset + 32;
            int dataLength = frameLength - 32;
            fragmentHandler.onFragment(termBuffer, dataOffset, dataLength, frameType, flags, reservedValue);
            this.replayPosition += (long)alignedLength;
            this.termOffset += alignedLength;
            if (this.replayPosition < this.replayLimit) continue;
            this.isDone = true;
            this.closeRecordingSegment();
            break;
        }
        return fragments;
    }

    private void nextTerm() {
        this.termOffset = 0;
        this.termBaseSegmentOffset += this.termLength;
        if (this.termBaseSegmentOffset == this.segmentLength) {
            this.closeRecordingSegment();
            this.segmentFilePosition += (long)this.segmentLength;
            this.openRecordingSegment();
            this.termBaseSegmentOffset = 0;
        }
        this.termBuffer.wrap(this.mappedSegmentBuffer, this.termBaseSegmentOffset, this.termLength);
    }

    private void closeRecordingSegment() {
        MappedByteBuffer mappedSegmentBuffer = this.mappedSegmentBuffer;
        this.mappedSegmentBuffer = null;
        BufferUtil.free(mappedSegmentBuffer);
    }

    private void openRecordingSegment() {
        String segmentFileName = Archive.segmentFileName(this.recordingId, this.segmentFilePosition);
        File segmentFile = new File(this.archiveDir, segmentFileName);
        if (!segmentFile.exists()) {
            throw new IllegalArgumentException("failed to open recording segment file " + segmentFileName);
        }
        try (FileChannel channel = FileChannel.open(segmentFile.toPath(), FILE_OPTIONS, NO_ATTRIBUTES);){
            this.mappedSegmentBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.segmentLength);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }
}

