/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import java.util.Arrays;
import org.agrona.DirectBuffer;

public final class DirectBufferVector {
    private DirectBuffer buffer;
    private int offset;
    private int length;

    public DirectBufferVector() {
    }

    public DirectBufferVector(DirectBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public DirectBufferVector reset(DirectBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public DirectBufferVector buffer(DirectBuffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public int offset() {
        return this.offset;
    }

    public DirectBufferVector offset(int offset) {
        this.offset = offset;
        return this;
    }

    public int length() {
        return this.length;
    }

    public DirectBufferVector length(int length) {
        this.length = length;
        return this;
    }

    public DirectBufferVector validate() {
        int capacity = this.buffer.capacity();
        if (this.offset < 0 || this.offset >= capacity) {
            throw new IllegalArgumentException("offset=" + this.offset + " capacity=" + capacity);
        }
        if (this.length < 0 || this.length > capacity - this.offset) {
            throw new IllegalArgumentException("offset=" + this.offset + " capacity=" + capacity + " length=" + this.length);
        }
        return this;
    }

    public String toString() {
        return "DirectBufferVector{buffer=" + this.buffer + ", offset=" + this.offset + ", length=" + this.length + '}';
    }

    public static int validateAndComputeLength(DirectBufferVector[] vectors) {
        int messageLength = 0;
        for (DirectBufferVector vector : vectors) {
            vector.validate();
            if ((messageLength += vector.length) >= 0) continue;
            throw new IllegalStateException("length overflow: " + Arrays.toString(vectors));
        }
        return messageLength;
    }
}

