/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.SequenceDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class SequenceEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 4;
    public static final int TEMPLATE_ID = 9;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SequenceEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    @Override
    public int sbeBlockLength() {
        return 4;
    }

    @Override
    public int sbeTemplateId() {
        return 9;
    }

    @Override
    public int sbeSchemaId() {
        return 1;
    }

    @Override
    public int sbeSchemaVersion() {
        return 0;
    }

    @Override
    public String sbeSemanticType() {
        return "";
    }

    @Override
    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public SequenceEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 4);
        return this;
    }

    public SequenceEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(4).templateId(9).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    @Override
    public int encodedLength() {
        return this.limit - this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int nextSeqNoId() {
        return 35526;
    }

    public static int nextSeqNoSinceVersion() {
        return 0;
    }

    public static int nextSeqNoEncodingOffset() {
        return 0;
    }

    public static int nextSeqNoEncodingLength() {
        return 4;
    }

    public static String nextSeqNoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long nextSeqNoNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long nextSeqNoMinValue() {
        return 0L;
    }

    public static long nextSeqNoMaxValue() {
        return 0xFFFFFFFEL;
    }

    public SequenceEncoder nextSeqNo(long value) {
        this.buffer.putInt(this.offset + 0, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SequenceDecoder decoder = new SequenceDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 4, 0);
        return decoder.appendTo(builder);
    }
}

